/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client;

import com.alibaba.hologres.client.model.Record;
import com.alibaba.hologres.client.model.TableSchema;
import java.security.InvalidParameterException;

public class Put {
    Record record;

    public Put(TableSchema schema) {
        this.record = Record.build(schema);
        this.record.setType(MutationType.INSERT);
    }

    public Put(Record record) {
        this.record = record;
    }

    public Record getRecord() {
        return this.record;
    }

    public Put setObject(int i, Object obj, boolean onlyInsert) {
        this.record.setObject(i, obj);
        if (onlyInsert) {
            this.record.getOnlyInsertColumnSet().set(i);
        }
        return this;
    }

    public Put setObject(int i, Object obj) {
        return this.setObject(i, obj, false);
    }

    public Put setObject(String columnName, Object obj) {
        return this.setObject(columnName, obj, false);
    }

    public Put setObject(String columnName, Object obj, boolean onlyInsert) {
        Integer i = this.record.getSchema().getColumnIndex(columnName);
        if (i == null) {
            throw new InvalidParameterException("can not found column named " + columnName);
        }
        this.setObject(i, obj, onlyInsert);
        return this;
    }

    public Object getObject(int i) {
        return this.record.getObject(i);
    }

    public boolean isSet(int i) {
        return this.record.isSet(i);
    }

    public static enum MutationType {
        INSERT,
        DELETE;

    }
}

