/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.blink.util.hash;

import com.alibaba.blink.memory.MemorySegment;
import com.alibaba.blink.memory.MemoryUtils;
import sun.misc.Unsafe;

public final class Murmur32 {
    private static final Unsafe UNSAFE = MemoryUtils.UNSAFE;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    public static final int DEFAULT_SEED = 42;
    private static final int R1 = 31;
    private static final int R2 = 27;
    private static final int M = 5;
    private static final int N1 = 1390208809;

    public static int hashUnsafeWords(Object base, long offset, int lengthInBytes, int seed) {
        int h1 = Murmur32.hashUnsafeBytesByInt(base, offset, lengthInBytes, seed);
        return Murmur32.fmix(h1, lengthInBytes);
    }

    public static int hashUnsafeBytes(Object base, long offset, int lengthInBytes, int seed) {
        assert (lengthInBytes >= 0) : "lengthInBytes cannot be negative";
        int lengthAligned = lengthInBytes - lengthInBytes % 4;
        int h1 = Murmur32.hashUnsafeBytesByInt(base, offset, lengthAligned, seed);
        for (int i = lengthAligned; i < lengthInBytes; ++i) {
            byte halfWord = UNSAFE.getByte(base, offset + (long)i);
            int k1 = Murmur32.mixK1(halfWord);
            h1 = Murmur32.mixH1(h1, k1);
        }
        return Murmur32.fmix(h1, lengthInBytes);
    }

    private static int hashUnsafeBytesByInt(Object base, long offset, int lengthInBytes, int seed) {
        assert (lengthInBytes % 4 == 0);
        int h1 = seed;
        for (int i = 0; i < lengthInBytes; i += 4) {
            int halfWord = UNSAFE.getInt(base, offset + (long)i);
            int k1 = Murmur32.mixK1(halfWord);
            h1 = Murmur32.mixH1(h1, k1);
        }
        return h1;
    }

    public static int hashBytesByWords(MemorySegment segment, int offset, int lengthInBytes, int seed) {
        int h1 = Murmur32.hashBytesByInt(segment, offset, lengthInBytes, seed);
        return Murmur32.fmix(h1, lengthInBytes);
    }

    public static int hashBytes(MemorySegment segment, int offset, int lengthInBytes, int seed) {
        int lengthAligned = lengthInBytes - lengthInBytes % 4;
        int h1 = Murmur32.hashBytesByInt(segment, offset, lengthAligned, seed);
        for (int i = lengthAligned; i < lengthInBytes; ++i) {
            int k1 = Murmur32.mixK1(segment.get(offset + i));
            h1 = Murmur32.mixH1(h1, k1);
        }
        return Murmur32.fmix(h1, lengthInBytes);
    }

    public static long hash64(MemorySegment data, int offset, int length) {
        return Murmur32.hash64(data, offset, length, 42);
    }

    private static long hashBytesByLong(MemorySegment segment, int offset, int lengthInBytes, int seed) {
        assert (lengthInBytes % 8 == 0);
        long hash = seed;
        for (int i = 0; i < lengthInBytes; i += 8) {
            long k = segment.getLong(offset + i);
            k *= -862048943L;
            k = Long.rotateLeft(k, 31);
            hash ^= (k *= 461845907L);
            hash = Long.rotateLeft(hash, 27) * 5L + 1390208809L;
        }
        return hash;
    }

    public static long hash64(MemorySegment segment, int offset, int lengthInBytes, int seed) {
        int lengthAligned = lengthInBytes - lengthInBytes % 8;
        long hash = Murmur32.hashBytesByLong(segment, offset, lengthAligned, seed);
        long k1 = 0L;
        for (int i = lengthInBytes - lengthAligned; i > 0; --i) {
            k1 ^= ((long)segment.get(offset + lengthAligned + i - 1) & 0xFFL) << (i - 1) * 8;
            if (i != 1) continue;
            k1 *= -862048943L;
            k1 = Long.rotateLeft(k1, 31);
            hash ^= (k1 *= 461845907L);
        }
        return Murmur32.fmix(hash ^= (long)lengthInBytes);
    }

    public static long hashUnsafe64(Object base, int offset, int lengthInBytes, int seed) {
        int lengthAligned = lengthInBytes - lengthInBytes % 8;
        long hash = Murmur32.hashUnsafe64ByLong(base, offset, lengthAligned, seed);
        long k1 = 0L;
        for (int i = lengthInBytes - lengthAligned; i > 0; --i) {
            k1 ^= ((long)UNSAFE.getByte(base, offset + lengthAligned + i - 1) & 0xFFL) << (i - 1) * 8;
            if (i != 1) continue;
            k1 *= -862048943L;
            k1 = Long.rotateLeft(k1, 31);
            hash ^= (k1 *= 461845907L);
        }
        return Murmur32.fmix(hash ^= (long)lengthInBytes);
    }

    private static long hashUnsafe64ByLong(Object base, int offset, int lengthInBytes, int seed) {
        assert (lengthInBytes % 8 == 0);
        long hash = seed;
        for (int i = 0; i < lengthInBytes; i += 8) {
            long k = UNSAFE.getLong(base, offset + i);
            k *= -862048943L;
            k = Long.rotateLeft(k, 31);
            hash ^= (k *= 461845907L);
            hash = Long.rotateLeft(hash, 27) * 5L + 1390208809L;
        }
        return hash;
    }

    private static int hashBytesByInt(MemorySegment segment, int offset, int lengthInBytes, int seed) {
        assert (lengthInBytes % 4 == 0);
        int h1 = seed;
        for (int i = 0; i < lengthInBytes; i += 4) {
            int halfWord = segment.getInt(offset + i);
            int k1 = Murmur32.mixK1(halfWord);
            h1 = Murmur32.mixH1(h1, k1);
        }
        return h1;
    }

    private static int mixK1(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        return k1 *= 461845907;
    }

    private static int mixH1(int h1, int k1) {
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        return h1;
    }

    private static int fmix(int h1, int length) {
        return Murmur32.fmix(h1 ^= length);
    }

    public static int fmix(int h2) {
        h2 ^= h2 >>> 16;
        h2 *= -2048144789;
        h2 ^= h2 >>> 13;
        h2 *= -1028477387;
        h2 ^= h2 >>> 16;
        return h2;
    }

    public static long fmix(long h2) {
        h2 ^= h2 >>> 33;
        h2 *= -49064778989728563L;
        h2 ^= h2 >>> 33;
        h2 *= -4265267296055464877L;
        h2 ^= h2 >>> 33;
        return h2;
    }
}

