/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.blink.memory;

import com.alibaba.blink.memory.MemoryUtils;
import com.alibaba.blink.util.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

public abstract class MemorySegment {
    protected static final Unsafe UNSAFE = MemoryUtils.UNSAFE;
    protected static final long BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    private static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    protected byte[] heapMemory;
    protected long address;
    protected long addressLimit;
    protected int size;
    protected Object owner;

    MemorySegment(byte[] buffer, Object owner) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        this.heapMemory = buffer;
        this.address = BYTE_ARRAY_BASE_OFFSET;
        this.size = buffer.length;
        this.addressLimit = this.address + (long)this.size;
        this.owner = owner;
    }

    MemorySegment(long offHeapAddress, int size, Object owner) {
        if (offHeapAddress <= 0L) {
            throw new IllegalArgumentException("negative pointer or size");
        }
        if (offHeapAddress >= 9223372034707292160L) {
            throw new IllegalArgumentException("Segment initialized with too large address: " + offHeapAddress + " ; Max allowed address is " + 0x7FFFFFFF7FFFFFFFL);
        }
        this.heapMemory = null;
        this.address = offHeapAddress;
        this.addressLimit = this.address + (long)size;
        this.size = size;
        this.owner = owner;
    }

    public int size() {
        return this.size;
    }

    public boolean isFreed() {
        return this.address > this.addressLimit;
    }

    public void free() {
        this.address = this.addressLimit + 1L;
    }

    public boolean isOffHeap() {
        return this.heapMemory == null;
    }

    public byte[] getArray() {
        if (this.heapMemory != null) {
            return this.heapMemory;
        }
        throw new IllegalStateException("Memory segment does not represent heap memory");
    }

    public long getAddress() {
        if (this.heapMemory == null) {
            return this.address;
        }
        throw new IllegalStateException("Memory segment does not represent off heap memory");
    }

    public abstract ByteBuffer wrap(int var1, int var2);

    public Object getOwner() {
        return this.owner;
    }

    public abstract byte get(int var1);

    public abstract void put(int var1, byte var2);

    public abstract void get(int var1, byte[] var2);

    public abstract void put(int var1, byte[] var2);

    public abstract void get(int var1, byte[] var2, int var3, int var4);

    public abstract void put(int var1, byte[] var2, int var3, int var4);

    public abstract boolean getBoolean(int var1);

    public abstract void putBoolean(int var1, boolean var2);

    public final char getChar(int index) {
        long pos = this.address + (long)index;
        if (index >= 0 && pos <= this.addressLimit - 2L) {
            return UNSAFE.getChar(this.heapMemory, pos);
        }
        if (this.address > this.addressLimit) {
            throw new IllegalStateException("This segment has been freed.");
        }
        throw new IndexOutOfBoundsException();
    }

    public final char getCharLittleEndian(int index) {
        if (LITTLE_ENDIAN) {
            return this.getChar(index);
        }
        return Character.reverseBytes(this.getChar(index));
    }

    public final char getCharBigEndian(int index) {
        if (LITTLE_ENDIAN) {
            return Character.reverseBytes(this.getChar(index));
        }
        return this.getChar(index);
    }

    public final void putChar(int index, char value) {
        long pos = this.address + (long)index;
        if (index < 0 || pos > this.addressLimit - 2L) {
            if (this.address > this.addressLimit) {
                throw new IllegalStateException("segment has been freed");
            }
            throw new IndexOutOfBoundsException();
        }
        UNSAFE.putChar(this.heapMemory, pos, value);
    }

    public final void putCharLittleEndian(int index, char value) {
        if (LITTLE_ENDIAN) {
            this.putChar(index, value);
        } else {
            this.putChar(index, Character.reverseBytes(value));
        }
    }

    public final void putCharBigEndian(int index, char value) {
        if (LITTLE_ENDIAN) {
            this.putChar(index, Character.reverseBytes(value));
        } else {
            this.putChar(index, value);
        }
    }

    public final short getShort(int index) {
        long pos = this.address + (long)index;
        if (index >= 0 && pos <= this.addressLimit - 2L) {
            return UNSAFE.getShort(this.heapMemory, pos);
        }
        if (this.address > this.addressLimit) {
            throw new IllegalStateException("segment has been freed");
        }
        throw new IndexOutOfBoundsException();
    }

    public final short getShortLittleEndian(int index) {
        if (LITTLE_ENDIAN) {
            return this.getShort(index);
        }
        return Short.reverseBytes(this.getShort(index));
    }

    public final short getShortBigEndian(int index) {
        if (LITTLE_ENDIAN) {
            return Short.reverseBytes(this.getShort(index));
        }
        return this.getShort(index);
    }

    public final void putShort(int index, short value) {
        long pos = this.address + (long)index;
        if (index < 0 || pos > this.addressLimit - 2L) {
            if (this.address > this.addressLimit) {
                throw new IllegalStateException("segment has been freed");
            }
            throw new IndexOutOfBoundsException();
        }
        UNSAFE.putShort(this.heapMemory, pos, value);
    }

    public final void putShortLittleEndian(int index, short value) {
        if (LITTLE_ENDIAN) {
            this.putShort(index, value);
        } else {
            this.putShort(index, Short.reverseBytes(value));
        }
    }

    public final void putShortBigEndian(int index, short value) {
        if (LITTLE_ENDIAN) {
            this.putShort(index, Short.reverseBytes(value));
        } else {
            this.putShort(index, value);
        }
    }

    public final int getInt(int index) {
        long pos = this.address + (long)index;
        if (index >= 0 && pos <= this.addressLimit - 4L) {
            return UNSAFE.getInt(this.heapMemory, pos);
        }
        if (this.address > this.addressLimit) {
            throw new IllegalStateException("segment has been freed");
        }
        throw new IndexOutOfBoundsException();
    }

    public final int getIntLittleEndian(int index) {
        if (LITTLE_ENDIAN) {
            return this.getInt(index);
        }
        return Integer.reverseBytes(this.getInt(index));
    }

    public final int getIntBigEndian(int index) {
        if (LITTLE_ENDIAN) {
            return Integer.reverseBytes(this.getInt(index));
        }
        return this.getInt(index);
    }

    public final void putInt(int index, int value) {
        long pos = this.address + (long)index;
        if (index < 0 || pos > this.addressLimit - 4L) {
            if (this.address > this.addressLimit) {
                throw new IllegalStateException("segment has been freed");
            }
            throw new IndexOutOfBoundsException();
        }
        UNSAFE.putInt(this.heapMemory, pos, value);
    }

    public final void putIntLittleEndian(int index, int value) {
        if (LITTLE_ENDIAN) {
            this.putInt(index, value);
        } else {
            this.putInt(index, Integer.reverseBytes(value));
        }
    }

    public final void putIntBigEndian(int index, int value) {
        if (LITTLE_ENDIAN) {
            this.putInt(index, Integer.reverseBytes(value));
        } else {
            this.putInt(index, value);
        }
    }

    public final long getLong(int index) {
        long pos = this.address + (long)index;
        if (index >= 0 && pos <= this.addressLimit - 8L) {
            return UNSAFE.getLong(this.heapMemory, pos);
        }
        if (this.address > this.addressLimit) {
            throw new IllegalStateException("segment has been freed");
        }
        throw new IndexOutOfBoundsException();
    }

    public final long getLongLittleEndian(int index) {
        if (LITTLE_ENDIAN) {
            return this.getLong(index);
        }
        return Long.reverseBytes(this.getLong(index));
    }

    public final long getLongBigEndian(int index) {
        if (LITTLE_ENDIAN) {
            return Long.reverseBytes(this.getLong(index));
        }
        return this.getLong(index);
    }

    public final void putLong(int index, long value) {
        long pos = this.address + (long)index;
        if (index < 0 || pos > this.addressLimit - 8L) {
            if (this.address > this.addressLimit) {
                throw new IllegalStateException("segment has been freed");
            }
            throw new IndexOutOfBoundsException();
        }
        UNSAFE.putLong(this.heapMemory, pos, value);
    }

    public final void putLongLittleEndian(int index, long value) {
        if (LITTLE_ENDIAN) {
            this.putLong(index, value);
        } else {
            this.putLong(index, Long.reverseBytes(value));
        }
    }

    public final void putLongBigEndian(int index, long value) {
        if (LITTLE_ENDIAN) {
            this.putLong(index, Long.reverseBytes(value));
        } else {
            this.putLong(index, value);
        }
    }

    public final float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    public final float getFloatLittleEndian(int index) {
        return Float.intBitsToFloat(this.getIntLittleEndian(index));
    }

    public final float getFloatBigEndian(int index) {
        return Float.intBitsToFloat(this.getIntBigEndian(index));
    }

    public final void putFloat(int index, float value) {
        this.putInt(index, Float.floatToRawIntBits(value));
    }

    public final void putFloatLittleEndian(int index, float value) {
        this.putIntLittleEndian(index, Float.floatToRawIntBits(value));
    }

    public final void putFloatBigEndian(int index, float value) {
        this.putIntBigEndian(index, Float.floatToRawIntBits(value));
    }

    public final double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    public final double getDoubleLittleEndian(int index) {
        return Double.longBitsToDouble(this.getLongLittleEndian(index));
    }

    public final double getDoubleBigEndian(int index) {
        return Double.longBitsToDouble(this.getLongBigEndian(index));
    }

    public final void putDouble(int index, double value) {
        this.putLong(index, Double.doubleToRawLongBits(value));
    }

    public final void putDoubleLittleEndian(int index, double value) {
        this.putLongLittleEndian(index, Double.doubleToRawLongBits(value));
    }

    public final void putDoubleBigEndian(int index, double value) {
        this.putLongBigEndian(index, Double.doubleToRawLongBits(value));
    }

    public abstract void get(DataOutput var1, int var2, int var3) throws IOException;

    public abstract void put(DataInput var1, int var2, int var3) throws IOException;

    public abstract void get(int var1, ByteBuffer var2, int var3);

    public abstract void put(int var1, ByteBuffer var2, int var3);

    public final void copyTo(int offset, MemorySegment target, int targetOffset, int numBytes) {
        byte[] thisHeapRef = this.heapMemory;
        byte[] otherHeapRef = target.heapMemory;
        long thisPointer = this.address + (long)offset;
        long otherPointer = target.address + (long)targetOffset;
        if ((numBytes | offset | targetOffset) < 0 || thisPointer > this.addressLimit - (long)numBytes || otherPointer > target.addressLimit - (long)numBytes) {
            if (this.address > this.addressLimit) {
                throw new IllegalStateException("this memory segment has been freed.");
            }
            if (target.address > target.addressLimit) {
                throw new IllegalStateException("target memory segment has been freed.");
            }
            throw new IndexOutOfBoundsException(String.format("offset=%d, targetOffset=%d, numBytes=%d, address=%d, targetAddress=%d", offset, targetOffset, numBytes, this.address, target.address));
        }
        UNSAFE.copyMemory(thisHeapRef, thisPointer, otherHeapRef, otherPointer, numBytes);
    }

    public final int compare(MemorySegment seg2, int offset1, int offset2, int len) {
        while (len >= 8) {
            long l2;
            long l1 = this.getLongBigEndian(offset1);
            if (l1 != (l2 = seg2.getLongBigEndian(offset2))) {
                return l1 < l2 ^ l1 < 0L ^ l2 < 0L ? -1 : 1;
            }
            offset1 += 8;
            offset2 += 8;
            len -= 8;
        }
        while (len > 0) {
            int b2;
            int b1 = this.get(offset1) & 0xFF;
            int cmp = b1 - (b2 = seg2.get(offset2) & 0xFF);
            if (cmp != 0) {
                return cmp;
            }
            ++offset1;
            ++offset2;
            --len;
        }
        return 0;
    }

    public final boolean equalTo(MemorySegment seg2, int offset1, int offset2, int len) {
        while (len >= 8) {
            if (this.getLong(offset1) != seg2.getLong(offset2)) {
                return false;
            }
            offset1 += 8;
            offset2 += 8;
            len -= 8;
        }
        while (len > 0) {
            if (this.get(offset1) != seg2.get(offset2)) {
                return false;
            }
            ++offset1;
            ++offset2;
            --len;
        }
        return true;
    }

    public final void swapBytes(byte[] tempBuffer, MemorySegment seg2, int offset1, int offset2, int len) {
        if ((offset1 | offset2 | len | tempBuffer.length - len) >= 0) {
            long thisPos = this.address + (long)offset1;
            long otherPos = seg2.address + (long)offset2;
            if (thisPos <= this.addressLimit - (long)len && otherPos <= seg2.addressLimit - (long)len) {
                UNSAFE.copyMemory(this.heapMemory, thisPos, tempBuffer, BYTE_ARRAY_BASE_OFFSET, len);
                UNSAFE.copyMemory(seg2.heapMemory, otherPos, this.heapMemory, thisPos, len);
                UNSAFE.copyMemory(tempBuffer, BYTE_ARRAY_BASE_OFFSET, seg2.heapMemory, otherPos, len);
                return;
            }
            if (this.address > this.addressLimit) {
                throw new IllegalStateException("this memory segment has been freed.");
            }
            if (seg2.address > seg2.addressLimit) {
                throw new IllegalStateException("other memory segment has been freed.");
            }
        }
        throw new IndexOutOfBoundsException(String.format("offset1=%d, offset2=%d, len=%d, bufferSize=%d, address1=%d, address2=%d", offset1, offset2, len, tempBuffer.length, this.address, seg2.address));
    }

    public final void copyToUnsafe(int offset, Object target, int targetPointer, int numBytes) {
        long thisPointer = this.address + (long)offset;
        Preconditions.checkArgument(thisPointer + (long)numBytes <= this.addressLimit);
        UNSAFE.copyMemory(this.heapMemory, thisPointer, target, targetPointer, numBytes);
    }

    public final void copyFromUnsafe(int offset, Object source, int sourcePointer, int numBytes) {
        long thisPointer = this.address + (long)offset;
        Preconditions.checkArgument(thisPointer + (long)numBytes <= this.addressLimit);
        UNSAFE.copyMemory(source, sourcePointer, this.heapMemory, thisPointer, numBytes);
    }

    public byte[] getHeapMemory() {
        return this.heapMemory;
    }

    public void pointTo(byte[] buffer) {
        this.heapMemory = buffer;
        this.address = BYTE_ARRAY_BASE_OFFSET;
        this.size = buffer.length;
        this.addressLimit = this.address + (long)this.size;
        this.owner = null;
    }

    public abstract MemorySegment cloneReference();
}

