/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.blink.dataformat;

import com.alibaba.blink.dataformat.MultiSegUtil;
import com.alibaba.blink.memory.MemorySegment;
import com.alibaba.blink.memory.MemorySegmentFactory;
import com.alibaba.blink.util.BinaryRowUtil;
import com.alibaba.blink.util.Preconditions;
import com.alibaba.blink.util.StringUtf8Utils;
import com.alibaba.blink.util.hash.Murmur32;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Arrays;

public final class BinaryString
implements Comparable<BinaryString>,
Cloneable,
KryoSerializable {
    public static final BinaryString COMMA_UTF8 = BinaryString.fromString(",");
    public static final BinaryString EMPTY_UTF8 = BinaryString.fromString("");
    public static final BinaryString SPACE_UTF8 = BinaryString.fromString(" ");
    private static final double[] FAST_POW10 = new double[]{10.0, 100.0, 10000.0, 1.0E8, 1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
    private MemorySegment[] segments;
    private int offset;
    private int numBytes;
    private transient String javaString;

    public BinaryString() {
    }

    private BinaryString(MemorySegment[] segments, int offset, int numBytes) {
        this.segments = segments;
        this.offset = offset;
        this.numBytes = numBytes;
    }

    public void pointTo(MemorySegment[] segments, int offset, int numBytes) {
        this.segments = segments;
        this.offset = offset;
        this.numBytes = numBytes;
        this.javaString = null;
    }

    public void pointTo(byte[] bytes, int offset, int numBytes) {
        if (this.segments != null && this.segments.length == 1) {
            this.segments[0].pointTo(bytes);
        } else {
            this.segments = new MemorySegment[]{MemorySegmentFactory.wrap(bytes)};
        }
        this.offset = offset;
        this.numBytes = numBytes;
        this.javaString = null;
    }

    public static BinaryString fromAddress(MemorySegment[] segments, int offset, int numBytes) {
        return new BinaryString(segments, offset, numBytes);
    }

    public static BinaryString fromString(String str) {
        if (str == null) {
            return null;
        }
        return BinaryString.fromNonNullString(str);
    }

    private static BinaryString fromNonNullString(String str) {
        BinaryString ret = BinaryString.fromBytes(StringUtf8Utils.encodeUTF8(str));
        ret.javaString = str;
        return ret;
    }

    public static BinaryString fromString(BinaryString str) {
        return str;
    }

    public static BinaryString fromString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return BinaryString.fromNonNullString((String)obj);
        }
        if (obj instanceof BinaryString) {
            return (BinaryString)obj;
        }
        return BinaryString.fromNonNullString(obj.toString());
    }

    public static BinaryString fromBytes(byte[] bytes) {
        if (bytes != null) {
            return BinaryString.fromBytes(bytes, 0, bytes.length);
        }
        return null;
    }

    public static BinaryString fromBytes(byte[] bytes, int offset, int numBytes) {
        return new BinaryString(new MemorySegment[]{MemorySegmentFactory.wrap(bytes)}, offset, numBytes);
    }

    public static BinaryString blankString(int length) {
        byte[] spaces = new byte[length];
        Arrays.fill(spaces, (byte)32);
        return BinaryString.fromBytes(spaces);
    }

    private static int numBytesForFirstByte(byte b) {
        if (b >= 0) {
            return 1;
        }
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return 2;
        }
        if (b >> 4 == -2) {
            return 3;
        }
        if (b >> 3 == -2) {
            return 4;
        }
        throw new UnsupportedOperationException();
    }

    public int getOffset() {
        return this.offset;
    }

    public MemorySegment[] getSegments() {
        return this.segments;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setNumBytes(int numBytes) {
        this.numBytes = numBytes;
    }

    public int numBytes() {
        return this.numBytes;
    }

    public int numChars() {
        if (this.inOneSeg()) {
            int len = 0;
            for (int i = 0; i < this.numBytes; i += BinaryString.numBytesForFirstByte(this.getByteOneSeg(i))) {
                ++len;
            }
            return len;
        }
        return this.numCharsSlow();
    }

    private int numCharsSlow() {
        int len = 0;
        int segSize = this.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        int i = 0;
        while (i < this.numBytes) {
            int charBytes = BinaryString.numBytesForFirstByte(index.value());
            i += charBytes;
            ++len;
            index.skipBytes(charBytes, segSize);
        }
        return len;
    }

    public byte getByte(int i) {
        int globalOffset = this.offset + i;
        int size = this.segments[0].size();
        if (globalOffset < size) {
            return this.segments[0].get(globalOffset);
        }
        return this.segments[globalOffset / size].get(globalOffset % size);
    }

    public byte getByteOneSeg(int i) {
        return this.segments[0].get(this.offset + i);
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof BinaryString) {
            BinaryString other = (BinaryString)o;
            return this.numBytes == other.numBytes && BinaryRowUtil.equals(this.segments, this.offset, other.segments, other.offset, this.numBytes);
        }
        return false;
    }

    @Override
    public int compareTo(BinaryString other) {
        if (this.segments.length == 1 && other.segments.length == 1) {
            int len = Math.min(this.numBytes, other.numBytes);
            MemorySegment seg1 = this.segments[0];
            MemorySegment seg2 = other.segments[0];
            for (int i = 0; i < len; ++i) {
                int res = (seg1.get(this.offset + i) & 0xFF) - (seg2.get(other.offset + i) & 0xFF);
                if (res == 0) continue;
                return res;
            }
            return this.numBytes - other.numBytes;
        }
        return this.compareComplex(other);
    }

    private int compareComplex(BinaryString other) {
        int sizeOfFirst1;
        if (this.numBytes == 0 || other.numBytes == 0) {
            return this.numBytes - other.numBytes;
        }
        int len = Math.min(this.numBytes, other.numBytes);
        MemorySegment seg1 = this.segments[0];
        MemorySegment seg2 = other.segments[0];
        int segmentSize = this.segments[0].size();
        int otherSegmentSize = other.segments[0].size();
        int sizeOfFirst2 = otherSegmentSize - other.offset;
        int varSegIndex1 = 1;
        int varSegIndex2 = 1;
        for (sizeOfFirst1 = segmentSize - this.offset; sizeOfFirst1 <= 0; sizeOfFirst1 += segmentSize) {
            seg1 = this.segments[varSegIndex1++];
        }
        while (sizeOfFirst2 <= 0) {
            sizeOfFirst2 += otherSegmentSize;
            seg2 = other.segments[varSegIndex2++];
        }
        int offset1 = segmentSize - sizeOfFirst1;
        int offset2 = otherSegmentSize - sizeOfFirst2;
        int needCompare = Math.min(Math.min(sizeOfFirst1, sizeOfFirst2), len);
        while (needCompare > 0) {
            for (int i = 0; i < needCompare; ++i) {
                int res = (seg1.get(offset1 + i) & 0xFF) - (seg2.get(offset2 + i) & 0xFF);
                if (res == 0) continue;
                return res;
            }
            if (needCompare == len) break;
            len -= needCompare;
            if (sizeOfFirst1 < sizeOfFirst2) {
                seg1 = this.segments[varSegIndex1++];
                offset1 = 0;
                offset2 += needCompare;
                sizeOfFirst1 = segmentSize;
                sizeOfFirst2 -= needCompare;
            } else if (sizeOfFirst1 > sizeOfFirst2) {
                seg2 = other.segments[varSegIndex2++];
                offset2 = 0;
                offset1 += needCompare;
                sizeOfFirst2 = otherSegmentSize;
                sizeOfFirst1 -= needCompare;
            } else {
                seg1 = this.segments[varSegIndex1++];
                seg2 = other.segments[varSegIndex2++];
                offset1 = 0;
                offset2 = 0;
                sizeOfFirst1 = segmentSize;
                sizeOfFirst2 = otherSegmentSize;
            }
            needCompare = Math.min(Math.min(sizeOfFirst1, sizeOfFirst2), len);
        }
        Preconditions.checkArgument(needCompare == len);
        return this.numBytes - other.numBytes;
    }

    public String toString() {
        String str;
        if (this.javaString != null) {
            return this.javaString;
        }
        if (this.segments.length == 1) {
            str = StringUtf8Utils.decodeUTF8(this.segments[0], this.offset, this.numBytes);
        } else {
            byte[] bytes = StringUtf8Utils.allocateBytes(this.numBytes);
            this.copyTo(bytes);
            str = StringUtf8Utils.decodeUTF8(bytes, 0, this.numBytes);
        }
        this.javaString = str;
        return str;
    }

    public byte[] getBytes() {
        return MultiSegUtil.getBytes(this.segments, this.offset, this.numBytes);
    }

    private int decodeUTF8(char[] chars) {
        if (this.segments.length == 1) {
            return StringUtf8Utils.decodeUTF8(this.segments[0], this.offset, this.numBytes, chars);
        }
        byte[] bytes = StringUtf8Utils.allocateBytes(this.numBytes);
        this.copyTo(bytes);
        return StringUtf8Utils.decodeUTF8(bytes, 0, this.numBytes, chars);
    }

    public int hashCode() {
        if (this.segments.length == 1) {
            return Murmur32.hashBytes(this.segments[0], this.offset, this.numBytes, 42);
        }
        return this.hashSlow();
    }

    private int hashSlow() {
        return Murmur32.hashBytes(MemorySegmentFactory.wrap(this.getBytes()), 0, this.numBytes, 42);
    }

    public long hash64() {
        if (this.segments.length == 1) {
            return Murmur32.hash64(this.segments[0], this.offset, this.numBytes, 42);
        }
        return this.hashSlow();
    }

    private long hash64Slow() {
        return Murmur32.hash64(MemorySegmentFactory.wrap(this.getBytes()), 0, this.numBytes, 42);
    }

    public BinaryString copy() {
        byte[] copy = BinaryRowUtil.copy(this.segments, this.offset, this.numBytes);
        return BinaryString.fromBytes(copy);
    }

    public BinaryString cloneReference() {
        MemorySegment[] cloneSegs = new MemorySegment[this.segments.length];
        for (int i = 0; i < this.segments.length; ++i) {
            cloneSegs[i] = this.segments[i].cloneReference();
        }
        return BinaryString.fromAddress(cloneSegs, this.offset, this.numBytes);
    }

    public void copyTo(byte[] bytes) {
        BinaryRowUtil.copy(this.segments, this.offset, bytes, 0, this.numBytes);
    }

    @Override
    public void write(Kryo kryo, Output output) {
        byte[] copy = BinaryRowUtil.copy(this.segments, this.offset, this.numBytes);
        output.writeInt(this.numBytes);
        output.writeBytes(copy);
    }

    @Override
    public void read(Kryo kryo, Input input) {
        this.numBytes = input.readInt();
        byte[] bytes = input.readBytes(this.numBytes);
        this.segments = new MemorySegment[1];
        this.segments[0] = MemorySegmentFactory.wrap(bytes);
        this.offset = 0;
    }

    public static String safeToString(BinaryString str) {
        if (str == null) {
            return null;
        }
        return str.toString();
    }

    public boolean inOneSeg() {
        return this.numBytes + this.offset <= this.segments[0].size();
    }

    public BinaryString substringSQL(int pos) {
        return this.substringSQL(pos, Integer.MAX_VALUE);
    }

    public BinaryString substringSQL(int pos, int length) {
        int start;
        if (length < 0) {
            return null;
        }
        if (this.equals(EMPTY_UTF8)) {
            return EMPTY_UTF8;
        }
        int numChars = this.numChars();
        if (pos > 0) {
            start = pos - 1;
            if (start >= numChars) {
                return EMPTY_UTF8;
            }
        } else if (pos < 0) {
            start = numChars + pos;
            if (start < 0) {
                return EMPTY_UTF8;
            }
        } else {
            start = 0;
        }
        int end = numChars - start < length ? numChars : start + length;
        return this.substring(start, end);
    }

    public BinaryString substring(int start, int until) {
        if (until <= start || start >= this.numBytes) {
            return EMPTY_UTF8;
        }
        if (this.inOneSeg()) {
            int c;
            MemorySegment segment = this.segments[0];
            int i = 0;
            for (c = 0; i < this.numBytes && c < start; i += BinaryString.numBytesForFirstByte(segment.get(i + this.offset)), ++c) {
            }
            int j = i;
            while (i < this.numBytes && c < until) {
                i += BinaryString.numBytesForFirstByte(segment.get(i + this.offset));
                ++c;
            }
            if (i > j) {
                byte[] bytes = new byte[i - j];
                segment.get(this.offset + j, bytes, 0, i - j);
                return BinaryString.fromBytes(bytes);
            }
            return EMPTY_UTF8;
        }
        return this.substringSlow(start, until);
    }

    private BinaryString substringSlow(int start, int until) {
        int c;
        int charSize;
        int segSize = this.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        int i = 0;
        for (c = 0; i < this.numBytes && c < start; i += charSize, ++c) {
            charSize = BinaryString.numBytesForFirstByte(index.value());
            index.skipBytes(charSize, segSize);
        }
        int j = i;
        while (i < this.numBytes && c < until) {
            int charSize2 = BinaryString.numBytesForFirstByte(index.value());
            i += charSize2;
            index.skipBytes(charSize2, segSize);
            ++c;
        }
        if (i > j) {
            return BinaryString.fromBytes(BinaryRowUtil.copy(this.segments, this.offset + j, i - j));
        }
        return EMPTY_UTF8;
    }

    public static BinaryString concat(BinaryString ... inputs) {
        return BinaryString.concat(Arrays.asList(inputs));
    }

    public static BinaryString concat(Iterable<BinaryString> inputs) {
        int totalLength = 0;
        for (BinaryString input : inputs) {
            if (input == null) continue;
            totalLength += input.numBytes;
        }
        byte[] result = new byte[totalLength];
        int offset = 0;
        for (BinaryString input : inputs) {
            if (input == null) continue;
            int len = input.numBytes;
            BinaryRowUtil.copy(input.segments, input.offset, result, offset, len);
            offset += len;
        }
        return BinaryString.fromBytes(result);
    }

    public static BinaryString concatWs(BinaryString separator, BinaryString ... inputs) {
        return BinaryString.concatWs(separator, Arrays.asList(inputs));
    }

    public static BinaryString concatWs(BinaryString separator, Iterable<BinaryString> inputs) {
        if (null == separator || EMPTY_UTF8.equals(separator)) {
            return BinaryString.concat(inputs);
        }
        int numInputBytes = 0;
        int numInputs = 0;
        for (BinaryString input : inputs) {
            if (input == null) continue;
            numInputBytes += input.numBytes;
            ++numInputs;
        }
        if (numInputs == 0) {
            return EMPTY_UTF8;
        }
        byte[] result = new byte[numInputBytes + (numInputs - 1) * separator.numBytes];
        int offset = 0;
        int j = 0;
        for (BinaryString input : inputs) {
            if (input == null) continue;
            int len = input.numBytes;
            BinaryRowUtil.copy(input.segments, input.offset, result, offset, len);
            offset += len;
            if (++j >= numInputs) continue;
            BinaryRowUtil.copy(separator.segments, separator.offset, result, offset, separator.numBytes);
            offset += separator.numBytes;
        }
        return BinaryString.fromBytes(result);
    }

    public boolean contains(BinaryString substring) {
        if (substring.numBytes == 0) {
            return true;
        }
        int find = BinaryRowUtil.find(this.segments, this.offset, this.numBytes, substring.segments, substring.offset, substring.numBytes);
        return find != -1;
    }

    private boolean matchAt(BinaryString s2, int pos) {
        return this.inOneSeg() && s2.inOneSeg() ? this.matchAtOneSeg(s2, pos) : this.matchAtVarSeg(s2, pos);
    }

    private boolean matchAtOneSeg(BinaryString s2, int pos) {
        return s2.numBytes + pos <= this.numBytes && pos >= 0 && this.segments[0].equalTo(s2.segments[0], this.offset + pos, s2.offset, s2.numBytes);
    }

    private boolean matchAtVarSeg(BinaryString s2, int pos) {
        return s2.numBytes + pos <= this.numBytes && pos >= 0 && BinaryRowUtil.equalsSlow(this.segments, this.offset + pos, s2.segments, s2.offset, s2.numBytes);
    }

    public boolean startsWith(BinaryString prefix) {
        return this.matchAt(prefix, 0);
    }

    public boolean endsWith(BinaryString suffix) {
        return this.matchAt(suffix, this.numBytes - suffix.numBytes);
    }

    private BinaryString copyBinaryStringInOneSeg(int start, int end) {
        int len = end - start + 1;
        byte[] newBytes = new byte[len];
        this.segments[0].get(this.offset + start, newBytes, 0, len);
        return BinaryString.fromBytes(newBytes);
    }

    private BinaryString copyBinaryString(int start, int end) {
        int len = end - start + 1;
        byte[] newBytes = new byte[len];
        BinaryRowUtil.copy(this.segments, this.offset + start, newBytes, 0, len);
        return BinaryString.fromBytes(newBytes);
    }

    public BinaryString trim() {
        if (this.inOneSeg()) {
            int s2;
            int e = this.numBytes - 1;
            for (s2 = 0; s2 < this.numBytes && this.getByteOneSeg(s2) == 32; ++s2) {
            }
            while (e >= s2 && this.getByteOneSeg(e) == 32) {
                --e;
            }
            if (s2 > e) {
                return EMPTY_UTF8;
            }
            return this.copyBinaryStringInOneSeg(s2, e);
        }
        return this.trimSlow();
    }

    private BinaryString trimSlow() {
        int s2;
        int e = this.numBytes - 1;
        int segSize = this.segments[0].size();
        SegmentAndOffset front = this.firstSegmentAndOffset(segSize);
        for (s2 = 0; s2 < this.numBytes && front.value() == 32; ++s2) {
            front.nextByte(segSize);
        }
        SegmentAndOffset behind = this.lastSegmentAndOffset(segSize);
        while (e >= s2 && behind.value() == 32) {
            --e;
            behind.previousByte(segSize);
        }
        if (s2 > e) {
            return EMPTY_UTF8;
        }
        return this.copyBinaryString(s2, e);
    }

    public BinaryString trim(BinaryString trimStr) {
        if (trimStr == null) {
            return null;
        }
        return this.trimLeft(trimStr).trimRight(trimStr);
    }

    public BinaryString trimLeft() {
        if (this.inOneSeg()) {
            int s2;
            for (s2 = 0; s2 < this.numBytes && this.getByteOneSeg(s2) == 32; ++s2) {
            }
            if (s2 == this.numBytes) {
                return EMPTY_UTF8;
            }
            return this.copyBinaryStringInOneSeg(s2, this.numBytes - 1);
        }
        return this.trimLeftSlow();
    }

    private BinaryString trimLeftSlow() {
        int s2;
        int segSize = this.segments[0].size();
        SegmentAndOffset front = this.firstSegmentAndOffset(segSize);
        for (s2 = 0; s2 < this.numBytes && front.value() == 32; ++s2) {
            front.nextByte(segSize);
        }
        if (s2 == this.numBytes) {
            return EMPTY_UTF8;
        }
        return this.copyBinaryString(s2, this.numBytes - 1);
    }

    public BinaryString trimLeft(BinaryString trimStr) {
        if (trimStr == null) {
            return null;
        }
        if (SPACE_UTF8.equals(trimStr)) {
            return this.trimLeft();
        }
        if (this.inOneSeg()) {
            BinaryString currentChar;
            int searchIdx;
            int charBytes;
            for (searchIdx = 0; searchIdx < this.numBytes && trimStr.contains(currentChar = this.copyBinaryStringInOneSeg(searchIdx, searchIdx + (charBytes = BinaryString.numBytesForFirstByte(this.getByteOneSeg(searchIdx))) - 1)); searchIdx += charBytes) {
            }
            if (searchIdx >= this.numBytes) {
                return EMPTY_UTF8;
            }
            return this.copyBinaryStringInOneSeg(searchIdx, this.numBytes - 1);
        }
        return this.trimLeftSlow(trimStr);
    }

    private BinaryString trimLeftSlow(BinaryString trimStr) {
        BinaryString currentChar;
        int searchIdx;
        int charBytes;
        int segSize = this.segments[0].size();
        SegmentAndOffset front = this.firstSegmentAndOffset(segSize);
        for (searchIdx = 0; searchIdx < this.numBytes && trimStr.contains(currentChar = this.copyBinaryString(searchIdx, searchIdx + (charBytes = BinaryString.numBytesForFirstByte(front.value())) - 1)); searchIdx += charBytes) {
            front.skipBytes(charBytes, segSize);
        }
        if (searchIdx == this.numBytes) {
            return EMPTY_UTF8;
        }
        return this.copyBinaryString(searchIdx, this.numBytes - 1);
    }

    public BinaryString trimRight() {
        if (this.inOneSeg()) {
            int e;
            for (e = this.numBytes - 1; e >= 0 && this.getByteOneSeg(e) == 32; --e) {
            }
            if (e < 0) {
                return EMPTY_UTF8;
            }
            return this.copyBinaryStringInOneSeg(0, e);
        }
        return this.trimRightSlow();
    }

    private BinaryString trimRightSlow() {
        int e;
        int segSize = this.segments[0].size();
        SegmentAndOffset behind = this.lastSegmentAndOffset(segSize);
        for (e = this.numBytes - 1; e >= 0 && behind.value() == 32; --e) {
            behind.previousByte(segSize);
        }
        if (e < 0) {
            return EMPTY_UTF8;
        }
        return this.copyBinaryString(0, e);
    }

    public BinaryString trimRight(BinaryString trimStr) {
        if (trimStr == null) {
            return null;
        }
        if (SPACE_UTF8.equals(trimStr)) {
            return this.trimRight();
        }
        if (this.inOneSeg()) {
            BinaryString currentChar;
            int charIdx = 0;
            int byteIdx = 0;
            int[] charLens = new int[this.numBytes];
            int[] charStartPos = new int[this.numBytes];
            while (byteIdx < this.numBytes) {
                charStartPos[charIdx] = byteIdx;
                charLens[charIdx] = BinaryString.numBytesForFirstByte(this.getByteOneSeg(byteIdx));
                byteIdx += charLens[charIdx];
                ++charIdx;
            }
            int searchIdx = this.numBytes - 1;
            --charIdx;
            while (charIdx >= 0 && trimStr.contains(currentChar = this.copyBinaryStringInOneSeg(charStartPos[charIdx], charStartPos[charIdx] + charLens[charIdx] - 1))) {
                searchIdx -= charLens[charIdx];
                --charIdx;
            }
            if (searchIdx < 0) {
                return EMPTY_UTF8;
            }
            return this.copyBinaryStringInOneSeg(0, searchIdx);
        }
        return this.trimRightSlow(trimStr);
    }

    private BinaryString trimRightSlow(BinaryString trimStr) {
        BinaryString currentChar;
        int charIdx = 0;
        int byteIdx = 0;
        int segSize = this.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        int[] charLens = new int[this.numBytes];
        int[] charStartPos = new int[this.numBytes];
        while (byteIdx < this.numBytes) {
            int charBytes;
            charStartPos[charIdx] = byteIdx;
            charLens[charIdx] = charBytes = BinaryString.numBytesForFirstByte(index.value());
            byteIdx += charBytes;
            ++charIdx;
            index.skipBytes(charBytes, segSize);
        }
        int searchIdx = this.numBytes - 1;
        --charIdx;
        while (charIdx >= 0 && trimStr.contains(currentChar = this.copyBinaryString(charStartPos[charIdx], charStartPos[charIdx] + charLens[charIdx] - 1))) {
            searchIdx -= charLens[charIdx];
            --charIdx;
        }
        if (searchIdx < 0) {
            return EMPTY_UTF8;
        }
        return this.copyBinaryString(0, searchIdx);
    }

    public BinaryString trim(boolean leading, boolean trailing, BinaryString seek) {
        if (seek == null) {
            return null;
        }
        if (leading && trailing) {
            return this.trim(seek);
        }
        if (leading) {
            return this.trimLeft(seek);
        }
        if (trailing) {
            return this.trimRight(seek);
        }
        return this;
    }

    public int indexOf(BinaryString subStr, int start) {
        if (subStr.numBytes == 0) {
            return 0;
        }
        if (this.inOneSeg()) {
            int charIdx;
            int byteIdx = 0;
            for (charIdx = 0; byteIdx < this.numBytes && charIdx < start; byteIdx += BinaryString.numBytesForFirstByte(this.getByteOneSeg(byteIdx)), ++charIdx) {
            }
            do {
                if (byteIdx + subStr.numBytes > this.numBytes) {
                    return -1;
                }
                if (BinaryRowUtil.equals(this.segments, this.offset + byteIdx, subStr.segments, subStr.offset, subStr.numBytes)) {
                    return charIdx;
                }
                byteIdx += BinaryString.numBytesForFirstByte(this.getByteOneSeg(byteIdx));
                ++charIdx;
            } while (byteIdx < this.numBytes);
            return -1;
        }
        return this.indexOfSlow(subStr, start);
    }

    private int indexOfSlow(BinaryString subStr, int start) {
        int charIdx;
        int charBytes;
        int byteIdx = 0;
        int segSize = this.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        for (charIdx = 0; byteIdx < this.numBytes && charIdx < start; byteIdx += charBytes, ++charIdx) {
            charBytes = BinaryString.numBytesForFirstByte(index.value());
            index.skipBytes(charBytes, segSize);
        }
        do {
            if (byteIdx + subStr.numBytes > this.numBytes) {
                return -1;
            }
            if (BinaryRowUtil.equals(this.segments, this.offset + byteIdx, subStr.segments, subStr.offset, subStr.numBytes)) {
                return charIdx;
            }
            charBytes = BinaryString.numBytesForFirstByte(index.segment.get(index.offset));
            ++charIdx;
            index.skipBytes(charBytes, segSize);
        } while ((byteIdx += charBytes) < this.numBytes);
        return -1;
    }

    public BinaryString reverse() {
        if (this.inOneSeg()) {
            int charBytes;
            byte[] result = new byte[this.numBytes];
            for (int byteIdx = 0; byteIdx < this.numBytes; byteIdx += charBytes) {
                charBytes = BinaryString.numBytesForFirstByte(this.getByteOneSeg(byteIdx));
                this.segments[0].get(this.offset + byteIdx, result, result.length - byteIdx - charBytes, charBytes);
            }
            return BinaryString.fromBytes(result);
        }
        return this.reverseSlow();
    }

    private BinaryString reverseSlow() {
        int charBytes;
        byte[] result = new byte[this.numBytes];
        int segSize = this.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        for (int byteIdx = 0; byteIdx < this.numBytes; byteIdx += charBytes) {
            charBytes = BinaryString.numBytesForFirstByte(index.value());
            BinaryRowUtil.copySlow(this.segments, this.offset + byteIdx, result, result.length - byteIdx - charBytes, charBytes);
            index.skipBytes(charBytes, segSize);
        }
        return BinaryString.fromBytes(result);
    }

    private SegmentAndOffset firstSegmentAndOffset(int segSize) {
        int segIndex = this.offset / segSize;
        return new SegmentAndOffset(segIndex, this.offset % segSize);
    }

    private SegmentAndOffset lastSegmentAndOffset(int segSize) {
        int lastOffset = this.offset + this.numBytes - 1;
        int segIndex = lastOffset / segSize;
        return new SegmentAndOffset(segIndex, lastOffset % segSize);
    }

    private SegmentAndOffset startSegmentAndOffset(int segSize) {
        if (this.inOneSeg()) {
            return new SegmentAndOffset(0, this.offset);
        }
        return this.firstSegmentAndOffset(segSize);
    }

    public Long toLong() {
        boolean negative;
        if (this.numBytes == 0) {
            return null;
        }
        int size = this.segments[0].size();
        SegmentAndOffset segmentAndOffset = this.startSegmentAndOffset(size);
        int totalOffset = 0;
        byte b = segmentAndOffset.value();
        boolean bl = negative = b == 45;
        if (negative || b == 43) {
            segmentAndOffset.nextByte(size);
            ++totalOffset;
            if (this.numBytes == 1) {
                return null;
            }
        }
        long result = 0L;
        int separator = 46;
        int radix = 10;
        long stopValue = -922337203685477580L;
        while (totalOffset < this.numBytes) {
            b = segmentAndOffset.value();
            ++totalOffset;
            segmentAndOffset.nextByte(size);
            if (b == 46) break;
            if (b < 48 || b > 57) {
                return null;
            }
            int digit = b - 48;
            if (result < -922337203685477580L) {
                return null;
            }
            if ((result = result * 10L - (long)digit) <= 0L) continue;
            return null;
        }
        while (totalOffset < this.numBytes) {
            byte currentByte = segmentAndOffset.value();
            if (currentByte < 48 || currentByte > 57) {
                return null;
            }
            ++totalOffset;
            segmentAndOffset.nextByte(size);
        }
        if (!negative && (result = -result) < 0L) {
            return null;
        }
        return result;
    }

    public Integer toInt() {
        boolean negative;
        if (this.numBytes == 0) {
            return null;
        }
        int size = this.segments[0].size();
        SegmentAndOffset segmentAndOffset = this.startSegmentAndOffset(size);
        int totalOffset = 0;
        byte b = segmentAndOffset.value();
        boolean bl = negative = b == 45;
        if (negative || b == 43) {
            segmentAndOffset.nextByte(size);
            ++totalOffset;
            if (this.numBytes == 1) {
                return null;
            }
        }
        int result = 0;
        int separator = 46;
        int radix = 10;
        long stopValue = -214748364L;
        while (totalOffset < this.numBytes) {
            b = segmentAndOffset.value();
            ++totalOffset;
            segmentAndOffset.nextByte(size);
            if (b == 46) break;
            if (b < 48 || b > 57) {
                return null;
            }
            int digit = b - 48;
            if ((long)result < -214748364L) {
                return null;
            }
            if ((result = result * 10 - digit) <= 0) continue;
            return null;
        }
        while (totalOffset < this.numBytes) {
            byte currentByte = segmentAndOffset.value();
            if (currentByte < 48 || currentByte > 57) {
                return null;
            }
            ++totalOffset;
            segmentAndOffset.nextByte(size);
        }
        if (!negative && (result = -result) < 0) {
            return null;
        }
        return result;
    }

    public Short toShort() {
        short result;
        Integer intValue = this.toInt();
        if (intValue != null && (result = intValue.shortValue()) == intValue) {
            return result;
        }
        return null;
    }

    public Byte toByte() {
        byte result;
        Integer intValue = this.toInt();
        if (intValue != null && (result = intValue.byteValue()) == intValue) {
            return result;
        }
        return null;
    }

    public Double toDouble() {
        try {
            return Double.valueOf(this.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Float toFloat() {
        try {
            return Float.valueOf(this.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public BinaryString toUpperCase() {
        if (this.numBytes == 0) {
            return EMPTY_UTF8;
        }
        int size = this.segments[0].size();
        SegmentAndOffset segmentAndOffset = this.startSegmentAndOffset(size);
        byte[] bytes = new byte[this.numBytes];
        bytes[0] = (byte)Character.toTitleCase(segmentAndOffset.value());
        for (int i = 0; i < this.numBytes; ++i) {
            byte b = segmentAndOffset.value();
            if (BinaryString.numBytesForFirstByte(b) != 1) {
                return this.toUpperCaseSlow();
            }
            int upper = Character.toUpperCase(b);
            if (upper > 127) {
                return this.toUpperCaseSlow();
            }
            bytes[i] = (byte)upper;
            segmentAndOffset.nextByte(size);
        }
        return BinaryString.fromBytes(bytes);
    }

    private BinaryString toUpperCaseSlow() {
        return BinaryString.fromString(this.toString().toUpperCase());
    }

    public BinaryString toLowerCase() {
        if (this.numBytes == 0) {
            return EMPTY_UTF8;
        }
        int size = this.segments[0].size();
        SegmentAndOffset segmentAndOffset = this.startSegmentAndOffset(size);
        byte[] bytes = new byte[this.numBytes];
        bytes[0] = (byte)Character.toTitleCase(segmentAndOffset.value());
        for (int i = 0; i < this.numBytes; ++i) {
            byte b = segmentAndOffset.value();
            if (BinaryString.numBytesForFirstByte(b) != 1) {
                return this.toLowerCaseSlow();
            }
            int lower = Character.toLowerCase(b);
            if (lower > 127) {
                return this.toLowerCaseSlow();
            }
            bytes[i] = (byte)lower;
            segmentAndOffset.nextByte(size);
        }
        return BinaryString.fromBytes(bytes);
    }

    private BinaryString toLowerCaseSlow() {
        return BinaryString.fromString(this.toString().toLowerCase());
    }

    private class SegmentAndOffset {
        int segIndex;
        MemorySegment segment;
        int offset;

        private SegmentAndOffset(int segIndex, int offset) {
            this.segIndex = segIndex;
            this.segment = BinaryString.this.segments[segIndex];
            this.offset = offset;
        }

        private void assignSegment() {
            this.segment = this.segIndex >= 0 && this.segIndex < BinaryString.this.segments.length ? BinaryString.this.segments[this.segIndex] : null;
        }

        private void previousByte(int segSize) {
            --this.offset;
            if (this.offset == -1) {
                --this.segIndex;
                this.assignSegment();
                this.offset = segSize - 1;
            }
        }

        private void nextByte(int segSize) {
            ++this.offset;
            this.checkAdvance(segSize);
        }

        private void checkAdvance(int segSize) {
            if (this.offset == segSize) {
                this.advance();
            }
        }

        private void advance() {
            ++this.segIndex;
            this.assignSegment();
            this.offset = 0;
        }

        private void skipBytes(int n, int segSize) {
            int remaining = segSize - this.offset;
            if (remaining > n) {
                this.offset += n;
            } else {
                while (true) {
                    int toSkip;
                    if ((n -= (toSkip = Math.min(remaining, n))) <= 0) {
                        this.offset += toSkip;
                        this.checkAdvance(segSize);
                        return;
                    }
                    this.advance();
                    remaining = segSize - this.offset;
                }
            }
        }

        private byte value() {
            return this.segment.get(this.offset);
        }
    }
}

