/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ots.thirdparty.org.apache.impl.nio;

import com.aliyun.ots.thirdparty.org.apache.annotation.Immutable;
import com.aliyun.ots.thirdparty.org.apache.config.ConnectionConfig;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.DefaultNHttpServerConnection;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.DefaultNHttpServerConnectionFactory;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.SSLNHttpServerConnectionFactory;
import com.aliyun.ots.thirdparty.org.apache.impl.nio.reactor.AbstractIODispatch;
import com.aliyun.ots.thirdparty.org.apache.nio.NHttpConnectionFactory;
import com.aliyun.ots.thirdparty.org.apache.nio.NHttpServerEventHandler;
import com.aliyun.ots.thirdparty.org.apache.nio.reactor.IOSession;
import com.aliyun.ots.thirdparty.org.apache.nio.reactor.ssl.SSLSetupHandler;
import com.aliyun.ots.thirdparty.org.apache.params.HttpParams;
import com.aliyun.ots.thirdparty.org.apache.util.Args;
import java.io.IOException;
import javax.net.ssl.SSLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class DefaultHttpServerIODispatch
extends AbstractIODispatch<DefaultNHttpServerConnection> {
    private final NHttpServerEventHandler handler;
    private final NHttpConnectionFactory<DefaultNHttpServerConnection> connFactory;

    public DefaultHttpServerIODispatch(NHttpServerEventHandler handler, NHttpConnectionFactory<DefaultNHttpServerConnection> connFactory) {
        this.handler = Args.notNull(handler, "HTTP client handler");
        this.connFactory = Args.notNull(connFactory, "HTTP server connection factory");
    }

    @Deprecated
    public DefaultHttpServerIODispatch(NHttpServerEventHandler handler, HttpParams params) {
        this(handler, new DefaultNHttpServerConnectionFactory(params));
    }

    @Deprecated
    public DefaultHttpServerIODispatch(NHttpServerEventHandler handler, SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        this(handler, new SSLNHttpServerConnectionFactory(sslcontext, sslHandler, params));
    }

    @Deprecated
    public DefaultHttpServerIODispatch(NHttpServerEventHandler handler, SSLContext sslcontext, HttpParams params) {
        this(handler, sslcontext, null, params);
    }

    public DefaultHttpServerIODispatch(NHttpServerEventHandler handler, ConnectionConfig config) {
        this(handler, new DefaultNHttpServerConnectionFactory(config));
    }

    public DefaultHttpServerIODispatch(NHttpServerEventHandler handler, SSLContext sslcontext, SSLSetupHandler sslHandler, ConnectionConfig config) {
        this(handler, new SSLNHttpServerConnectionFactory(sslcontext, sslHandler, config));
    }

    public DefaultHttpServerIODispatch(NHttpServerEventHandler handler, SSLContext sslcontext, ConnectionConfig config) {
        this(handler, new SSLNHttpServerConnectionFactory(sslcontext, null, config));
    }

    @Override
    protected DefaultNHttpServerConnection createConnection(IOSession session) {
        return this.connFactory.createConnection(session);
    }

    @Override
    protected void onConnected(DefaultNHttpServerConnection conn) {
        try {
            this.handler.connected(conn);
        }
        catch (Exception ex) {
            this.handler.exception(conn, ex);
        }
    }

    @Override
    protected void onClosed(DefaultNHttpServerConnection conn) {
        this.handler.closed(conn);
    }

    @Override
    protected void onException(DefaultNHttpServerConnection conn, IOException ex) {
        this.handler.exception(conn, ex);
    }

    @Override
    protected void onInputReady(DefaultNHttpServerConnection conn) {
        conn.consumeInput(this.handler);
    }

    @Override
    protected void onOutputReady(DefaultNHttpServerConnection conn) {
        conn.produceOutput(this.handler);
    }

    @Override
    protected void onTimeout(DefaultNHttpServerConnection conn) {
        try {
            this.handler.timeout(conn);
        }
        catch (Exception ex) {
            this.handler.exception(conn, ex);
        }
    }
}

