/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeline.query;

import com.alicloud.openservices.tablestore.model.search.sort.FieldSort;
import com.alicloud.openservices.tablestore.model.search.sort.Sort;
import com.alicloud.openservices.tablestore.model.search.sort.SortOrder;
import com.alicloud.openservices.tablestore.timeline.query.Condition;
import com.alicloud.openservices.tablestore.timeline.utils.Preconditions;
import java.util.ArrayList;

public class SearchParameter {
    private Condition fieldCondition;
    private int offset = 0;
    private int limit = 100;
    private Sort sort;
    private byte[] token;
    private boolean calculateTotalCount = false;

    public SearchParameter(Condition fieldCondition) {
        this.fieldCondition = fieldCondition;
    }

    public SearchParameter offset(int offset) {
        this.offset = offset;
        return this;
    }

    public SearchParameter limit(int limit) {
        this.limit = limit;
        return this;
    }

    public SearchParameter withToken(byte[] token) {
        this.token = token;
        this.offset = 0;
        return this;
    }

    public SearchParameter calculateTotalCount() {
        this.calculateTotalCount = true;
        return this;
    }

    public SearchParameter orderBy(String[] fields, SortOrder order) {
        Preconditions.checkArgument(this.sort == null, "You have already set sort condition.");
        ArrayList<Sort.Sorter> sorters = new ArrayList<Sort.Sorter>(fields.length);
        for (String field : fields) {
            sorters.add(new FieldSort(field, order));
        }
        this.sort = new Sort(sorters);
        return this;
    }

    public Condition getFieldCondition() {
        return this.fieldCondition;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public Sort getSort() {
        return this.sort;
    }

    public boolean isCalculateTotalCount() {
        return this.calculateTotalCount;
    }

    public byte[] getToken() {
        return this.token;
    }
}

