/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.sql;

import com.alicloud.openservices.tablestore.model.ColumnType;
import com.alicloud.openservices.tablestore.model.sql.SQLColumnSchema;
import com.alicloud.openservices.tablestore.model.sql.SQLRow;
import com.alicloud.openservices.tablestore.model.sql.SQLRows;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;

public class SQLRowImpl
implements SQLRow {
    private SQLRows sqlRows;
    private int rowIndex;

    public SQLRowImpl(SQLRows sqlRows, int rowIndex) {
        this.sqlRows = sqlRows;
        this.rowIndex = rowIndex;
    }

    @Override
    public Object get(int columnIndex) {
        this.checkValid(columnIndex, null);
        return this.sqlRows.get(this.rowIndex, columnIndex);
    }

    @Override
    public Object get(String name) {
        this.checkValid(name, null);
        return this.get(this.sqlRows.getSQLTableMeta().getColumnsMap().get(name));
    }

    @Override
    public String getString(int columnIndex) {
        this.checkValid(columnIndex, ColumnType.STRING);
        Object value = this.get(columnIndex);
        if (value == null) {
            return null;
        }
        return (String)value;
    }

    @Override
    public String getString(String name) {
        this.checkValid(name, ColumnType.STRING);
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        return (String)value;
    }

    @Override
    public Long getLong(int columnIndex) {
        this.checkValid(columnIndex, ColumnType.INTEGER);
        Object value = this.get(columnIndex);
        if (value == null) {
            return null;
        }
        return (Long)value;
    }

    @Override
    public Long getLong(String name) {
        this.checkValid(name, ColumnType.INTEGER);
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        return (Long)value;
    }

    @Override
    public Boolean getBoolean(int columnIndex) {
        this.checkValid(columnIndex, ColumnType.BOOLEAN);
        Object value = this.get(columnIndex);
        if (value == null) {
            return null;
        }
        return (Boolean)value;
    }

    @Override
    public Boolean getBoolean(String name) {
        this.checkValid(name, ColumnType.BOOLEAN);
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        return (Boolean)value;
    }

    @Override
    public Double getDouble(int columnIndex) {
        this.checkValid(columnIndex, ColumnType.DOUBLE);
        Object value = this.get(columnIndex);
        if (value == null) {
            return null;
        }
        return (Double)value;
    }

    @Override
    public Double getDouble(String name) {
        this.checkValid(name, ColumnType.DOUBLE);
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        return (Double)value;
    }

    @Override
    public ZonedDateTime getDateTime(int columnIndex) {
        this.checkValid(columnIndex, ColumnType.DATETIME);
        Object value = this.get(columnIndex);
        if (value == null) {
            return null;
        }
        return (ZonedDateTime)value;
    }

    @Override
    public ZonedDateTime getDateTime(String name) {
        this.checkValid(name, ColumnType.DATETIME);
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        return (ZonedDateTime)value;
    }

    @Override
    public Duration getTime(int columnIndex) {
        this.checkValid(columnIndex, ColumnType.TIME);
        Object value = this.get(columnIndex);
        if (value == null) {
            return null;
        }
        return (Duration)value;
    }

    @Override
    public Duration getTime(String name) {
        this.checkValid(name, ColumnType.TIME);
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        return (Duration)value;
    }

    @Override
    public LocalDate getDate(int columnIndex) {
        this.checkValid(columnIndex, ColumnType.DATE);
        Object value = this.get(columnIndex);
        if (value == null) {
            return null;
        }
        return (LocalDate)value;
    }

    @Override
    public LocalDate getDate(String name) {
        this.checkValid(name, ColumnType.DATE);
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        return (LocalDate)value;
    }

    @Override
    public ByteBuffer getBinary(int columnIndex) {
        this.checkValid(columnIndex, ColumnType.BINARY);
        Object value = this.get(columnIndex);
        if (value == null) {
            return null;
        }
        return (ByteBuffer)value;
    }

    @Override
    public ByteBuffer getBinary(String name) {
        this.checkValid(name, ColumnType.BINARY);
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        return (ByteBuffer)value;
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        List<SQLColumnSchema> schemas = this.sqlRows.getSQLTableMeta().getSchema();
        for (int i = 0; i < schemas.size(); ++i) {
            sb.append(schemas.get(i).getName() + ": ");
            sb.append(this.get(i));
            if (i >= schemas.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private void checkValid(int columnIndex, ColumnType responseType) {
        if ((long)columnIndex >= this.sqlRows.columnCount() || columnIndex < 0) {
            throw new UnsupportedOperationException("Column index " + columnIndex + " is out of range");
        }
        if (responseType != null && responseType != this.sqlRows.getSQLTableMeta().getSchema().get(columnIndex).getType()) {
            throw new UnsupportedOperationException("Column type collates failed, response type: " + (Object)((Object)responseType) + ", but the real is: " + (Object)((Object)this.sqlRows.getSQLTableMeta().getSchema().get(columnIndex).getType()));
        }
    }

    private void checkValid(String name, ColumnType responseType) {
        if (!this.sqlRows.getSQLTableMeta().getColumnsMap().containsKey(name)) {
            throw new IllegalStateException("SQLRow doesn't contains field name: " + name);
        }
        int columnIndex = this.sqlRows.getSQLTableMeta().getColumnsMap().get(name);
        if (responseType != null && responseType != this.sqlRows.getSQLTableMeta().getSchema().get(columnIndex).getType()) {
            throw new UnsupportedOperationException("Column type collates failed, response type: " + (Object)((Object)responseType) + ", but the real is: " + (Object)((Object)this.sqlRows.getSQLTableMeta().getSchema().get(columnIndex).getType()));
        }
    }
}

