/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.sql;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ConsumedCapacity;
import com.alicloud.openservices.tablestore.model.Response;
import com.alicloud.openservices.tablestore.model.sql.SQLFactory;
import com.alicloud.openservices.tablestore.model.sql.SQLPayloadVersion;
import com.alicloud.openservices.tablestore.model.sql.SQLResultSet;
import com.alicloud.openservices.tablestore.model.sql.SQLStatementType;
import com.aliyun.ots.thirdparty.com.google.protobuf.ByteString;
import java.util.Map;

public class SQLQueryResponse
extends Response {
    private Map<String, ConsumedCapacity> consumedCapacityByTable;
    private SQLPayloadVersion version;
    private SQLStatementType type;
    private ByteString rows;

    public SQLQueryResponse(Response meta, Map<String, ConsumedCapacity> consumedCapacityByTable, SQLPayloadVersion version, SQLStatementType type, ByteString rows) {
        super(meta);
        Preconditions.checkNotNull(consumedCapacityByTable);
        this.consumedCapacityByTable = consumedCapacityByTable;
        this.version = version;
        this.type = type;
        this.rows = rows;
    }

    public Map<String, ConsumedCapacity> getConsumedCapacity() {
        return this.consumedCapacityByTable;
    }

    public SQLStatementType getSQLStatementType() {
        return this.type;
    }

    public SQLResultSet getSQLResultSet() {
        return SQLFactory.getSQLResultSet(this.version, this.type, this.rows);
    }
}

