/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.Base64;
import com.alicloud.openservices.tablestore.core.utils.Bytes;
import com.alicloud.openservices.tablestore.core.utils.CalculateHelper;
import com.alicloud.openservices.tablestore.core.utils.Jsonizable;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.Measurable;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import java.io.IOException;

public class PrimaryKeyColumn
implements Comparable<PrimaryKeyColumn>,
Jsonizable,
Measurable {
    private String name;
    private PrimaryKeyValue value;
    private int dataSize = -1;

    public PrimaryKeyColumn(String name, PrimaryKeyValue value) {
        Preconditions.checkArgument(name != null && !name.isEmpty(), "The name of primary key should not be null or empty.");
        Preconditions.checkNotNull(value, "The value of primary key should not be null.");
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getNameRawData() {
        return Bytes.toBytes(this.name);
    }

    public PrimaryKeyValue getValue() {
        return this.value;
    }

    public Column toColumn() throws IOException {
        return new Column(this.getName(), this.getValue().toColumnValue());
    }

    public String toString() {
        return "'" + this.name + "':" + this.value;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PrimaryKeyColumn)) {
            return false;
        }
        PrimaryKeyColumn col = (PrimaryKeyColumn)o;
        return this.name.equals(col.name) && this.value.equals(col.value);
    }

    @Override
    public int compareTo(PrimaryKeyColumn target) {
        if (!this.name.equals(target.name)) {
            throw new IllegalArgumentException("The name of primary key to be compared must be the same.");
        }
        return this.value.compareTo(target.value);
    }

    @Override
    public String jsonize() {
        StringBuilder sb = new StringBuilder();
        this.jsonize(sb, "\n  ");
        return sb.toString();
    }

    @Override
    public void jsonize(StringBuilder sb, String newline) {
        block10: {
            block9: {
                sb.append("{\"Name\": \"");
                sb.append(this.name);
                sb.append("\", \"Type\": \"");
                if (this.value.getType() == null) break block9;
                sb.append(this.value.getType().toString());
                sb.append("\", \"Value\": ");
                switch (this.value.getType()) {
                    case INTEGER: {
                        sb.append(this.value.asLong());
                        break block10;
                    }
                    case STRING: {
                        sb.append("\"");
                        sb.append(this.value.asString());
                        sb.append("\"");
                        break block10;
                    }
                    case BINARY: {
                        sb.append("\"");
                        sb.append(Base64.toBase64String(this.value.asBinary()));
                        sb.append("\"");
                        break block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)this.value.getType()));
                    }
                }
            }
            sb.append("null");
            sb.append("\", \"Value\": ");
            if (this.value.isInfMin()) {
                sb.append("\"");
                sb.append("INF_MIN");
                sb.append("\"");
            } else if (this.value.isInfMax()) {
                sb.append("\"");
                sb.append("INF_MAX");
                sb.append("\"");
            } else {
                throw new IllegalArgumentException("Unknown value: " + this.value.asString());
            }
        }
        sb.append("}");
    }

    @Override
    public int getDataSize() {
        if (this.dataSize == -1) {
            this.dataSize = CalculateHelper.calcStringSizeInBytes(this.name) + this.value.getDataSize();
        }
        return this.dataSize;
    }
}

