/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Request;

public class GetShardIteratorRequest
implements Request {
    private String streamId;
    private String shardId;
    private OptionalValue<Long> timestamp = new OptionalValue("Timestamp");
    private OptionalValue<String> token = new OptionalValue("Token");

    public GetShardIteratorRequest(String streamId, String shardId) {
        this.setStreamId(streamId);
        this.setShardId(shardId);
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        Preconditions.checkArgument(streamId != null && !streamId.isEmpty(), "The streamId should not be null or empty.");
        this.streamId = streamId;
    }

    public String getShardId() {
        return this.shardId;
    }

    public void setShardId(String shardId) {
        Preconditions.checkArgument(shardId != null && !shardId.isEmpty(), "The shardId should not be null or empty.");
        this.shardId = shardId;
    }

    @Override
    public String getOperationName() {
        return "GetShardIterator";
    }

    public boolean hasTimestamp() {
        return this.timestamp.isValueSet();
    }

    public long getTimestamp() {
        if (!this.timestamp.isValueSet()) {
            throw new IllegalStateException("The value of Timestamp is not set.");
        }
        return this.timestamp.getValue();
    }

    public void setTimestamp(long timestamp) {
        this.timestamp.setValue(timestamp);
    }

    public boolean hasToken() {
        return this.token.isValueSet();
    }

    public String getToken() {
        if (!this.token.isValueSet()) {
            throw new IllegalStateException("The value of Token is not set.");
        }
        return this.token.getValue();
    }

    public void setToken(String token) {
        this.token.setValue(token);
    }
}

