/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.protocol.OtsDelivery;
import com.alicloud.openservices.tablestore.core.protocol.OtsFilter;
import com.alicloud.openservices.tablestore.core.protocol.OtsInternalApi;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferBuilder;
import com.alicloud.openservices.tablestore.model.AbortTransactionRequest;
import com.alicloud.openservices.tablestore.model.AddDefinedColumnRequest;
import com.alicloud.openservices.tablestore.model.BatchWriteRowRequest;
import com.alicloud.openservices.tablestore.model.BulkExportRequest;
import com.alicloud.openservices.tablestore.model.BulkImportRequest;
import com.alicloud.openservices.tablestore.model.CapacityUnit;
import com.alicloud.openservices.tablestore.model.CommitTransactionRequest;
import com.alicloud.openservices.tablestore.model.ComputeSplitsBySizeRequest;
import com.alicloud.openservices.tablestore.model.ComputeSplitsRequest;
import com.alicloud.openservices.tablestore.model.Condition;
import com.alicloud.openservices.tablestore.model.CreateIndexRequest;
import com.alicloud.openservices.tablestore.model.CreateTableRequest;
import com.alicloud.openservices.tablestore.model.CreateTableRequestEx;
import com.alicloud.openservices.tablestore.model.DataBlockType;
import com.alicloud.openservices.tablestore.model.DefinedColumnSchema;
import com.alicloud.openservices.tablestore.model.DefinedColumnType;
import com.alicloud.openservices.tablestore.model.DeleteDefinedColumnRequest;
import com.alicloud.openservices.tablestore.model.DeleteIndexRequest;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.DeleteTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeStreamRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.Direction;
import com.alicloud.openservices.tablestore.model.GetRangeRequest;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetShardIteratorRequest;
import com.alicloud.openservices.tablestore.model.GetStreamRecordRequest;
import com.alicloud.openservices.tablestore.model.IndexMeta;
import com.alicloud.openservices.tablestore.model.IndexType;
import com.alicloud.openservices.tablestore.model.IndexUpdateMode;
import com.alicloud.openservices.tablestore.model.ListStreamRequest;
import com.alicloud.openservices.tablestore.model.MultiRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.PrimaryKeyOption;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.RangeRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.ReservedThroughput;
import com.alicloud.openservices.tablestore.model.ReturnType;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowExistenceExpectation;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.alicloud.openservices.tablestore.model.SSEKeyType;
import com.alicloud.openservices.tablestore.model.SSESpecification;
import com.alicloud.openservices.tablestore.model.SearchIndexSplitsOptions;
import com.alicloud.openservices.tablestore.model.SingleRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.SplitsOptions;
import com.alicloud.openservices.tablestore.model.StartLocalTransactionRequest;
import com.alicloud.openservices.tablestore.model.StreamSpecification;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.alicloud.openservices.tablestore.model.TableOptions;
import com.alicloud.openservices.tablestore.model.TimeRange;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.UpdateTableRequest;
import com.alicloud.openservices.tablestore.model.condition.ColumnCondition;
import com.alicloud.openservices.tablestore.model.condition.ColumnConditionType;
import com.alicloud.openservices.tablestore.model.delivery.CreateDeliveryTaskRequest;
import com.alicloud.openservices.tablestore.model.delivery.DataType;
import com.alicloud.openservices.tablestore.model.delivery.DeleteDeliveryTaskRequest;
import com.alicloud.openservices.tablestore.model.delivery.DeliveryTaskType;
import com.alicloud.openservices.tablestore.model.delivery.DescribeDeliveryTaskRequest;
import com.alicloud.openservices.tablestore.model.delivery.EventColumn;
import com.alicloud.openservices.tablestore.model.delivery.EventTimeFormat;
import com.alicloud.openservices.tablestore.model.delivery.ListDeliveryTaskRequest;
import com.alicloud.openservices.tablestore.model.delivery.OSSFileEncoding;
import com.alicloud.openservices.tablestore.model.delivery.OSSFileFormat;
import com.alicloud.openservices.tablestore.model.delivery.OSSTaskConfig;
import com.alicloud.openservices.tablestore.model.delivery.ParquetSchema;
import com.alicloud.openservices.tablestore.model.delivery.TimeFormatter;
import com.alicloud.openservices.tablestore.model.filter.ColumnPaginationFilter;
import com.alicloud.openservices.tablestore.model.filter.CompositeColumnValueFilter;
import com.alicloud.openservices.tablestore.model.filter.Filter;
import com.alicloud.openservices.tablestore.model.filter.FilterType;
import com.alicloud.openservices.tablestore.model.filter.SingleColumnValueFilter;
import com.alicloud.openservices.tablestore.model.filter.SingleColumnValueRegexFilter;
import com.alicloud.openservices.tablestore.model.sql.SQLPayloadVersion;
import com.alicloud.openservices.tablestore.model.sql.SQLQueryRequest;
import com.alicloud.openservices.tablestore.model.tunnel.BulkExportQueryCriteria;
import com.aliyun.ots.thirdparty.com.google.protobuf.ByteString;
import com.aliyun.ots.thirdparty.com.google.protobuf.Message;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OTSProtocolBuilder {
    public static OtsInternalApi.PrimaryKeyType toPBPrimaryKeyType(PrimaryKeyType type) {
        switch (type) {
            case INTEGER: {
                return OtsInternalApi.PrimaryKeyType.INTEGER;
            }
            case STRING: {
                return OtsInternalApi.PrimaryKeyType.STRING;
            }
            case BINARY: {
                return OtsInternalApi.PrimaryKeyType.BINARY;
            }
        }
        throw new IllegalArgumentException("Unknown primary key type: " + (Object)((Object)type));
    }

    public static OtsInternalApi.PrimaryKeyOption toPBPrimaryKeyOption(PrimaryKeyOption option) {
        switch (option) {
            case AUTO_INCREMENT: {
                return OtsInternalApi.PrimaryKeyOption.AUTO_INCREMENT;
            }
        }
        throw new IllegalArgumentException("Unknown primary key option: " + (Object)((Object)option));
    }

    public static OtsInternalApi.DefinedColumnType toPBDefinedColumnType(DefinedColumnType type) {
        switch (type) {
            case INTEGER: {
                return OtsInternalApi.DefinedColumnType.DCT_INTEGER;
            }
            case DOUBLE: {
                return OtsInternalApi.DefinedColumnType.DCT_DOUBLE;
            }
            case BOOLEAN: {
                return OtsInternalApi.DefinedColumnType.DCT_BOOLEAN;
            }
            case STRING: {
                return OtsInternalApi.DefinedColumnType.DCT_STRING;
            }
            case BINARY: {
                return OtsInternalApi.DefinedColumnType.DCT_BLOB;
            }
        }
        throw new IllegalArgumentException("Unknown defined column type: " + (Object)((Object)type));
    }

    public static OtsInternalApi.IndexType toPBIndexType(IndexType indexType) {
        switch (indexType) {
            case IT_GLOBAL_INDEX: {
                return OtsInternalApi.IndexType.IT_GLOBAL_INDEX;
            }
            case IT_LOCAL_INDEX: {
                return OtsInternalApi.IndexType.IT_LOCAL_INDEX;
            }
        }
        throw new IllegalArgumentException("Unknown index type:" + (Object)((Object)indexType));
    }

    public static OtsInternalApi.IndexUpdateMode toPBIndexUpdateMode(IndexUpdateMode indexUpdateMode) {
        switch (indexUpdateMode) {
            case IUM_ASYNC_INDEX: {
                return OtsInternalApi.IndexUpdateMode.IUM_ASYNC_INDEX;
            }
            case IUM_SYNC_INDEX: {
                return OtsInternalApi.IndexUpdateMode.IUM_SYNC_INDEX;
            }
        }
        throw new IllegalArgumentException("Unknown index update mode" + (Object)((Object)indexUpdateMode));
    }

    public static OtsDelivery.EventColumn.eventTimeFormat toPBEventTimeFormat(EventTimeFormat eventTimeFormat2) {
        switch (eventTimeFormat2) {
            case RFC822: {
                return OtsDelivery.EventColumn.eventTimeFormat.RFC822;
            }
            case RFC850: {
                return OtsDelivery.EventColumn.eventTimeFormat.RFC850;
            }
            case RFC1123: {
                return OtsDelivery.EventColumn.eventTimeFormat.RFC1123;
            }
            case RFC3339: {
                return OtsDelivery.EventColumn.eventTimeFormat.RFC3339;
            }
            case Unix: {
                return OtsDelivery.EventColumn.eventTimeFormat.Unix;
            }
        }
        throw new IllegalArgumentException("Unknown eventTimeFormat: " + (Object)((Object)eventTimeFormat2));
    }

    public static OtsDelivery.TimeFormatter toPBTimeFormatter(TimeFormatter timeFormatter) {
        switch (timeFormatter) {
            case YDMFormatter: {
                return OtsDelivery.TimeFormatter.YDMFormatter;
            }
        }
        throw new IllegalArgumentException("Unknown timeFormatter: " + (Object)((Object)timeFormatter));
    }

    public static OtsDelivery.Format toPBFormat(OSSFileFormat format) {
        switch (format) {
            case Parquet: {
                return OtsDelivery.Format.Parquet;
            }
        }
        throw new IllegalArgumentException("UnKnown format: " + (Object)((Object)format));
    }

    public static OtsDelivery.DeliveryTaskType toPBDeliveryTaskType(DeliveryTaskType deliveryTaskType) {
        switch (deliveryTaskType) {
            case BASE: {
                return OtsDelivery.DeliveryTaskType.BASE;
            }
            case INC: {
                return OtsDelivery.DeliveryTaskType.INC;
            }
            case BASE_INC: {
                return OtsDelivery.DeliveryTaskType.BASE_INC;
            }
        }
        throw new IllegalArgumentException("UnKnown deliveryTaskType: " + (Object)((Object)deliveryTaskType));
    }

    public static OtsDelivery.ParquetSchema.DataType toPBDataType(DataType dataType) {
        switch (dataType) {
            case BOOL: {
                return OtsDelivery.ParquetSchema.DataType.BOOL;
            }
            case INT64: {
                return OtsDelivery.ParquetSchema.DataType.INT64;
            }
            case UTF8: {
                return OtsDelivery.ParquetSchema.DataType.UTF8;
            }
            case DOUBLE: {
                return OtsDelivery.ParquetSchema.DataType.DOUBLE;
            }
            case DATE: {
                return OtsDelivery.ParquetSchema.DataType.DATE;
            }
            case DECIMAL: {
                return OtsDelivery.ParquetSchema.DataType.DECIMAL;
            }
            case TIME_MILLIS: {
                return OtsDelivery.ParquetSchema.DataType.TIME_MILLIS;
            }
            case TIME_MICROS: {
                return OtsDelivery.ParquetSchema.DataType.TIME_MICROS;
            }
            case LIST: {
                return OtsDelivery.ParquetSchema.DataType.LIST;
            }
            case MAP: {
                return OtsDelivery.ParquetSchema.DataType.MAP;
            }
            case INTERVAL: {
                return OtsDelivery.ParquetSchema.DataType.INTERVAL;
            }
            case FLOAT: {
                return OtsDelivery.ParquetSchema.DataType.FLOAT;
            }
            case INT32: {
                return OtsDelivery.ParquetSchema.DataType.INT32;
            }
            case INT96: {
                return OtsDelivery.ParquetSchema.DataType.INT96;
            }
        }
        throw new IllegalArgumentException("UnKnown dataType: " + (Object)((Object)dataType));
    }

    public static OtsDelivery.Encoding toPBEncoding(OSSFileEncoding encoding) {
        switch (encoding) {
            case PLAIN: {
                return OtsDelivery.Encoding.PLAIN;
            }
            case PLAIN_DICTIONARY: {
                return OtsDelivery.Encoding.PLAIN_DICTIONARY;
            }
            case DELTA_BINARY_PACKED: {
                return OtsDelivery.Encoding.DELTA_BINARY_PACKED;
            }
            case DELTA_BYTE_ARRAY: {
                return OtsDelivery.Encoding.DELTA_BYTE_ARRAY;
            }
            case DELTA_LENGTH_BYTE_ARRAY: {
                return OtsDelivery.Encoding.DELTA_LENGTH_BYTE_ARRAY;
            }
        }
        throw new IllegalArgumentException("UnKnown encoding: " + (Object)((Object)encoding));
    }

    public static OtsInternalApi.DefinedColumnSchema buildDefinedColumnSchema(DefinedColumnSchema definedColun) {
        OtsInternalApi.DefinedColumnSchema.Builder builder = OtsInternalApi.DefinedColumnSchema.newBuilder();
        builder.setName(definedColun.getName());
        builder.setType(OTSProtocolBuilder.toPBDefinedColumnType(definedColun.getType()));
        return builder.build();
    }

    public static OtsInternalApi.IndexMeta buildIndexMeta(IndexMeta indexMeta) {
        OtsInternalApi.IndexMeta.Builder builder = OtsInternalApi.IndexMeta.newBuilder();
        builder.setName(indexMeta.getIndexName());
        for (String pk : indexMeta.getPrimaryKeyList()) {
            builder.addPrimaryKey(pk);
        }
        for (String definedCol : indexMeta.getDefinedColumnsList()) {
            builder.addDefinedColumn(definedCol);
        }
        builder.setIndexType(OTSProtocolBuilder.toPBIndexType(indexMeta.getIndexType()));
        builder.setIndexUpdateMode(OTSProtocolBuilder.toPBIndexUpdateMode(indexMeta.getIndexUpdateMode()));
        return builder.build();
    }

    public static OtsInternalApi.TableMeta buildTableMeta(TableMeta tableMeta) {
        OtsInternalApi.TableMeta.Builder builder = OtsInternalApi.TableMeta.newBuilder();
        builder.setTableName(tableMeta.getTableName());
        for (PrimaryKeySchema pk : tableMeta.getPrimaryKeyList()) {
            builder.addPrimaryKey(OTSProtocolBuilder.buildPrimaryKeySchema(pk));
        }
        for (DefinedColumnSchema defCol : tableMeta.getDefinedColumnsList()) {
            builder.addDefinedColumn(OTSProtocolBuilder.buildDefinedColumnSchema(defCol));
        }
        return builder.build();
    }

    private static OtsInternalApi.PrimaryKeySchema buildPrimaryKeySchema(PrimaryKeySchema pk) {
        OtsInternalApi.PrimaryKeySchema.Builder builder = OtsInternalApi.PrimaryKeySchema.newBuilder();
        builder.setName(pk.getName());
        builder.setType(OTSProtocolBuilder.toPBPrimaryKeyType(pk.getType()));
        if (pk.hasOption()) {
            builder.setOption(OTSProtocolBuilder.toPBPrimaryKeyOption(pk.getOption()));
        }
        return builder.build();
    }

    public static OtsInternalApi.GetRowRequest buildGetRowRequest(GetRowRequest request) {
        SingleRowQueryCriteria criteria = request.getRowQueryCriteria();
        OtsInternalApi.GetRowRequest.Builder builder = OtsInternalApi.GetRowRequest.newBuilder();
        builder.setTableName(criteria.getTableName());
        try {
            builder.setPrimaryKey(ByteString.copyFrom(PlainBufferBuilder.buildPrimaryKeyWithHeader(criteria.getPrimaryKey())));
        }
        catch (IOException e) {
            throw new ClientException("Bug: serialize primary key failed.", e);
        }
        for (String column : criteria.getColumnsToGet()) {
            builder.addColumnsToGet(column);
        }
        boolean onlyOneVersionInTimeRange = false;
        if (criteria.hasSetTimeRange()) {
            builder.setTimeRange(OTSProtocolBuilder.buildTimeRange(criteria.getTimeRange()));
            onlyOneVersionInTimeRange = criteria.getTimeRange().containsOnlyOneVersion();
        }
        if (criteria.hasSetMaxVersions() && !onlyOneVersionInTimeRange) {
            builder.setMaxVersions(criteria.getMaxVersions());
        }
        if (criteria.hasSetFilter()) {
            builder.setFilter(OTSProtocolBuilder.buildFilter(criteria.getFilter()));
        }
        if (criteria.hasSetStartColumn()) {
            builder.setStartColumn(criteria.getStartColumn());
        }
        if (criteria.hasSetEndColumn()) {
            builder.setEndColumn(criteria.getEndColumn());
        }
        if (criteria.hasSetToken()) {
            builder.setToken(ByteString.copyFrom(criteria.getToken()));
        }
        if (request.hasSetTransactionId()) {
            builder.setTransactionId(request.getTransactionId());
        }
        return builder.build();
    }

    public static OtsInternalApi.PartitionRange buildPartitionRange(PrimaryKeyValue leftPoint, PrimaryKeyValue rightPoint) {
        OtsInternalApi.PartitionRange.Builder builderPartition = OtsInternalApi.PartitionRange.newBuilder();
        try {
            builderPartition.setBegin(ByteString.copyFrom(PlainBufferBuilder.buildPrimaryKeyValueWithoutLengthPrefix(leftPoint)));
        }
        catch (Exception e) {
            throw new ClientException(" Failed to build the start point of partition range.", e);
        }
        try {
            builderPartition.setEnd(ByteString.copyFrom(PlainBufferBuilder.buildPrimaryKeyValueWithoutLengthPrefix(rightPoint)));
        }
        catch (Exception e) {
            throw new ClientException(" Failed to build the end point of partition range.", e);
        }
        return builderPartition.build();
    }

    public static void buildPartitionRanges(OtsInternalApi.CreateTableRequest.Builder builder, List<PrimaryKeyValue> splitPoints) {
        if (splitPoints.isEmpty()) {
            return;
        }
        PrimaryKeyValue lastPoint = null;
        for (PrimaryKeyValue currentPoint : splitPoints) {
            if (lastPoint == null) {
                builder.addPartitions(OTSProtocolBuilder.buildPartitionRange(PrimaryKeyValue.INF_MIN, currentPoint));
            } else {
                builder.addPartitions(OTSProtocolBuilder.buildPartitionRange(lastPoint, currentPoint));
            }
            lastPoint = currentPoint;
        }
        builder.addPartitions(OTSProtocolBuilder.buildPartitionRange(lastPoint, PrimaryKeyValue.INF_MAX));
    }

    private static OtsInternalApi.TimeRange buildTimeRange(TimeRange timeRange) {
        OtsInternalApi.TimeRange.Builder builder = OtsInternalApi.TimeRange.newBuilder();
        if (timeRange.containsOnlyOneVersion()) {
            builder.setSpecificTime(timeRange.getStart());
        } else {
            builder.setStartTime(timeRange.getStart());
            builder.setEndTime(timeRange.getEnd());
        }
        return builder.build();
    }

    public static OtsInternalApi.CreateTableRequest.Builder getCreateTableRequestBuilder(CreateTableRequest createTableRequest) {
        SSESpecification sseSpec;
        OtsInternalApi.CreateTableRequest.Builder builder = OtsInternalApi.CreateTableRequest.newBuilder();
        builder.setTableMeta(OTSProtocolBuilder.buildTableMeta(createTableRequest.getTableMeta()));
        builder.setReservedThroughput(OTSProtocolBuilder.buildReservedThroughput(createTableRequest.getReservedThroughput()));
        TableOptions tableOptions = createTableRequest.getTableOptions();
        if (!tableOptions.hasSetMaxVersions() || !tableOptions.hasSetTimeToLive()) {
            throw new IllegalArgumentException("The maxVersions and timeToLive must be set while creating table.");
        }
        builder.setTableOptions(OTSProtocolBuilder.buildTableOptions(tableOptions));
        StreamSpecification streamSpec = createTableRequest.getStreamSpecification();
        if (streamSpec != null) {
            builder.setStreamSpec(OTSProtocolBuilder.buildStreamSpecification(streamSpec));
        }
        if ((sseSpec = createTableRequest.getSseSpecification()) != null) {
            builder.setSseSpec(OTSProtocolBuilder.buildSseSpecification(sseSpec));
        }
        List<IndexMeta> indexMeta = createTableRequest.getIndexMetaList();
        for (IndexMeta index : indexMeta) {
            builder.addIndexMetas(OTSProtocolBuilder.buildIndexMeta(index));
        }
        if (createTableRequest.hasLocalTxnSet()) {
            builder.setEnableLocalTxn(createTableRequest.isLocalTxnEnabled());
        }
        return builder;
    }

    public static OtsInternalApi.CreateTableRequest buildCreateTableRequest(CreateTableRequest createTableRequest) {
        return OTSProtocolBuilder.getCreateTableRequestBuilder(createTableRequest).build();
    }

    public static OtsInternalApi.CreateTableRequest buildCreateTableExRequest(CreateTableRequestEx createTableRequestEx) {
        OtsInternalApi.CreateTableRequest.Builder builder = OTSProtocolBuilder.getCreateTableRequestBuilder(createTableRequestEx);
        List<PrimaryKeyValue> splitPoints = createTableRequestEx.getSplitPoints();
        OTSProtocolBuilder.buildPartitionRanges(builder, splitPoints);
        return builder.build();
    }

    private static OtsInternalApi.TableOptions buildTableOptions(TableOptions x) {
        OtsInternalApi.TableOptions.Builder builder = OtsInternalApi.TableOptions.newBuilder();
        if (x.hasSetMaxVersions()) {
            builder.setMaxVersions(x.getMaxVersions());
        }
        if (x.hasSetTimeToLive()) {
            builder.setTimeToLive(x.getTimeToLive());
        }
        if (x.hasSetMaxTimeDeviation()) {
            builder.setDeviationCellVersionInSec(x.getMaxTimeDeviation());
        }
        if (x.hasSetAllowUpdate()) {
            builder.setAllowUpdate(x.getAllowUpdate());
        }
        return builder.build();
    }

    private static OtsInternalApi.ReservedThroughput buildReservedThroughput(ReservedThroughput reservedThroughput) {
        OtsInternalApi.ReservedThroughput.Builder rtBuilder = OtsInternalApi.ReservedThroughput.newBuilder();
        CapacityUnit capacityUnit = reservedThroughput.getCapacityUnit();
        OtsInternalApi.CapacityUnit.Builder builder = OtsInternalApi.CapacityUnit.newBuilder();
        if (capacityUnit.hasSetReadCapacityUnit()) {
            builder.setRead(capacityUnit.getReadCapacityUnit());
        }
        if (capacityUnit.hasSetWriteCapacityUnit()) {
            builder.setWrite(capacityUnit.getWriteCapacityUnit());
        }
        rtBuilder.setCapacityUnit(builder.build());
        return rtBuilder.build();
    }

    public static OtsInternalApi.DeleteTableRequest buildDeleteTableRequest(DeleteTableRequest req) {
        OtsInternalApi.DeleteTableRequest.Builder builder = OtsInternalApi.DeleteTableRequest.newBuilder();
        builder.setTableName(req.getTableName());
        return builder.build();
    }

    public static OtsDelivery.CreateDeliveryTaskRequest buildCreateDeliveryTaskRequest(CreateDeliveryTaskRequest req) {
        OtsDelivery.CreateDeliveryTaskRequest.Builder builder = OtsDelivery.CreateDeliveryTaskRequest.newBuilder();
        builder.setTableName(req.getTableName());
        builder.setTaskName(req.getTaskName());
        builder.setTaskConfig(OTSProtocolBuilder.buildOSSTaskConfig(req.getTaskConfig()));
        builder.setTaskType(OTSProtocolBuilder.toPBDeliveryTaskType(req.getTaskType()));
        return builder.build();
    }

    public static OtsDelivery.OSSTaskConfig buildOSSTaskConfig(OSSTaskConfig taskConfig) {
        OtsDelivery.OSSTaskConfig.Builder builder = OtsDelivery.OSSTaskConfig.newBuilder();
        builder.setOssPrefix(taskConfig.getOssPrefix());
        builder.clearFormatter();
        builder.setOssBucket(taskConfig.getOssBucket());
        builder.setOssEndpoint(taskConfig.getOssEndpoint());
        builder.setOssStsRole(taskConfig.getOssStsRole());
        if (taskConfig.getEventTimeColumn() != null) {
            builder.setEventTimeColumn(OTSProtocolBuilder.buildEventTimeColumn(taskConfig.getEventTimeColumn()));
        }
        builder.setFormat(OTSProtocolBuilder.toPBFormat(taskConfig.getFormat()));
        for (ParquetSchema ps : taskConfig.getParquetSchemaList()) {
            builder.addSchema(OTSProtocolBuilder.buildParquetSchema(ps));
        }
        return builder.build();
    }

    private static OtsDelivery.ParquetSchema buildParquetSchema(ParquetSchema parquetSchema) {
        OtsDelivery.ParquetSchema.Builder builder = OtsDelivery.ParquetSchema.newBuilder();
        builder.setColumnName(parquetSchema.getColumnName());
        builder.setOssColumnName(parquetSchema.getOssColumnName());
        builder.setType(OTSProtocolBuilder.toPBDataType(parquetSchema.getType()));
        builder.setEncode(OTSProtocolBuilder.toPBEncoding(parquetSchema.getEncode()));
        if (parquetSchema.getTypeExtend() != null) {
            builder.setTypeExtend(parquetSchema.getTypeExtend());
        }
        return builder.build();
    }

    public static OtsDelivery.EventColumn buildEventTimeColumn(EventColumn eventColumn) {
        OtsDelivery.EventColumn.Builder builder = OtsDelivery.EventColumn.newBuilder();
        builder.setColumnName(eventColumn.getColumnName());
        builder.setTimeFormat(OTSProtocolBuilder.toPBEventTimeFormat(eventColumn.getEventTimeFormat()));
        return builder.build();
    }

    public static OtsDelivery.DeleteDeliveryTaskRequest buildDeleteDeliveryTaskRequest(DeleteDeliveryTaskRequest req) {
        OtsDelivery.DeleteDeliveryTaskRequest.Builder builder = OtsDelivery.DeleteDeliveryTaskRequest.newBuilder();
        builder.setTableName(req.getTableName());
        builder.setTaskName(req.getTaskName());
        return builder.build();
    }

    public static OtsDelivery.DescribeDeliveryTaskRequest buildDescribeDeliveryTaskRequest(DescribeDeliveryTaskRequest req) {
        OtsDelivery.DescribeDeliveryTaskRequest.Builder builder = OtsDelivery.DescribeDeliveryTaskRequest.newBuilder();
        builder.setTableName(req.getTableName());
        builder.setTaskName(req.getTaskName());
        return builder.build();
    }

    public static OtsDelivery.ListDeliveryTaskRequest buildListDeliveryTaskRequest(ListDeliveryTaskRequest req) {
        OtsDelivery.ListDeliveryTaskRequest.Builder builder = OtsDelivery.ListDeliveryTaskRequest.newBuilder();
        builder.setTableName(req.getTableName());
        return builder.build();
    }

    public static OtsInternalApi.CreateIndexRequest buildCreateIndexRequest(CreateIndexRequest req) {
        OtsInternalApi.CreateIndexRequest.Builder builder = OtsInternalApi.CreateIndexRequest.newBuilder();
        builder.setMainTableName(req.getMainTableName());
        builder.setIndexMeta(OTSProtocolBuilder.buildIndexMeta(req.getIndexMeta()));
        builder.setIncludeBaseData(req.getIncludeBaseData());
        return builder.build();
    }

    public static OtsInternalApi.DropIndexRequest buildDeleteIndexRequest(DeleteIndexRequest req) {
        OtsInternalApi.DropIndexRequest.Builder builder = OtsInternalApi.DropIndexRequest.newBuilder();
        builder.setMainTableName(req.getMainTableName());
        builder.setIndexName(req.getIndexName());
        return builder.build();
    }

    public static OtsInternalApi.AddDefinedColumnRequest buildAddDefinedColumnRequest(AddDefinedColumnRequest req) {
        OtsInternalApi.AddDefinedColumnRequest.Builder builder = OtsInternalApi.AddDefinedColumnRequest.newBuilder();
        builder.setTableName(req.getTableName());
        List<DefinedColumnSchema> defColumns = req.getDefinedColumn();
        for (DefinedColumnSchema col : defColumns) {
            builder.addColumns(OTSProtocolBuilder.buildDefinedColumnSchema(col));
        }
        return builder.build();
    }

    public static OtsInternalApi.DeleteDefinedColumnRequest buildDeleteDefinedColumnRequest(DeleteDefinedColumnRequest req) {
        OtsInternalApi.DeleteDefinedColumnRequest.Builder builder = OtsInternalApi.DeleteDefinedColumnRequest.newBuilder();
        builder.setTableName(req.getTableName());
        List<String> defColumns = req.getDefinedColumn();
        for (String col : defColumns) {
            builder.addColumns(col);
        }
        return builder.build();
    }

    public static OtsInternalApi.RowExistenceExpectation toPBRowExistenceExpectation(RowExistenceExpectation rowExistenceExpectation) {
        switch (rowExistenceExpectation) {
            case EXPECT_EXIST: {
                return OtsInternalApi.RowExistenceExpectation.EXPECT_EXIST;
            }
            case EXPECT_NOT_EXIST: {
                return OtsInternalApi.RowExistenceExpectation.EXPECT_NOT_EXIST;
            }
            case IGNORE: {
                return OtsInternalApi.RowExistenceExpectation.IGNORE;
            }
        }
        throw new IllegalArgumentException("Invalid row existence expectation: " + (Object)((Object)rowExistenceExpectation));
    }

    public static OtsInternalApi.Condition buildCondition(Condition cond) {
        OtsInternalApi.Condition.Builder builder = OtsInternalApi.Condition.newBuilder();
        builder.setRowExistence(OTSProtocolBuilder.toPBRowExistenceExpectation(cond.getRowExistenceExpectation()));
        if (cond.getColumnCondition() != null) {
            builder.setColumnCondition(OTSProtocolBuilder.buildFilter(cond.getColumnCondition()));
        }
        return builder.build();
    }

    public static OtsInternalApi.ReturnContent buildReturnContent(ReturnType returnType, Set<String> returnColumnNames) {
        OtsInternalApi.ReturnContent.Builder builder = OtsInternalApi.ReturnContent.newBuilder();
        builder.setReturnType(OTSProtocolBuilder.toPBReturnType(returnType));
        for (String column : returnColumnNames) {
            builder.addReturnColumnNames(column);
        }
        return builder.build();
    }

    private static OtsInternalApi.ReturnType toPBReturnType(ReturnType returnType) {
        switch (returnType) {
            case RT_NONE: {
                return OtsInternalApi.ReturnType.RT_NONE;
            }
            case RT_PK: {
                return OtsInternalApi.ReturnType.RT_PK;
            }
            case RT_AFTER_MODIFY: {
                return OtsInternalApi.ReturnType.RT_AFTER_MODIFY;
            }
        }
        throw new IllegalArgumentException("Invalid return type: " + (Object)((Object)returnType));
    }

    public static OtsInternalApi.DeleteRowRequest buildDeleteRowRequest(DeleteRowRequest request) {
        OtsInternalApi.DeleteRowRequest.Builder builder = OtsInternalApi.DeleteRowRequest.newBuilder();
        RowDeleteChange rowChange = request.getRowChange();
        builder.setTableName(rowChange.getTableName());
        try {
            builder.setPrimaryKey(ByteString.copyFrom(PlainBufferBuilder.buildRowDeleteChangeWithHeader(rowChange)));
            builder.setCondition(OTSProtocolBuilder.buildCondition(rowChange.getCondition()));
            builder.setReturnContent(OTSProtocolBuilder.buildReturnContent(rowChange.getReturnType(), rowChange.getReturnColumnNames()));
        }
        catch (IOException e) {
            throw new ClientException("Bug: serialize row delete change failed.", e);
        }
        if (request.hasSetTransactionId()) {
            builder.setTransactionId(request.getTransactionId());
        }
        return builder.build();
    }

    public static OtsInternalApi.PutRowRequest buildPutRowRequest(PutRowRequest request) {
        OtsInternalApi.PutRowRequest.Builder builder = OtsInternalApi.PutRowRequest.newBuilder();
        RowPutChange rowChange = request.getRowChange();
        builder.setTableName(rowChange.getTableName());
        try {
            builder.setRow(ByteString.copyFrom(PlainBufferBuilder.buildRowPutChangeWithHeader(rowChange)));
            builder.setCondition(OTSProtocolBuilder.buildCondition(rowChange.getCondition()));
            builder.setReturnContent(OTSProtocolBuilder.buildReturnContent(rowChange.getReturnType(), rowChange.getReturnColumnNames()));
        }
        catch (IOException e) {
            throw new ClientException("Bug: serialize row put change failed.", e);
        }
        if (request.hasSetTransactionId()) {
            builder.setTransactionId(request.getTransactionId());
        }
        return builder.build();
    }

    public static OtsInternalApi.ListTableRequest buildListTableRequest() {
        OtsInternalApi.ListTableRequest.Builder builder = OtsInternalApi.ListTableRequest.newBuilder();
        return builder.build();
    }

    public static OtsInternalApi.DescribeTableRequest buildDescribeTableRequest(DescribeTableRequest req) {
        OtsInternalApi.DescribeTableRequest.Builder builder = OtsInternalApi.DescribeTableRequest.newBuilder();
        builder.setTableName(req.getTableName());
        return builder.build();
    }

    public static OtsInternalApi.UpdateRowRequest buildUpdateRowRequest(UpdateRowRequest request) {
        OtsInternalApi.UpdateRowRequest.Builder builder = OtsInternalApi.UpdateRowRequest.newBuilder();
        RowUpdateChange rowChange = request.getRowChange();
        builder.setTableName(rowChange.getTableName());
        try {
            builder.setRowChange(ByteString.copyFrom(PlainBufferBuilder.buildRowUpdateChangeWithHeader(rowChange)));
            builder.setCondition(OTSProtocolBuilder.buildCondition(rowChange.getCondition()));
            builder.setReturnContent(OTSProtocolBuilder.buildReturnContent(rowChange.getReturnType(), rowChange.getReturnColumnNames()));
        }
        catch (IOException e) {
            throw new ClientException("Bug: serialize row update change failed.", e);
        }
        if (request.hasSetTransactionId()) {
            builder.setTransactionId(request.getTransactionId());
        }
        return builder.build();
    }

    public static OtsInternalApi.Direction toPBDirection(Direction direction) {
        switch (direction) {
            case BACKWARD: {
                return OtsInternalApi.Direction.BACKWARD;
            }
            case FORWARD: {
                return OtsInternalApi.Direction.FORWARD;
            }
        }
        throw new IllegalArgumentException("Invalid direction type: " + (Object)((Object)direction));
    }

    public static OtsInternalApi.ComputeSplitPointsBySizeRequest buildComputeSplitsBySizeRequest(ComputeSplitsBySizeRequest req) {
        OtsInternalApi.ComputeSplitPointsBySizeRequest.Builder builder = OtsInternalApi.ComputeSplitPointsBySizeRequest.newBuilder();
        builder.setTableName(req.getTableName());
        builder.setSplitSize(req.getSplitUnitCount());
        builder.setSplitSizeUnitInByte(req.getSplitUnitSizeInByte());
        if (req.hasSetSplitPointLimit()) {
            builder.setSplitPointLimit(req.getSplitPointLimit());
        }
        return builder.build();
    }

    public static OtsInternalApi.GetRangeRequest buildGetRangeRequest(GetRangeRequest request) {
        RangeRowQueryCriteria criteria = request.getRangeRowQueryCriteria();
        OtsInternalApi.GetRangeRequest.Builder builder = OtsInternalApi.GetRangeRequest.newBuilder();
        builder.setTableName(criteria.getTableName());
        builder.setDirection(OTSProtocolBuilder.toPBDirection(criteria.getDirection()));
        for (String column : criteria.getColumnsToGet()) {
            builder.addColumnsToGet(column);
        }
        boolean onlyOneVersionInTimeRange = false;
        if (criteria.hasSetTimeRange()) {
            builder.setTimeRange(OTSProtocolBuilder.buildTimeRange(criteria.getTimeRange()));
            onlyOneVersionInTimeRange = criteria.getTimeRange().containsOnlyOneVersion();
        }
        if (criteria.hasSetMaxVersions() && !onlyOneVersionInTimeRange) {
            builder.setMaxVersions(criteria.getMaxVersions());
        }
        if (criteria.getLimit() > 0) {
            builder.setLimit(criteria.getLimit());
        }
        try {
            builder.setInclusiveStartPrimaryKey(ByteString.copyFrom(PlainBufferBuilder.buildPrimaryKeyWithHeader(criteria.getInclusiveStartPrimaryKey())));
            builder.setExclusiveEndPrimaryKey(ByteString.copyFrom(PlainBufferBuilder.buildPrimaryKeyWithHeader(criteria.getExclusiveEndPrimaryKey())));
        }
        catch (IOException e) {
            throw new ClientException("Bug: serialize primary key failed.", e);
        }
        if (criteria.hasSetFilter()) {
            builder.setFilter(OTSProtocolBuilder.buildFilter(criteria.getFilter()));
        }
        if (criteria.hasSetStartColumn()) {
            builder.setStartColumn(criteria.getStartColumn());
        }
        if (criteria.hasSetEndColumn()) {
            builder.setEndColumn(criteria.getEndColumn());
        }
        if (criteria.hasSetToken()) {
            builder.setToken(ByteString.copyFrom(criteria.getToken()));
        }
        if (request.hasSetTransactionId()) {
            builder.setTransactionId(request.getTransactionId());
        }
        return builder.build();
    }

    public static OtsInternalApi.BulkExportRequest buildBulkExportRequest(BulkExportRequest request) {
        BulkExportQueryCriteria criteria = request.getBulkExportQueryCriteria();
        OtsInternalApi.BulkExportRequest.Builder builder = OtsInternalApi.BulkExportRequest.newBuilder();
        builder.setTableName(criteria.getTableName());
        for (String column : criteria.getColumnsToGet()) {
            builder.addColumnsToGet(column);
        }
        try {
            builder.setInclusiveStartPrimaryKey(ByteString.copyFrom(PlainBufferBuilder.buildPrimaryKeyWithHeader(criteria.getInclusiveStartPrimaryKey())));
            builder.setExclusiveEndPrimaryKey(ByteString.copyFrom(PlainBufferBuilder.buildPrimaryKeyWithHeader(criteria.getExclusiveEndPrimaryKey())));
        }
        catch (IOException e) {
            throw new ClientException("Bug: serialize primary key failed.", e);
        }
        if (criteria.hasSetFilter()) {
            builder.setFilter(OTSProtocolBuilder.buildFilter(criteria.getFilter()));
        }
        if (criteria.getDataBlockType() == DataBlockType.DBT_PLAIN_BUFFER) {
            builder.setDataBlockTypeHint(OtsInternalApi.DataBlockType.DBT_PLAIN_BUFFER);
        } else {
            builder.setDataBlockTypeHint(OtsInternalApi.DataBlockType.DBT_SIMPLE_ROW_MATRIX);
        }
        return builder.build();
    }

    public static OtsInternalApi.BatchGetRowRequest buildBatchGetRowRequest(Map<String, MultiRowQueryCriteria> criteriasGroupByTable) {
        OtsInternalApi.BatchGetRowRequest.Builder builder = OtsInternalApi.BatchGetRowRequest.newBuilder();
        for (Map.Entry<String, MultiRowQueryCriteria> entry : criteriasGroupByTable.entrySet()) {
            String tableName = entry.getKey();
            MultiRowQueryCriteria criteria = entry.getValue();
            OtsInternalApi.TableInBatchGetRowRequest.Builder tableBuilder = OtsInternalApi.TableInBatchGetRowRequest.newBuilder();
            tableBuilder.setTableName(tableName);
            if (criteria.getRowKeys().size() != criteria.getTokens().size()) {
                throw new ClientException("The number of primaryKeys and tokens must be the same.");
            }
            for (int i = 0; i < criteria.getRowKeys().size(); ++i) {
                try {
                    tableBuilder.addPrimaryKey(ByteString.copyFrom(PlainBufferBuilder.buildPrimaryKeyWithHeader(criteria.get(i))));
                    tableBuilder.addToken(ByteString.copyFrom(criteria.getTokens().get(i)));
                    continue;
                }
                catch (IOException e) {
                    throw new ClientException("Bug: serialize primary key failed.", e);
                }
            }
            for (String column : criteria.getColumnsToGet()) {
                tableBuilder.addColumnsToGet(column);
            }
            boolean onlyOneVersionInTimeRange = false;
            if (criteria.hasSetTimeRange()) {
                tableBuilder.setTimeRange(OTSProtocolBuilder.buildTimeRange(criteria.getTimeRange()));
                onlyOneVersionInTimeRange = criteria.getTimeRange().containsOnlyOneVersion();
            }
            if (criteria.hasSetMaxVersions() && !onlyOneVersionInTimeRange) {
                tableBuilder.setMaxVersions(criteria.getMaxVersions());
            }
            if (criteria.hasSetFilter()) {
                tableBuilder.setFilter(OTSProtocolBuilder.buildFilter(criteria.getFilter()));
            }
            if (criteria.hasSetStartColumn()) {
                tableBuilder.setStartColumn(criteria.getStartColumn());
            }
            if (criteria.hasSetEndColumn()) {
                tableBuilder.setEndColumn(criteria.getEndColumn());
            }
            builder.addTables(tableBuilder.build());
        }
        return builder.build();
    }

    public static OtsInternalApi.BatchWriteRowRequest buildBatchWriteRowRequest(BatchWriteRowRequest request) {
        OtsInternalApi.BatchWriteRowRequest.Builder builder = OtsInternalApi.BatchWriteRowRequest.newBuilder();
        for (String tableName : request.getRowChange().keySet()) {
            OtsInternalApi.TableInBatchWriteRowRequest.Builder tableBuilder = OtsInternalApi.TableInBatchWriteRowRequest.newBuilder();
            tableBuilder.setTableName(tableName);
            List<RowChange> rowChanges = request.getRowChange().get(tableName);
            if (rowChanges != null && !rowChanges.isEmpty()) {
                for (RowChange rowChange : rowChanges) {
                    try {
                        OtsInternalApi.RowInBatchWriteRowRequest.Builder rowBuilder = OtsInternalApi.RowInBatchWriteRowRequest.newBuilder();
                        if (rowChange instanceof RowPutChange) {
                            rowBuilder.setType(OtsInternalApi.OperationType.PUT);
                            rowBuilder.setRowChange(ByteString.copyFrom(PlainBufferBuilder.buildRowPutChangeWithHeader((RowPutChange)rowChange)));
                        } else if (rowChange instanceof RowUpdateChange) {
                            rowBuilder.setType(OtsInternalApi.OperationType.UPDATE);
                            rowBuilder.setRowChange(ByteString.copyFrom(PlainBufferBuilder.buildRowUpdateChangeWithHeader((RowUpdateChange)rowChange)));
                        } else if (rowChange instanceof RowDeleteChange) {
                            rowBuilder.setType(OtsInternalApi.OperationType.DELETE);
                            rowBuilder.setRowChange(ByteString.copyFrom(PlainBufferBuilder.buildRowDeleteChangeWithHeader((RowDeleteChange)rowChange)));
                        } else {
                            throw new ClientException("Unknown type of rowChange.");
                        }
                        rowBuilder.setCondition(OTSProtocolBuilder.buildCondition(rowChange.getCondition()));
                        rowBuilder.setReturnContent(OTSProtocolBuilder.buildReturnContent(rowChange.getReturnType(), rowChange.getReturnColumnNames()));
                        tableBuilder.addRows(rowBuilder.build());
                    }
                    catch (IOException e) {
                        throw new ClientException("Bug: serialize row put change failed.", e);
                    }
                }
            }
            builder.addTables(tableBuilder.build());
        }
        if (request.hasSetTransactionId()) {
            builder.setTransactionId(request.getTransactionId());
        }
        if (request.isAtomicSet()) {
            builder.setIsAtomic(request.isAtomic());
        }
        return builder.build();
    }

    public static OtsInternalApi.BulkImportRequest buildBulkImportRequest(BulkImportRequest request) {
        OtsInternalApi.BulkImportRequest.Builder builder = OtsInternalApi.BulkImportRequest.newBuilder();
        builder.setTableName(request.getTableName());
        List<RowChange> rowChanges = request.getRowChange();
        if (rowChanges != null && !rowChanges.isEmpty()) {
            for (RowChange rowChange : rowChanges) {
                try {
                    OtsInternalApi.RowInBulkImportRequest.Builder rowBuilder = OtsInternalApi.RowInBulkImportRequest.newBuilder();
                    if (rowChange instanceof RowPutChange) {
                        rowBuilder.setType(OtsInternalApi.OperationType.PUT);
                        rowBuilder.setRowChange(ByteString.copyFrom(PlainBufferBuilder.buildRowPutChangeWithHeader((RowPutChange)rowChange)));
                    } else if (rowChange instanceof RowUpdateChange) {
                        rowBuilder.setType(OtsInternalApi.OperationType.UPDATE);
                        rowBuilder.setRowChange(ByteString.copyFrom(PlainBufferBuilder.buildRowUpdateChangeWithHeader((RowUpdateChange)rowChange)));
                    } else if (rowChange instanceof RowDeleteChange) {
                        rowBuilder.setType(OtsInternalApi.OperationType.DELETE);
                        rowBuilder.setRowChange(ByteString.copyFrom(PlainBufferBuilder.buildRowDeleteChangeWithHeader((RowDeleteChange)rowChange)));
                    } else {
                        throw new ClientException("Unknown type of rowChange.");
                    }
                    builder.addRows(rowBuilder.build());
                }
                catch (IOException e) {
                    throw new ClientException("Bug: serialize row put change failed.", e);
                }
            }
        }
        return builder.build();
    }

    public static OtsInternalApi.UpdateTableRequest buildUpdateTableRequest(UpdateTableRequest updateTableRequest) {
        OtsInternalApi.UpdateTableRequest.Builder builder = OtsInternalApi.UpdateTableRequest.newBuilder();
        builder.setTableName(updateTableRequest.getTableName());
        if (updateTableRequest.getReservedThroughputForUpdate() != null) {
            builder.setReservedThroughput(OTSProtocolBuilder.buildReservedThroughput(updateTableRequest.getReservedThroughputForUpdate()));
        }
        if (updateTableRequest.getTableOptionsForUpdate() != null) {
            builder.setTableOptions(OTSProtocolBuilder.buildTableOptions(updateTableRequest.getTableOptionsForUpdate()));
        }
        if (updateTableRequest.getStreamSpecification() != null) {
            builder.setStreamSpec(OTSProtocolBuilder.buildStreamSpecification(updateTableRequest.getStreamSpecification()));
        }
        return builder.build();
    }

    private static OtsInternalApi.StreamSpecification buildStreamSpecification(StreamSpecification streamSpecification) {
        OtsInternalApi.StreamSpecification.Builder builder = OtsInternalApi.StreamSpecification.newBuilder();
        builder.setEnableStream(streamSpecification.isEnableStream());
        if (streamSpecification.getExpirationTime() > 0) {
            builder.setExpirationTime(streamSpecification.getExpirationTime());
        }
        if (streamSpecification.isEnableStream()) {
            for (String column : streamSpecification.getOriginColumnsToGet()) {
                builder.addColumnsToGet(column);
            }
        }
        return builder.build();
    }

    private static OtsInternalApi.SSESpecification buildSseSpecification(SSESpecification sseSpecification) {
        OtsInternalApi.SSESpecification.Builder builder = OtsInternalApi.SSESpecification.newBuilder();
        builder.setEnable(sseSpecification.isEnable());
        if (sseSpecification.getKeyType() != null) {
            SSEKeyType keyType = sseSpecification.getKeyType();
            switch (keyType) {
                case SSE_KMS_SERVICE: {
                    builder.setKeyType(OtsInternalApi.SSEKeyType.SSE_KMS_SERVICE);
                    break;
                }
                case SSE_BYOK: {
                    builder.setKeyType(OtsInternalApi.SSEKeyType.SSE_BYOK);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown server side encryption key type: " + (Object)((Object)keyType));
                }
            }
        }
        if (sseSpecification.getKeyId() != null) {
            builder.setKeyId(ByteString.copyFrom(sseSpecification.getKeyId().getBytes()));
        }
        if (sseSpecification.getRoleArn() != null) {
            builder.setRoleArn(ByteString.copyFrom(sseSpecification.getRoleArn().getBytes()));
        }
        return builder.build();
    }

    public static OtsFilter.LogicalOperator toLogicalOperator(CompositeColumnValueFilter.LogicOperator type) {
        switch (type) {
            case NOT: {
                return OtsFilter.LogicalOperator.LO_NOT;
            }
            case AND: {
                return OtsFilter.LogicalOperator.LO_AND;
            }
            case OR: {
                return OtsFilter.LogicalOperator.LO_OR;
            }
        }
        throw new IllegalArgumentException("Unknown logic operation type: " + (Object)((Object)type));
    }

    public static OtsFilter.Filter toFilter(ColumnCondition f) {
        OtsFilter.Filter.Builder builder = OtsFilter.Filter.newBuilder();
        builder.setType(OTSProtocolBuilder.toFilterType(f.getConditionType()));
        builder.setFilter(f.serialize());
        return builder.build();
    }

    public static OtsFilter.Filter toFilter(Filter f) {
        OtsFilter.Filter.Builder builder = OtsFilter.Filter.newBuilder();
        builder.setType(OTSProtocolBuilder.toFilterType(f.getFilterType()));
        builder.setFilter(f.serialize());
        return builder.build();
    }

    public static OtsFilter.FilterType toFilterType(ColumnConditionType type) {
        switch (type) {
            case COMPOSITE_COLUMN_VALUE_CONDITION: {
                return OtsFilter.FilterType.FT_COMPOSITE_COLUMN_VALUE;
            }
            case SINGLE_COLUMN_VALUE_CONDITION: {
                return OtsFilter.FilterType.FT_SINGLE_COLUMN_VALUE;
            }
        }
        throw new IllegalArgumentException("Unknown filter type: " + (Object)((Object)type));
    }

    public static OtsFilter.FilterType toFilterType(FilterType type) {
        switch (type) {
            case COMPOSITE_COLUMN_VALUE_FILTER: {
                return OtsFilter.FilterType.FT_COMPOSITE_COLUMN_VALUE;
            }
            case SINGLE_COLUMN_VALUE_FILTER: {
                return OtsFilter.FilterType.FT_SINGLE_COLUMN_VALUE;
            }
            case COLUMN_PAGINATION_FILTER: {
                return OtsFilter.FilterType.FT_COLUMN_PAGINATION;
            }
        }
        throw new IllegalArgumentException("Unknown filter type: " + (Object)((Object)type));
    }

    public static ByteString buildFilter(ColumnCondition filter) {
        return OTSProtocolBuilder.toFilter(filter).toByteString();
    }

    public static ByteString buildFilter(Filter filter) {
        return OTSProtocolBuilder.toFilter(filter).toByteString();
    }

    public static ByteString buildCompositeColumnValueFilter(CompositeColumnValueFilter filter) {
        OtsFilter.CompositeColumnValueFilter.Builder builder = OtsFilter.CompositeColumnValueFilter.newBuilder();
        builder.setCombinator(OTSProtocolBuilder.toLogicalOperator(filter.getOperationType()));
        for (Filter filter2 : filter.getSubFilters()) {
            builder.addSubFilters(OTSProtocolBuilder.toFilter(filter2));
        }
        return builder.build().toByteString();
    }

    public static ByteString buildSingleColumnValueFilter(SingleColumnValueFilter filter) {
        OtsFilter.SingleColumnValueFilter.Builder builder = OtsFilter.SingleColumnValueFilter.newBuilder();
        builder.setColumnName(filter.getColumnName());
        builder.setComparator(OTSProtocolBuilder.toComparatorType(filter.getOperator()));
        try {
            builder.setColumnValue(ByteString.copyFrom(PlainBufferBuilder.buildColumnValueWithoutLengthPrefix(filter.getColumnValue())));
        }
        catch (IOException e) {
            throw new ClientException("Bug: serialize column value failed.", e);
        }
        builder.setFilterIfMissing(!filter.isPassIfMissing());
        builder.setLatestVersionOnly(filter.isLatestVersionsOnly());
        return builder.build().toByteString();
    }

    public static ByteString buildSingleColumnValueRegexFilter(SingleColumnValueRegexFilter filter) {
        OtsFilter.SingleColumnValueFilter.Builder builder = OtsFilter.SingleColumnValueFilter.newBuilder();
        builder.setColumnName(filter.getColumnName());
        if (filter.hasRegexRule()) {
            builder.setValueTransRule(filter.getRegexRule().serialize());
        }
        builder.setComparator(OTSProtocolBuilder.toComparatorType(filter.getOperator()));
        try {
            builder.setColumnValue(ByteString.copyFrom(PlainBufferBuilder.buildColumnValueWithoutLengthPrefix(filter.getColumnValue())));
        }
        catch (IOException e) {
            throw new ClientException("Bug: serialize column value failed.", e);
        }
        builder.setFilterIfMissing(true);
        builder.setLatestVersionOnly(filter.getLatestVersionsOnly());
        return builder.build().toByteString();
    }

    private static OtsFilter.ComparatorType toComparatorType(SingleColumnValueRegexFilter.CompareOperator operator) {
        switch (operator) {
            case EQUAL: {
                return OtsFilter.ComparatorType.CT_EQUAL;
            }
            case NOT_EQUAL: {
                return OtsFilter.ComparatorType.CT_NOT_EQUAL;
            }
            case GREATER_THAN: {
                return OtsFilter.ComparatorType.CT_GREATER_THAN;
            }
            case GREATER_EQUAL: {
                return OtsFilter.ComparatorType.CT_GREATER_EQUAL;
            }
            case LESS_THAN: {
                return OtsFilter.ComparatorType.CT_LESS_THAN;
            }
            case LESS_EQUAL: {
                return OtsFilter.ComparatorType.CT_LESS_EQUAL;
            }
            case EXIST: {
                return OtsFilter.ComparatorType.CT_EXIST;
            }
            case NOT_EXIST: {
                return OtsFilter.ComparatorType.CT_NOT_EXIST;
            }
        }
        throw new IllegalArgumentException("Unknown compare operator: " + (Object)((Object)operator));
    }

    private static OtsFilter.ComparatorType toComparatorType(SingleColumnValueFilter.CompareOperator operator) {
        switch (operator) {
            case EQUAL: {
                return OtsFilter.ComparatorType.CT_EQUAL;
            }
            case NOT_EQUAL: {
                return OtsFilter.ComparatorType.CT_NOT_EQUAL;
            }
            case GREATER_THAN: {
                return OtsFilter.ComparatorType.CT_GREATER_THAN;
            }
            case GREATER_EQUAL: {
                return OtsFilter.ComparatorType.CT_GREATER_EQUAL;
            }
            case LESS_THAN: {
                return OtsFilter.ComparatorType.CT_LESS_THAN;
            }
            case LESS_EQUAL: {
                return OtsFilter.ComparatorType.CT_LESS_EQUAL;
            }
        }
        throw new IllegalArgumentException("Unknown compare operator: " + (Object)((Object)operator));
    }

    public static ByteString buildColumnPaginationFilter(ColumnPaginationFilter filter) {
        OtsFilter.ColumnPaginationFilter.Builder builder = OtsFilter.ColumnPaginationFilter.newBuilder();
        builder.setLimit(filter.getLimit());
        builder.setOffset(filter.getOffset());
        return builder.build().toByteString();
    }

    public static Message buildListStreamRequest(ListStreamRequest request) {
        OtsInternalApi.ListStreamRequest.Builder builder = OtsInternalApi.ListStreamRequest.newBuilder();
        if (request.getTableName() != null) {
            builder.setTableName(request.getTableName());
        }
        return builder.build();
    }

    public static OtsInternalApi.DescribeStreamRequest buildDescribeStreamRequest(DescribeStreamRequest request) {
        OtsInternalApi.DescribeStreamRequest.Builder builder = OtsInternalApi.DescribeStreamRequest.newBuilder();
        builder.setStreamId(request.getStreamId());
        if (request.getInclusiveStartShardId() != null) {
            builder.setInclusiveStartShardId(request.getInclusiveStartShardId());
        }
        if (request.getShardLimit() > 0) {
            builder.setShardLimit(request.getShardLimit());
        }
        if (request.isSupportTimeseriesTable()) {
            builder.setSupportTimeseriesDataTable(true);
        }
        return builder.build();
    }

    public static OtsInternalApi.GetShardIteratorRequest buildGetShardIteratorRequest(GetShardIteratorRequest request) {
        OtsInternalApi.GetShardIteratorRequest.Builder builder = OtsInternalApi.GetShardIteratorRequest.newBuilder();
        builder.setStreamId(request.getStreamId());
        builder.setShardId(request.getShardId());
        if (request.hasTimestamp()) {
            builder.setTimestamp(request.getTimestamp());
        }
        if (request.hasToken()) {
            builder.setToken(request.getToken());
        }
        return builder.build();
    }

    public static OtsInternalApi.GetStreamRecordRequest buildGetStreamRecordRequest(GetStreamRecordRequest request) {
        OtsInternalApi.GetStreamRecordRequest.Builder builder = OtsInternalApi.GetStreamRecordRequest.newBuilder();
        builder.setShardIterator(request.getShardIterator());
        if (request.getLimit() > 0) {
            builder.setLimit(request.getLimit());
        }
        if (request.getTableName() != null && !request.getTableName().isEmpty()) {
            builder.setTableName(request.getTableName());
        }
        return builder.build();
    }

    public static OtsInternalApi.AbortTransactionRequest buildAbortTransactionRequest(AbortTransactionRequest request) {
        OtsInternalApi.AbortTransactionRequest.Builder builder = OtsInternalApi.AbortTransactionRequest.newBuilder();
        builder.setTransactionId(request.getTransactionID());
        return builder.build();
    }

    public static OtsInternalApi.StartLocalTransactionRequest buildStartLocalTransactionRequest(StartLocalTransactionRequest request) {
        OtsInternalApi.StartLocalTransactionRequest.Builder builder = OtsInternalApi.StartLocalTransactionRequest.newBuilder();
        builder.setTableName(request.getTableName());
        try {
            builder.setKey(ByteString.copyFrom(PlainBufferBuilder.buildPrimaryKeyWithHeader(request.getPrimaryKey())));
        }
        catch (IOException e) {
            throw new ClientException("Bug: serialize StartLocalTransactionRequest failed.", e);
        }
        return builder.build();
    }

    public static OtsInternalApi.CommitTransactionRequest buildCommitTransactionRequest(CommitTransactionRequest request) {
        OtsInternalApi.CommitTransactionRequest.Builder builder = OtsInternalApi.CommitTransactionRequest.newBuilder();
        builder.setTransactionId(request.getTransactionID());
        return builder.build();
    }

    public static OtsInternalApi.ComputeSplitsRequest buildComputeSplitsRequest(ComputeSplitsRequest request) {
        SplitsOptions splitsOptions;
        OtsInternalApi.ComputeSplitsRequest.Builder builder = OtsInternalApi.ComputeSplitsRequest.newBuilder();
        if (null != request.getTableName()) {
            builder.setTableName(request.getTableName());
        }
        if (null != request.getSplitsOptions() && (splitsOptions = request.getSplitsOptions()) instanceof SearchIndexSplitsOptions) {
            SearchIndexSplitsOptions searchIndexSplitsOptions = (SearchIndexSplitsOptions)splitsOptions;
            OtsInternalApi.SearchIndexSplitsOptions.Builder optionsBuilder = OtsInternalApi.SearchIndexSplitsOptions.newBuilder();
            if (null != searchIndexSplitsOptions.getIndexName()) {
                optionsBuilder.setIndexName(searchIndexSplitsOptions.getIndexName());
            }
            builder.setSearchIndexSplitsOptions(optionsBuilder.build());
        }
        return builder.build();
    }

    public static OtsInternalApi.SQLQueryRequest buildSQLQueryRequest(SQLQueryRequest request) {
        OtsInternalApi.SQLQueryRequest.Builder builder = OtsInternalApi.SQLQueryRequest.newBuilder();
        builder.setQuery(request.getQuery());
        builder.setVersion(OTSProtocolBuilder.buildSQLPayloadVersion(request.getSqlPayloadVersion()));
        builder.setSqlVersion(1L);
        return builder.build();
    }

    public static OtsInternalApi.SQLPayloadVersion buildSQLPayloadVersion(SQLPayloadVersion sqlPayloadVersion) {
        switch (sqlPayloadVersion) {
            case SQL_FLAT_BUFFERS: {
                return OtsInternalApi.SQLPayloadVersion.SQL_FLAT_BUFFERS;
            }
        }
        throw new UnsupportedOperationException("not supported sql payload version: " + (Object)((Object)sqlPayloadVersion));
    }
}

