/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.auth;

import com.alicloud.openservices.tablestore.core.auth.HmacSHA256Signature;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentialsV4;
import com.alicloud.openservices.tablestore.core.auth.SignatureMakerInterface;
import com.alicloud.openservices.tablestore.core.auth.V4Credentials;
import com.alicloud.openservices.tablestore.core.http.RequestMessage;
import com.aliyun.ots.thirdparty.org.apache.Header;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.TreeMap;

public class V4SignatureMaker
implements SignatureMakerInterface {
    private final ServiceCredentialsV4 credentials;

    public V4SignatureMaker(ServiceCredentialsV4 credentials) {
        this.credentials = credentials;
    }

    @Override
    public String getSignature(byte[] accessKey, String action, String method, Header[] headers) throws UnsupportedEncodingException {
        StringBuilder canonicalizedOtsHeader = new StringBuilder(1000);
        TreeMap<String, String> headerMap = new TreeMap<String, String>();
        for (Header header : headers) {
            headerMap.put(header.getName(), header.getValue());
        }
        for (Map.Entry entry : headerMap.entrySet()) {
            String key = (String)entry.getKey();
            String val = ((String)entry.getValue()).trim();
            if (!key.startsWith("x-ots-")) continue;
            canonicalizedOtsHeader.append(key).append(":").append(val).append("\n");
        }
        StringBuilder sb = new StringBuilder(1000);
        sb.append("/").append(action).append("\n").append(method).append("\n").append("\n").append((CharSequence)canonicalizedOtsHeader);
        sb.append("ots");
        HmacSHA256Signature hmacSHA256Signature = new HmacSHA256Signature(accessKey);
        hmacSHA256Signature.updateUTF8String(sb.toString());
        return hmacSHA256Signature.computeSignature();
    }

    @Override
    public String getSignatureHeader() {
        return "x-ots-signaturev4";
    }

    @Override
    public void addExtraHeader(RequestMessage request) {
        request.addHeader("x-ots-accesskeyid", this.credentials.getAccessKeyId());
        if (this.credentials.getSecurityToken() != null && !this.credentials.getSecurityToken().isEmpty()) {
            request.addHeader("x-ots-ststoken", this.credentials.getSecurityToken());
        }
        request.addHeader("x-ots-signdate", ((V4Credentials)this.credentials).getSigningDate());
        request.addHeader("x-ots-signregion", ((V4Credentials)this.credentials).getRegion());
    }
}

