/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore.util;

import com.alicloud.openservices.tablestore.model.ColumnType;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.DefinedColumnType;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.filter.ColumnValueFilter;
import com.alicloud.openservices.tablestore.model.filter.CompositeColumnValueFilter;
import com.alicloud.openservices.tablestore.model.filter.SingleColumnValueFilter;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Marker;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.tablestore.TablestoreErrorCode;
import io.airlift.slice.Slice;
import java.util.ArrayList;

public class TypeUtil {
    private static final Logger log = Logger.get(TypeUtil.class);

    private TypeUtil() {
    }

    public static boolean typeCompatible(PrimaryKeyType type, Type targetType) {
        switch (type) {
            case STRING: {
                return VarcharType.VARCHAR.equals((Object)targetType);
            }
            case INTEGER: {
                return BigintType.BIGINT.equals((Object)targetType);
            }
            case BINARY: {
                return VarbinaryType.VARBINARY.equals((Object)targetType);
            }
        }
        return false;
    }

    public static ColumnType toColumnType(DefinedColumnType dct) {
        switch (dct) {
            case STRING: {
                return ColumnType.STRING;
            }
            case INTEGER: {
                return ColumnType.INTEGER;
            }
            case BINARY: {
                return ColumnType.BINARY;
            }
            case BOOLEAN: {
                return ColumnType.BOOLEAN;
            }
            case DOUBLE: {
                return ColumnType.DOUBLE;
            }
        }
        throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.TYPE_NOT_SUPPORTED, "Unrecognized defined column type: " + dct);
    }

    public static PrimaryKeyType toPrimaryKeyType(DefinedColumnType dct) {
        switch (dct) {
            case STRING: {
                return PrimaryKeyType.STRING;
            }
            case INTEGER: {
                return PrimaryKeyType.INTEGER;
            }
            case BINARY: {
                return PrimaryKeyType.BINARY;
            }
            case BOOLEAN: 
            case DOUBLE: {
                throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.META_CHECK_FAILED, "Unsupported primary key type for index: " + dct);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.TYPE_NOT_SUPPORTED, "Unrecognized defined column type: " + dct);
    }

    public static boolean typeCompatible(ColumnType type, Type targetType) {
        switch (type) {
            case STRING: {
                return VarcharType.VARCHAR.equals((Object)targetType);
            }
            case INTEGER: {
                return BigintType.BIGINT.equals((Object)targetType);
            }
            case BINARY: {
                return VarbinaryType.VARBINARY.equals((Object)targetType);
            }
            case BOOLEAN: {
                return BooleanType.BOOLEAN.equals((Object)targetType);
            }
            case DOUBLE: {
                return DoubleType.DOUBLE.equals((Object)targetType);
            }
        }
        return false;
    }

    public static boolean typeSupported(Type type) {
        return BooleanType.BOOLEAN.equals((Object)type) || DoubleType.DOUBLE.equals((Object)type) || BigintType.BIGINT.equals((Object)type) || VarcharType.VARCHAR.equals((Object)type) || VarbinaryType.VARBINARY.equals((Object)type);
    }

    public static Type toPrestoType(PrimaryKeyType type) {
        switch (type) {
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case INTEGER: {
                return BigintType.BIGINT;
            }
            case BINARY: {
                return VarbinaryType.VARBINARY;
            }
        }
        throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.TYPE_NOT_SUPPORTED, "Primary key type not supported: " + type);
    }

    public static PrimaryKeyValue toPrimaryKeyValue(Type type, Object value) {
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return PrimaryKeyValue.fromString((String)((Slice)value).toStringUtf8());
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return PrimaryKeyValue.fromBinary((byte[])((Slice)value).getBytes());
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return PrimaryKeyValue.fromLong((long)((Long)value));
        }
        throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.TYPE_NOT_SUPPORTED, "Unrecognized primary key type: " + type.getDisplayName());
    }

    public static ColumnValue toColumnValue(Type type, Object value) {
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return ColumnValue.fromString((String)((Slice)value).toStringUtf8());
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return ColumnValue.fromBinary((byte[])((Slice)value).getBytes());
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return ColumnValue.fromLong((long)((Long)value));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return ColumnValue.fromDouble((double)((Double)value));
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return ColumnValue.fromBoolean((boolean)((Boolean)value));
        }
        throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.TYPE_NOT_SUPPORTED, "Unrecognized column type: " + type.getDisplayName());
    }

    public static PrimaryKeyValue toPrimaryKeyValue(Type type, Block block, int position) {
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return PrimaryKeyValue.fromString((String)type.getSlice(block, position).toStringUtf8());
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return PrimaryKeyValue.fromBinary((byte[])type.getSlice(block, position).getBytes());
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return PrimaryKeyValue.fromLong((long)type.getLong(block, position));
        }
        throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.TYPE_NOT_SUPPORTED, "Unrecognized primary key type: " + type.getDisplayName());
    }

    public static ColumnValue toColumnValue(Type type, Block block, int position) {
        if (VarcharType.VARCHAR.equals((Object)type)) {
            return ColumnValue.fromString((String)type.getSlice(block, position).toStringUtf8());
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return ColumnValue.fromBinary((byte[])type.getSlice(block, position).getBytes());
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return ColumnValue.fromLong((long)type.getLong(block, position));
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return ColumnValue.fromBoolean((boolean)type.getBoolean(block, position));
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return ColumnValue.fromDouble((double)type.getDouble(block, position));
        }
        throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.TYPE_NOT_SUPPORTED, "Unrecognized column type: " + type.getDisplayName());
    }

    public static ColumnValueFilter toSingleColumnValueFilter(String name, Domain domain) {
        if (domain.isAll() || domain.isNone() || domain.isOnlyNull()) {
            log.info("Domain is all or none or only null.");
            return null;
        }
        log.info("Range count of domain is %d", new Object[]{domain.getValues().getRanges().getRangeCount()});
        ArrayList<SingleColumnValueFilter> filters = new ArrayList<SingleColumnValueFilter>(domain.getValues().getRanges().getRangeCount());
        for (Range range : domain.getValues().getRanges().getOrderedRanges()) {
            SingleColumnValueFilter.CompareOperator op;
            ColumnValue cv;
            if (range.isAll()) {
                log.info("Domain range is all.");
                continue;
            }
            if (range.isSingleValue()) {
                cv = TypeUtil.toColumnValue(domain.getType(), range.getSingleValue());
                filters.add(new SingleColumnValueFilter(name, SingleColumnValueFilter.CompareOperator.EQUAL, cv));
                log.info("Filter: %s %s %s.", new Object[]{name, "EQUAL", cv});
                continue;
            }
            log.info("Domain is a range.");
            if (!range.getLow().isLowerUnbounded()) {
                cv = TypeUtil.toColumnValue(domain.getType(), range.getLow().getValue());
                op = range.getLow().getBound() == Marker.Bound.EXACTLY ? SingleColumnValueFilter.CompareOperator.GREATER_EQUAL : SingleColumnValueFilter.CompareOperator.GREATER_THAN;
                filters.add(new SingleColumnValueFilter(name, op, cv));
                log.info("Filter: %s %s %s.", new Object[]{name, op, cv});
            }
            if (range.getHigh().isUpperUnbounded()) continue;
            cv = TypeUtil.toColumnValue(domain.getType(), range.getHigh().getValue());
            op = range.getHigh().getBound() == Marker.Bound.EXACTLY ? SingleColumnValueFilter.CompareOperator.LESS_EQUAL : SingleColumnValueFilter.CompareOperator.LESS_THAN;
            filters.add(new SingleColumnValueFilter(name, op, cv));
            log.info("Filter: %s %s %s.", new Object[]{name, op, cv});
        }
        if (filters.isEmpty()) {
            return null;
        }
        if (filters.size() == 1) {
            return (ColumnValueFilter)filters.get(0);
        }
        CompositeColumnValueFilter ccvFilter = new CompositeColumnValueFilter(CompositeColumnValueFilter.LogicOperator.OR);
        filters.forEach(f -> ccvFilter.addFilter((ColumnValueFilter)f));
        return ccvFilter;
    }
}

