/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore.util;

import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.tablestore.model.TablestoreAccount;
import com.facebook.presto.tablestore.model.TablestoreSchema;
import com.facebook.presto.tablestore.model.TablestoreTable;
import com.facebook.presto.tablestore.util.TablestoreTableSerde;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.io.UncheckedIOException;

public class OTSRowSerde {
    public static final String PK_TYPE_COLUMN = "type";
    public static final PrimaryKeySchema TYPE_PK = new PrimaryKeySchema("type", PrimaryKeyType.STRING);
    public static final String PK_NAME_COLUMN = "name";
    public static final PrimaryKeySchema NAME_PK = new PrimaryKeySchema("name", PrimaryKeyType.STRING);
    public static final String SCHEMA_TYPE = "schema";
    public static final String TABLE_TYPE = "table";
    public static final String SCHEMA_NAME_COLUMN = "schema";
    public static final String ORIGIN_NAME_COLUMN = "origin_name";
    public static final String TABLE_META_COLUMN = "table_meta";

    private OTSRowSerde() {
    }

    public static RowPutChange schemaToRow(String metaTable, TablestoreSchema schema) {
        PrimaryKey primaryKey = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn(PK_TYPE_COLUMN, PrimaryKeyValue.fromString((String)"schema")).addPrimaryKeyColumn(PK_NAME_COLUMN, PrimaryKeyValue.fromString((String)schema.getSchemaName())).build();
        RowPutChange row = new RowPutChange(metaTable, primaryKey);
        row.addColumn("instance_name", ColumnValue.fromString((String)schema.getInstanceName()));
        row.addColumn("access_id", ColumnValue.fromString((String)schema.getAccount().getAccessId()));
        row.addColumn("access_key", ColumnValue.fromString((String)schema.getAccount().getAccessKey()));
        row.addColumn("endpoint", ColumnValue.fromString((String)schema.getEndpoint()));
        if (!Strings.isNullOrEmpty((String)schema.getAccount().getToken())) {
            row.addColumn("sts_token", ColumnValue.fromString((String)schema.getAccount().getToken()));
        }
        return row;
    }

    public static RowDeleteChange schemaToDelete(String metaTable, String schemaName) {
        PrimaryKey primaryKey = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn(PK_TYPE_COLUMN, PrimaryKeyValue.fromString((String)"schema")).addPrimaryKeyColumn(PK_NAME_COLUMN, PrimaryKeyValue.fromString((String)schemaName)).build();
        RowDeleteChange rowChange = new RowDeleteChange(metaTable, primaryKey);
        return rowChange;
    }

    public static TablestoreSchema toSchemaFromRow(Row row) {
        String schemaName = row.getPrimaryKey().getPrimaryKeyColumn(PK_NAME_COLUMN).getValue().asString();
        String instanceName = row.getLatestColumn("instance_name").getValue().asString();
        String accessId = row.getLatestColumn("access_id").getValue().asString();
        String accessKey = row.getLatestColumn("access_key").getValue().asString();
        String endpoint = row.getLatestColumn("endpoint").getValue().asString();
        Column tokenColumn = row.getLatestColumn("sts_token");
        String token = tokenColumn == null ? null : tokenColumn.getValue().asString();
        return new TablestoreSchema(schemaName, instanceName, endpoint, new TablestoreAccount(accessId, accessKey, token));
    }

    public static TablestoreTable toTableFromRow(Row row, TablestoreTableSerde.Deserializer tableDeser) {
        String tableMetaJson = row.getLatestColumn(TABLE_META_COLUMN).getValue().asString();
        return OTSRowSerde.fromJson(tableMetaJson, tableDeser);
    }

    public static RowPutChange tableToRow(String metaTable, TablestoreSchema schema, TablestoreTable table) {
        PrimaryKey primaryKey = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn(PK_TYPE_COLUMN, PrimaryKeyValue.fromString((String)TABLE_TYPE)).addPrimaryKeyColumn(PK_NAME_COLUMN, PrimaryKeyValue.fromString((String)table.getTableName().toString())).build();
        RowPutChange row = new RowPutChange(metaTable, primaryKey);
        row.addColumn("schema", ColumnValue.fromString((String)schema.getSchemaName()));
        row.addColumn(ORIGIN_NAME_COLUMN, ColumnValue.fromString((String)table.getOriginName()));
        row.addColumn(TABLE_META_COLUMN, ColumnValue.fromString((String)OTSRowSerde.toJson(table)));
        return row;
    }

    public static RowDeleteChange tableToDelete(String metaTable, String schemaName, String tableName) {
        PrimaryKey primaryKey = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn(PK_TYPE_COLUMN, PrimaryKeyValue.fromString((String)TABLE_TYPE)).addPrimaryKeyColumn(PK_NAME_COLUMN, PrimaryKeyValue.fromString((String)new SchemaTableName(schemaName, tableName).toString())).build();
        RowDeleteChange rowChange = new RowDeleteChange(metaTable, primaryKey);
        return rowChange;
    }

    private static TablestoreTable fromJson(String json, TablestoreTableSerde.Deserializer tableDeser) {
        ObjectMapper om = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(TablestoreTable.class, (JsonDeserializer)tableDeser);
        om.registerModule((Module)module);
        try {
            return (TablestoreTable)om.readValue(json, TablestoreTable.class);
        }
        catch (JsonParseException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String toJson(TablestoreTable table) {
        ObjectMapper om = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(TablestoreTable.class, (JsonSerializer)new TablestoreTableSerde.Serializer());
        om.registerModule((Module)module);
        try {
            return om.writeValueAsString((Object)table);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedExecutionException((Throwable)e);
        }
    }
}

