/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore.util;

import com.alicloud.openservices.tablestore.model.DefinedColumnType;
import com.alicloud.openservices.tablestore.model.IndexMeta;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.tablestore.TablestoreColumnHandle;
import com.facebook.presto.tablestore.TablestoreErrorCode;
import com.facebook.presto.tablestore.model.TablestoreColumn;
import com.facebook.presto.tablestore.model.TablestoreTable;
import com.facebook.presto.tablestore.util.TypeUtil;
import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MetaUtil {
    private static final Logger log = Logger.get(MetaUtil.class);

    private MetaUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkMeta(TablestoreTable table, TableMeta tableMeta) {
        TablestoreColumn column;
        List<TablestoreColumn> columns = table.getColumns();
        List primaryKey = tableMeta.getPrimaryKeyList();
        if (columns.size() < primaryKey.size()) {
            throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.META_CHECK_FAILED, "Table must contain all the primary key columns.");
        }
        int i = 0;
        for (PrimaryKeySchema key : primaryKey) {
            column = columns.get(i);
            if (Strings.isNullOrEmpty((String)column.getOriginName())) {
                if (!key.getName().equalsIgnoreCase(column.getName())) throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.META_CHECK_FAILED, String.format("The name of primary key should be [%s], but found [%s].", key.getName(), column.getName()));
                column.setOriginName(key.getName());
            } else if (!key.getName().equals(column.getOriginName())) {
                throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.META_CHECK_FAILED, String.format("The name of primary key should be [%s], but found [%s].", key.getName(), column.getOriginName()));
            }
            if (!TypeUtil.typeCompatible(key.getType(), column.getMetadata().getType())) {
                throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.META_CHECK_FAILED, String.format("Type of primary key column [%s] is '%s', not compatible with [%s].", key.getName(), key.getType(), column.getMetadata().getType()));
            }
            column.markAsPrimaryKey(true, i);
            ++i;
        }
        Map definedColumn = tableMeta.getDefinedColumnMap();
        for (int j = i; j < columns.size(); ++j) {
            column = columns.get(j);
            if (Strings.isNullOrEmpty((String)column.getOriginName())) {
                column.setOriginName(column.getName());
            }
            if (!TypeUtil.typeSupported(column.getMetadata().getType())) {
                throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.META_CHECK_FAILED, String.format("Type [%s] is not supported in Tablestore.", column.getMetadata().getType()));
            }
            if (!definedColumn.containsKey(column.getOriginName()) || TypeUtil.typeCompatible(TypeUtil.toColumnType((DefinedColumnType)definedColumn.get(column.getOriginName())), column.getMetadata().getType())) continue;
            throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.META_CHECK_FAILED, String.format("Type [%s] of column [%s] not compatible with [%s] as type is predefined.", column.getMetadata().getType(), column.getName(), definedColumn.get(column.getOriginName())));
        }
    }

    public static List<PrimaryKeySchema> getIndexTableSchema(TableMeta tableMeta, IndexMeta indexMeta) {
        LinkedHashMap<String, PrimaryKeySchema> pkSchemas = new LinkedHashMap<String, PrimaryKeySchema>();
        for (String name : indexMeta.getPrimaryKeyList()) {
            PrimaryKeyType type = (PrimaryKeyType)tableMeta.getPrimaryKeyMap().get(name);
            if (type == null) {
                type = TypeUtil.toPrimaryKeyType((DefinedColumnType)tableMeta.getDefinedColumnMap().get(name));
            }
            pkSchemas.put(name, new PrimaryKeySchema(name, type));
        }
        for (PrimaryKeySchema pk : tableMeta.getPrimaryKeyList()) {
            if (pkSchemas.containsKey(pk.getName())) continue;
            pkSchemas.put(pk.getName(), pk);
        }
        return pkSchemas.entrySet().stream().map(entry -> (PrimaryKeySchema)entry.getValue()).collect(Collectors.toList());
    }

    public static boolean suitableForIndex(Set<ColumnHandle> desiredColumns, TableMeta tableMeta, IndexMeta indexMeta) {
        HashSet columnsInIndex = new HashSet(indexMeta.getPrimaryKeyList());
        columnsInIndex.addAll(indexMeta.getDefinedColumnsList());
        log.info("Check index [%s] suitable: [%s].", new Object[]{indexMeta.getIndexName(), columnsInIndex});
        for (ColumnHandle column : desiredColumns) {
            String name = ((TablestoreColumnHandle)column).getOriginColumnName();
            if (columnsInIndex.contains(name) || tableMeta.getPrimaryKeySchemaMap().containsKey(name)) continue;
            log.info("Column not found [%s].", new Object[]{name});
            return false;
        }
        return true;
    }
}

