/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore.util;

public class Base64 {
    private static final char[] encodeMap = Base64.initEncodeMap();
    private static final byte[] decodeMap = Base64.initDecodeMap();
    private static final byte PADDING = 127;

    private Base64() {
    }

    private static char[] initEncodeMap() {
        int i;
        char[] map = new char[64];
        for (i = 0; i < 26; ++i) {
            map[i] = (char)(65 + i);
        }
        for (i = 26; i < 52; ++i) {
            map[i] = (char)(97 + (i - 26));
        }
        for (i = 52; i < 62; ++i) {
            map[i] = (char)(48 + (i - 52));
        }
        map[62] = 43;
        map[63] = 47;
        return map;
    }

    private static byte[] initDecodeMap() {
        int i;
        byte[] map = new byte[128];
        for (i = 0; i < 128; ++i) {
            map[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            map[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            map[i] = (byte)(i - 97 + 26);
        }
        for (i = 48; i <= 57; ++i) {
            map[i] = (byte)(i - 48 + 52);
        }
        map[43] = 62;
        map[47] = 63;
        map[61] = 127;
        return map;
    }

    public static char encode(int i) {
        return encodeMap[i & 0x3F];
    }

    public static int _printBase64Binary(byte[] input, int offset, int len, char[] buf, int ptr) {
        block4: for (int i = offset; i < len; i += 3) {
            switch (len - i) {
                case 1: {
                    buf[ptr++] = Base64.encode(input[i] >> 2);
                    buf[ptr++] = Base64.encode((input[i] & 3) << 4);
                    buf[ptr++] = 61;
                    buf[ptr++] = 61;
                    continue block4;
                }
                case 2: {
                    buf[ptr++] = Base64.encode(input[i] >> 2);
                    buf[ptr++] = Base64.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
                    buf[ptr++] = Base64.encode((input[i + 1] & 0xF) << 2);
                    buf[ptr++] = 61;
                    continue block4;
                }
                default: {
                    buf[ptr++] = Base64.encode(input[i] >> 2);
                    buf[ptr++] = Base64.encode((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
                    buf[ptr++] = Base64.encode((input[i + 1] & 0xF) << 2 | input[i + 2] >> 6 & 3);
                    buf[ptr++] = Base64.encode(input[i + 2] & 0x3F);
                }
            }
        }
        return ptr;
    }

    public static String toBase64String(byte[] input, int offset, int len) {
        char[] buf = new char[(len + 2) / 3 * 4];
        int ptr = Base64._printBase64Binary(input, offset, len, buf, 0);
        assert (ptr == buf.length);
        return new String(buf);
    }

    public static String toBase64String(byte[] binaryData) {
        return Base64.toBase64String(binaryData, 0, binaryData.length);
    }

    private static int guessLength(String text) {
        int padSize;
        int j;
        int len = text.length();
        for (j = len - 1; j >= 0; --j) {
            byte code = decodeMap[text.charAt(j)];
            if (code == 127) continue;
            if (code != -1) break;
            return text.length() / 4 * 3;
        }
        if ((padSize = len - ++j) > 2) {
            return text.length() / 4 * 3;
        }
        return text.length() / 4 * 3 - padSize;
    }

    public static byte[] fromBase64String(String text) {
        int buflen = Base64.guessLength(text);
        byte[] out = new byte[buflen];
        int o = 0;
        int len = text.length();
        byte[] quadruplet = new byte[4];
        int q = 0;
        for (int i = 0; i < len; ++i) {
            char ch = text.charAt(i);
            byte v = decodeMap[ch];
            if (v != -1) {
                quadruplet[q++] = v;
            }
            if (q != 4) continue;
            out[o++] = (byte)(quadruplet[0] << 2 | quadruplet[1] >> 4);
            if (quadruplet[2] != 127) {
                out[o++] = (byte)(quadruplet[1] << 4 | quadruplet[2] >> 2);
            }
            if (quadruplet[3] != 127) {
                out[o++] = (byte)(quadruplet[2] << 6 | quadruplet[3]);
            }
            q = 0;
        }
        if (buflen == o) {
            return out;
        }
        byte[] nb = new byte[o];
        System.arraycopy(out, 0, nb, 0, o);
        return nb;
    }
}

