/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore.schema.otsstore;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.ComputeSplitsBySizeRequest;
import com.alicloud.openservices.tablestore.model.ComputeSplitsBySizeResponse;
import com.alicloud.openservices.tablestore.model.Condition;
import com.alicloud.openservices.tablestore.model.CreateTableRequest;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.RangeIteratorParameter;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowExistenceExpectation;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.model.Split;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.alicloud.openservices.tablestore.model.TableOptions;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.tablestore.TablestoreConfig;
import com.facebook.presto.tablestore.TablestoreErrorCode;
import com.facebook.presto.tablestore.model.TablestoreAccount;
import com.facebook.presto.tablestore.model.TablestoreColumn;
import com.facebook.presto.tablestore.model.TablestoreSchema;
import com.facebook.presto.tablestore.model.TablestoreTable;
import com.facebook.presto.tablestore.model.TablestoreTableMeta;
import com.facebook.presto.tablestore.model.TablestoreTableState;
import com.facebook.presto.tablestore.schema.IMetaStore;
import com.facebook.presto.tablestore.schema.TablestoreColumnProperties;
import com.facebook.presto.tablestore.schema.TablestoreTableProperties;
import com.facebook.presto.tablestore.util.MetaUtil;
import com.facebook.presto.tablestore.util.OTSRowSerde;
import com.facebook.presto.tablestore.util.TablestoreTableSerde;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class OTSMetaStore
implements IMetaStore {
    private static final Logger log = Logger.get(OTSMetaStore.class);
    private final TablestoreConfig config;
    private final SyncClient client;
    private final String metaTable;
    private final TablestoreTableSerde.Deserializer tableDeser;
    private final ConcurrentHashMap<String, TablestoreSchema> schemas;
    private final ConcurrentHashMap<SchemaTableName, TablestoreTable> tables;
    private final Cache<SchemaTableName, TablestoreTableState> tableStates;
    private final Cache<SchemaTableName, List<Split>> tableSplitsCache;
    private final Map<String, SyncClient> clients;

    public OTSMetaStore(TablestoreConfig config, TablestoreTableSerde.Deserializer tableDeser) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)config.getMetaInstance()) ? 1 : 0) != 0, (Object)"The meta instance is null or is empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)config.getMetaInstanceAccessId()) ? 1 : 0) != 0, (Object)"The access id of meta instance is null or is empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)config.getMetaInstanceAccessKey()) ? 1 : 0) != 0, (Object)"The access key of meta instance is null or is empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)config.getMetaInstanceEndpoint()) ? 1 : 0) != 0, (Object)"The endpoint of meta instance is null or is empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)config.getMetaTable()) ? 1 : 0) != 0, (Object)"The meta table is null or is empty");
        this.config = config;
        this.tableDeser = tableDeser;
        this.client = new SyncClient(config.getMetaInstanceEndpoint(), config.getMetaInstanceAccessId(), config.getMetaInstanceAccessKey(), config.getMetaInstance());
        this.metaTable = config.getMetaTable();
        this.schemas = new ConcurrentHashMap();
        this.tables = new ConcurrentHashMap();
        this.clients = new ConcurrentHashMap<String, SyncClient>();
        this.tableStates = CacheBuilder.newBuilder().expireAfterWrite(config.getTableMetaCacheDurationInSeconds(), TimeUnit.SECONDS).maximumSize((long)config.getTableMetaCacheMaximumSize()).build();
        this.tableSplitsCache = CacheBuilder.newBuilder().expireAfterWrite(config.getTableSplitsCacheDurationInSeconds(), TimeUnit.SECONDS).maximumSize((long)config.getTableSplitsCacheMaximumSize()).build();
        this.initialize();
    }

    private void initialize() {
        this.prepareTable();
        this.loadMeta();
        this.checkMeta();
    }

    private void prepareTable() {
        boolean tableExists = false;
        TableMeta tableMeta = null;
        DescribeTableRequest request = new DescribeTableRequest();
        request.setTableName(this.metaTable);
        try {
            DescribeTableResponse response = this.client.describeTable(request);
            tableMeta = response.getTableMeta();
            tableExists = true;
        }
        catch (TableStoreException e) {
            if (e.getErrorCode().equalsIgnoreCase("OTSObjectNotExist")) {
                log.info("Meta table [%s] not exist, will create it automatically.", new Object[]{this.metaTable});
            }
            throw e;
        }
        if (!tableExists) {
            if (!this.config.isAutoCreateMetaTable()) {
                throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.INVALID_CONFIG, "Meta table not exists.");
            }
            log.info("Create meta table [%s]", new Object[]{this.metaTable});
            tableMeta = new TableMeta(this.metaTable);
            tableMeta.addPrimaryKeyColumn(OTSRowSerde.TYPE_PK);
            tableMeta.addPrimaryKeyColumn(OTSRowSerde.NAME_PK);
            TableOptions options = new TableOptions();
            options.setMaxVersions(1);
            options.setTimeToLive(-1);
            CreateTableRequest ctr = new CreateTableRequest(tableMeta, options);
            this.client.createTable(ctr);
            log.info("Meta table [%s] created.", new Object[]{this.metaTable});
        } else {
            log.info("Meta of meta table: [%s].", new Object[]{tableMeta});
            if (tableMeta.getPrimaryKeyList().size() != 2 || !((PrimaryKeySchema)tableMeta.getPrimaryKeyList().get(0)).equals((Object)OTSRowSerde.TYPE_PK) || !((PrimaryKeySchema)tableMeta.getPrimaryKeyList().get(1)).equals((Object)OTSRowSerde.NAME_PK)) {
                throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.INVALID_CONFIG, "The meta table can not be used.");
            }
        }
    }

    private void loadMeta() {
        PrimaryKey startKey = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn(OTSRowSerde.TYPE_PK.getName(), PrimaryKeyValue.INF_MIN).addPrimaryKeyColumn(OTSRowSerde.NAME_PK.getName(), PrimaryKeyValue.INF_MIN).build();
        PrimaryKey endKey = PrimaryKeyBuilder.createPrimaryKeyBuilder().addPrimaryKeyColumn(OTSRowSerde.TYPE_PK.getName(), PrimaryKeyValue.INF_MAX).addPrimaryKeyColumn(OTSRowSerde.NAME_PK.getName(), PrimaryKeyValue.INF_MAX).build();
        RangeIteratorParameter param = new RangeIteratorParameter(this.metaTable);
        param.setInclusiveStartPrimaryKey(startKey);
        param.setExclusiveEndPrimaryKey(endKey);
        param.setMaxVersions(1);
        Iterator iter = this.client.createRangeIterator(param);
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            String type = row.getPrimaryKey().getPrimaryKeyColumn("type").getValue().asString();
            if (type.equalsIgnoreCase("schema")) {
                TablestoreSchema schema = OTSRowSerde.toSchemaFromRow(row);
                log.info("Add schema [%s].", new Object[]{schema.getSchemaName()});
                this.schemas.put(schema.getSchemaName(), schema);
                continue;
            }
            if (type.equalsIgnoreCase("table")) {
                TablestoreTable table = OTSRowSerde.toTableFromRow(row, this.tableDeser);
                log.info("Add table [%s].", new Object[]{table.getTableName()});
                this.tables.put(table.getTableName(), table);
                continue;
            }
            log.error("Unrecognized type [%s].", new Object[]{type});
        }
    }

    private void checkMeta() {
        ArrayList<SchemaTableName> allTables = new ArrayList<SchemaTableName>();
        Enumeration<SchemaTableName> tEnum = this.tables.keys();
        while (tEnum.hasMoreElements()) {
            allTables.add(tEnum.nextElement());
        }
        for (SchemaTableName st : allTables) {
            TablestoreSchema schema = this.schemas.get(st.getSchemaName());
            if (schema == null) {
                log.warn("Schema [%s] not found but table [%s] exists.", new Object[]{st.getSchemaName(), st.getTableName()});
                continue;
            }
            TablestoreTable table = this.tables.get(st);
            TablestoreTableState state = this.getAndCheckTableState(schema, table);
            this.tableStates.put((Object)table.getTableName(), (Object)state);
        }
    }

    @Override
    public List<String> listSchema() {
        return ImmutableList.copyOf((Collection)this.schemas.keySet());
    }

    @Override
    public TablestoreTable getTable(String schemaName, String tableName) {
        SchemaTableName schemaTable = new SchemaTableName(schemaName, tableName);
        TablestoreTable table = this.tables.get(schemaTable);
        if (table == null) {
            log.warn("Table [%s.%s] is not exist.", new Object[]{schemaName, tableName});
            return null;
        }
        return table;
    }

    @Override
    public TablestoreTableMeta describeTable(String schemaName, String tableName) {
        TablestoreSchema schema = this.getSchema(schemaName);
        SchemaTableName schemaTable = new SchemaTableName(schemaName, tableName);
        TablestoreTable table = this.tables.get(schemaTable);
        if (table == null) {
            log.warn("Table [%s.%s] is not exist.", new Object[]{schemaName, tableName});
            throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.INVALID_STATE, "Table is not exist.");
        }
        TablestoreTableState state = this.checkTableState(schema, table);
        return state.getTableMeta();
    }

    private TablestoreTableState checkTableState(TablestoreSchema schema, TablestoreTable table) {
        TablestoreTableState tableState;
        try {
            tableState = (TablestoreTableState)this.tableStates.get((Object)table.getTableName(), () -> this.getAndCheckTableState(schema, table));
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException((Throwable)e);
        }
        if (tableState == null) {
            log.error("Can not validate table state.");
            throw new IllegalStateException("Can not validate table state.");
        }
        if (tableState.isStateInvalid()) {
            log.error("Invalid table state: %s", new Object[]{tableState.getInvalidReason()});
            throw new IllegalArgumentException(tableState.getInvalidReason());
        }
        return tableState;
    }

    private TablestoreTableState getAndCheckTableState(TablestoreSchema schema, TablestoreTable table) {
        DescribeTableResponse tableMeta;
        log.info("Check table [%s] meta in instance [%s].", new Object[]{table.getTableName(), schema.getInstanceName()});
        try {
            tableMeta = this.refreshTableMeta(schema, table);
        }
        catch (TableStoreException e) {
            if (e.getErrorCode().equalsIgnoreCase("OTSObjectNotExist")) {
                return TablestoreTableState.tableNotExist(table, "Table not exists in tablestore.");
            }
            if (e.getErrorCode().equalsIgnoreCase("OTSAuthFailed")) {
                return TablestoreTableState.authFailed(table, e.getMessage());
            }
            throw e;
        }
        try {
            MetaUtil.checkMeta(table, tableMeta.getTableMeta());
        }
        catch (PrestoException e) {
            return TablestoreTableState.metaCheckFailed(table, e.getMessage());
        }
        return TablestoreTableState.checkPassed(table, new TablestoreTableMeta(tableMeta.getTableMeta(), tableMeta.getIndexMeta()));
    }

    private DescribeTableResponse refreshTableMeta(TablestoreSchema schema, TablestoreTable table) {
        log.info("refresh table meta: %s", new Object[]{table.getOriginName()});
        DescribeTableRequest request = new DescribeTableRequest();
        request.setTableName(table.getOriginName());
        SyncClient c = this.getClientInternal(schema);
        DescribeTableResponse response = c.describeTable(request);
        return response;
    }

    @Override
    public List<String> listTable(String schema) {
        return ImmutableList.copyOf((Collection)Collections2.transform((Collection)this.tables.entrySet().stream().filter(entry -> ((SchemaTableName)entry.getKey()).getSchemaName().equalsIgnoreCase(schema)).collect(Collectors.toList()), entry -> ((SchemaTableName)entry.getKey()).getTableName()));
    }

    @Override
    public List<Split> getTableSplits(String schema, String tableName) {
        log.info("Get table [%s.%s]'s splits", new Object[]{schema, tableName});
        this.getSchema(schema);
        try {
            return (List)this.tableSplitsCache.get((Object)new SchemaTableName(schema, tableName), () -> this.computeSplits(schema, tableName));
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException((Throwable)e);
        }
    }

    public List<Split> computeSplits(String schema, String tableName) {
        log.info("Compute splits for table [%s] in schema [%s].", new Object[]{tableName, schema});
        SyncClient c = this.getClientInternal(this.getSchema(schema));
        ComputeSplitsBySizeRequest request = new ComputeSplitsBySizeRequest();
        request.setTableName(tableName);
        request.setSplitPointLimit(this.config.getMaxSplits());
        request.setSplitSizeInByte((long)this.config.getSplitSizeInMB(), 0x100000L);
        ComputeSplitsBySizeResponse response = c.computeSplitsBySize(request);
        return response.getSplits();
    }

    @Override
    public SyncClient getClient(String schema) {
        return this.getClientInternal(this.getSchema(schema));
    }

    @Override
    public void createSchema(TablestoreSchema schema) {
        block2: {
            log.info("Create schema [%s] of instance [%s].", new Object[]{schema.getSchemaName(), schema.getInstanceName()});
            RowPutChange row = OTSRowSerde.schemaToRow(this.metaTable, schema);
            row.setCondition(new Condition(RowExistenceExpectation.EXPECT_NOT_EXIST));
            PutRowRequest request = new PutRowRequest();
            request.setRowChange(row);
            try {
                this.client.putRow(request);
            }
            catch (TableStoreException e) {
                if (!e.getErrorCode().equalsIgnoreCase("OTSConditionCheckFail")) break block2;
                log.error("Row already exists in table while creating schema [" + schema + "].");
                throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.INVALID_STATE, (Throwable)e);
            }
        }
        this.schemas.put(schema.getSchemaName(), schema);
    }

    @Override
    public void dropSchema(String schemaName) {
        log.info("Dropping schema [%s].", new Object[]{schemaName});
        RowDeleteChange rowChange = OTSRowSerde.schemaToDelete(this.metaTable, schemaName);
        DeleteRowRequest request = new DeleteRowRequest();
        request.setRowChange(rowChange);
        try {
            this.client.deleteRow(request);
        }
        catch (TableStoreException e) {
            log.error("Exception occurred while dropping schema.", new Object[]{e});
            throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.REQUEST_FAILED, (Throwable)e);
        }
        this.schemas.remove(schemaName);
        this.deleteClient(schemaName);
    }

    @Override
    public void createTable(ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        log.info("Create table [%s] while ignore existing is %s.", new Object[]{tableMetadata.getTable(), ignoreExisting});
        TablestoreSchema schema = this.schemas.get(tableMetadata.getTable().getSchemaName());
        if (schema == null) {
            log.error("Create table [%s] while schema [%s] is not exist.", new Object[]{tableMetadata.getTable().getTableName(), tableMetadata.getTable().getSchemaName()});
            throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.INVALID_STATE, "Schema is not exist while creating table.");
        }
        if (ignoreExisting && this.tables.containsKey(tableMetadata.getTable())) {
            log.info("Ignore creating as table [%s] already exists.", new Object[]{tableMetadata.getTable()});
            return;
        }
        TablestoreTable table = this.toTable(tableMetadata);
        TablestoreTableState state = this.getAndCheckTableState(schema, table);
        this.tableStates.put((Object)table.getTableName(), (Object)state);
        this.storeTable(schema, table);
        this.tables.put(tableMetadata.getTable(), table);
    }

    @Override
    public void dropTable(String schemaName, String tableName) {
        log.info("Dropping table [%s.%s].", new Object[]{schemaName, tableName});
        RowDeleteChange rowChange = OTSRowSerde.tableToDelete(this.metaTable, schemaName, tableName);
        DeleteRowRequest request = new DeleteRowRequest();
        request.setRowChange(rowChange);
        try {
            this.client.deleteRow(request);
        }
        catch (TableStoreException e) {
            log.error("Exception occurred while dropping table.", new Object[]{e});
            throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.REQUEST_FAILED, (Throwable)e);
        }
        this.tables.remove(new SchemaTableName(schemaName, tableName));
    }

    private void storeTable(TablestoreSchema schema, TablestoreTable table) {
        block2: {
            log.info("Create external table [%s] of instance [%s].", new Object[]{schema.getSchemaName(), schema.getInstanceName()});
            RowPutChange row = OTSRowSerde.tableToRow(this.metaTable, schema, table);
            row.setCondition(new Condition(RowExistenceExpectation.EXPECT_NOT_EXIST));
            PutRowRequest request = new PutRowRequest();
            request.setRowChange(row);
            try {
                this.client.putRow(request);
            }
            catch (TableStoreException e) {
                if (!e.getErrorCode().equalsIgnoreCase("OTSConditionCheckFail")) break block2;
                log.error("Row already exists in table while creating schema [" + schema + "].");
                throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.INVALID_STATE, (Throwable)e);
            }
        }
    }

    private TablestoreTable toTable(ConnectorTableMetadata tableMetadata) {
        Optional<String> originTableName = TablestoreTableProperties.getTableName(tableMetadata.getProperties());
        ArrayList<TablestoreColumn> columns = new ArrayList<TablestoreColumn>();
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            Optional<String> originName = TablestoreColumnProperties.getOriginName(column.getProperties());
            columns.add(new TablestoreColumn(column.getName(), originName.isPresent() ? originName.get() : column.getName(), column));
        }
        TablestoreTable table = new TablestoreTable(tableMetadata.getTable(), originTableName.isPresent() ? originTableName.get() : tableMetadata.getTable().getTableName(), columns, tableMetadata.getComment(), tableMetadata.getProperties());
        return table;
    }

    private TablestoreSchema getSchema(String schemaName) {
        TablestoreSchema schema = this.schemas.get(schemaName);
        if (schema == null) {
            log.warn("Schema [%s] is not exist.", new Object[]{schemaName});
            throw new IllegalStateException("This schema is not exist.");
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteClient(String schema) {
        Map<String, SyncClient> map = this.clients;
        synchronized (map) {
            if (this.clients.containsKey(schema)) {
                this.clients.remove(schema);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyncClient getClientInternal(TablestoreSchema schema) {
        SyncClient client = this.clients.get(schema.getSchemaName());
        if (client != null) {
            return client;
        }
        Map<String, SyncClient> map = this.clients;
        synchronized (map) {
            client = this.clients.get(schema.getSchemaName());
            if (client != null) {
                return client;
            }
            TablestoreAccount account = schema.getAccount();
            if (Strings.isNullOrEmpty((String)account.getToken())) {
                log.info("Init tablestore client on schema[%s] with instance_name[%s], access_id[%s]", new Object[]{schema.getSchemaName(), schema.getInstanceName(), account.getAccessId()});
                client = new SyncClient(schema.getEndpoint(), account.getAccessId(), account.getAccessKey(), schema.getInstanceName(), this.config.getClientConfig());
            } else {
                log.info("Init tablestore client on schema[%s] with instance_name[%s], access_id[%s], token[%s]", new Object[]{schema.getSchemaName(), schema.getInstanceName(), account.getAccessId(), account.getToken()});
                client = new SyncClient(schema.getEndpoint(), account.getAccessId(), account.getAccessKey(), schema.getInstanceName(), this.config.getClientConfig(), account.getToken());
            }
            this.clients.put(schema.getSchemaName(), client);
            return client;
        }
    }
}

