/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore.schema.localstore;

import com.facebook.presto.tablestore.model.TablestoreAccount;
import com.facebook.presto.tablestore.schema.localstore.TablestoreInstanceJsonConf;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class TablestoreSchemaJsonConf {
    private final TablestoreAccount account;
    private final Map<String, TablestoreInstanceJsonConf> instances;

    @JsonCreator
    public TablestoreSchemaJsonConf(@JsonProperty(value="account") TablestoreAccount account, @JsonProperty(value="instances") Map<String, TablestoreInstanceJsonConf> instances) {
        Preconditions.checkArgument((!Objects.isNull(instances) ? 1 : 0) != 0, (Object)"instances is null");
        this.account = Objects.requireNonNull(account, "account is null");
        this.instances = ImmutableMap.copyOf((Iterable)Collections2.transform(instances.entrySet(), entry -> new AbstractMap.SimpleEntry(((String)entry.getKey()).toLowerCase(Locale.ENGLISH), entry.getValue())));
    }

    @JsonProperty
    public TablestoreAccount getAccount() {
        return this.account;
    }

    @JsonProperty
    public Map<String, TablestoreInstanceJsonConf> getInstances() {
        return this.instances;
    }

    public TablestoreInstanceJsonConf getInstance(String schema) {
        return this.instances.get(schema);
    }
}

