/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore.schema.localstore;

import com.facebook.presto.common.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;

public final class TablestoreColumnJsonConf {
    private final String name;
    private String originName;
    private final Type type;

    @JsonCreator
    public TablestoreColumnJsonConf(@JsonProperty(value="name") String name, @JsonProperty(value="originName") String originName, @JsonProperty(value="type") Type type) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.name = name;
        this.originName = originName;
        this.type = Objects.requireNonNull(type, "type is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public String getOriginName() {
        return this.originName;
    }

    public void setOriginName(String originName) {
        this.originName = originName;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.originName, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TablestoreColumnJsonConf other = (TablestoreColumnJsonConf)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.originName, other.originName) && Objects.equals(this.type, other.type);
    }

    public String toString() {
        return this.name + ":" + this.originName + ":" + this.type;
    }
}

