/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore.model;

import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.tablestore.model.TablestoreColumn;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class TablestoreTable {
    private SchemaTableName tableName;
    private String originName;
    private final List<TablestoreColumn> columns;
    private final Optional<String> comment;
    private final Map<String, Object> properties;

    public TablestoreTable(SchemaTableName tableName, String originName, List<TablestoreColumn> columns, Optional<String> comment, Map<String, Object> properties) {
        this.tableName = tableName;
        this.originName = originName;
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.comment = comment;
        this.properties = properties;
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    public void setTableName(SchemaTableName tableName) {
        this.tableName = tableName;
    }

    public void setOriginName(String originName) {
        this.originName = originName;
    }

    public String getOriginName() {
        return this.originName;
    }

    public List<TablestoreColumn> getColumns() {
        return this.columns;
    }

    public List<ColumnMetadata> getColumnsMetadata() {
        return ImmutableList.copyOf((Collection)this.columns.stream().map(entry -> entry.getMetadata()).collect(Collectors.toList()));
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

