/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore.model;

import com.facebook.presto.tablestore.model.TablestoreAccount;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;

public class TablestoreSchema {
    private final String schemaName;
    private final String instanceName;
    private final String endpoint;
    private final TablestoreAccount account;

    public TablestoreSchema(String schemaName, String instanceName, String endpoint, TablestoreAccount account) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)schemaName) ? 1 : 0) != 0, (Object)"schemaName is null or is empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceName) ? 1 : 0) != 0, (Object)"instanceName is null or is empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)endpoint) ? 1 : 0) != 0, (Object)"endpoint is null or is empty");
        Preconditions.checkArgument((!Objects.isNull(account) ? 1 : 0) != 0, (Object)"account is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schema name is null");
        this.instanceName = Objects.requireNonNull(instanceName, "instance name is null");
        this.endpoint = Objects.requireNonNull(endpoint, "endpoint is null");
        this.account = account;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public TablestoreAccount getAccount() {
        return this.account;
    }
}

