/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore.model;

import com.facebook.presto.spi.ColumnMetadata;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;

public final class TablestoreColumn {
    private final String name;
    private String originName;
    private final ColumnMetadata metadata;
    private boolean primaryKey;
    private int ordinalPosition;

    public TablestoreColumn(String name, String originName, ColumnMetadata metadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.name = name;
        this.originName = originName;
        this.metadata = metadata;
        this.primaryKey = false;
        this.ordinalPosition = -1;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginName() {
        return this.originName;
    }

    public void setOriginName(String originName) {
        this.originName = originName;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.originName, this.metadata.getType());
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void markAsPrimaryKey(boolean primaryKey, int ordinalPosition) {
        this.primaryKey = primaryKey;
        this.ordinalPosition = ordinalPosition;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public void setOrdinalPosition(int ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    public ColumnMetadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TablestoreColumn other = (TablestoreColumn)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.originName, other.originName) && Objects.equals(this.metadata.getType(), other.metadata.getType());
    }

    public String toString() {
        return this.name + ":" + this.originName + ":" + this.metadata.getType();
    }
}

