/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.tablestore.TablestoreClient;
import com.facebook.presto.tablestore.TablestoreColumnHandle;
import com.facebook.presto.tablestore.TablestoreConfig;
import com.facebook.presto.tablestore.TablestoreConnectorId;
import com.facebook.presto.tablestore.TablestoreRecordSet;
import com.facebook.presto.tablestore.TablestoreSplit;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class TablestoreRecordSetProvider
implements ConnectorRecordSetProvider {
    private final String connectorId;
    private final TablestoreConfig config;
    private final TablestoreClient client;

    @Inject
    public TablestoreRecordSetProvider(TablestoreConnectorId connectorId, TablestoreConfig config, TablestoreClient client) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.config = Objects.requireNonNull(config, "config is null");
        this.client = Objects.requireNonNull(client, "client is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        Objects.requireNonNull(split, "partitionChunk is null");
        TablestoreSplit tablestoreSplit = (TablestoreSplit)split;
        Preconditions.checkArgument((boolean)tablestoreSplit.getConnectorId().equals(this.connectorId), (Object)"split is not for this connector");
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            handles.add((Object)((TablestoreColumnHandle)columnHandle));
        }
        return new TablestoreRecordSet(this.config, this.client, tablestoreSplit, (List<TablestoreColumnHandle>)handles.build());
    }
}

