/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.alicloud.openservices.tablestore.model.filter.ColumnValueFilter;
import com.alicloud.openservices.tablestore.model.filter.CompositeColumnValueFilter;
import com.alicloud.openservices.tablestore.model.filter.Filter;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.tablestore.TablestoreBulkReadRecordCursor;
import com.facebook.presto.tablestore.TablestoreClient;
import com.facebook.presto.tablestore.TablestoreColumnHandle;
import com.facebook.presto.tablestore.TablestoreConfig;
import com.facebook.presto.tablestore.TablestoreRangeScanRecordCursor;
import com.facebook.presto.tablestore.TablestoreSingleGetRecordCursor;
import com.facebook.presto.tablestore.TablestoreSplit;
import com.facebook.presto.tablestore.util.TypeUtil;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TablestoreRecordSet
implements RecordSet {
    private static final Logger log = Logger.get(TablestoreRecordSet.class);
    private final TablestoreConfig config;
    private final TablestoreClient client;
    private final TablestoreSplit split;
    private final List<TablestoreColumnHandle> columnHandles;
    private final List<Type> columnTypes;

    public TablestoreRecordSet(TablestoreConfig config, TablestoreClient client, TablestoreSplit split, List<TablestoreColumnHandle> columnHandles) {
        this.config = Objects.requireNonNull(config, "config is null");
        this.client = Objects.requireNonNull(client, "client is null");
        this.split = Objects.requireNonNull(split, "split is null");
        this.columnHandles = columnHandles;
        ImmutableList.Builder types = ImmutableList.builder();
        for (TablestoreColumnHandle column : columnHandles) {
            types.add((Object)column.getColumnType());
        }
        this.columnTypes = types.build();
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    private Filter pushDownFilter(Map<String, Domain> filters) {
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        ArrayList cvFilters = new ArrayList();
        filters.forEach((k, v) -> {
            ColumnValueFilter filter = TypeUtil.toSingleColumnValueFilter(k, v);
            if (filter != null) {
                cvFilters.add(filter);
            }
        });
        if (cvFilters.isEmpty()) {
            return null;
        }
        if (cvFilters.size() == 1) {
            return (Filter)cvFilters.get(0);
        }
        CompositeColumnValueFilter cFilter = new CompositeColumnValueFilter(CompositeColumnValueFilter.LogicOperator.AND);
        for (int i = 0; i < cvFilters.size() && i < this.config.getMaxFiltersPushDown(); ++i) {
            cFilter.addFilter((ColumnValueFilter)cvFilters.get(i));
        }
        return cFilter;
    }

    public RecordCursor cursor() {
        log.info("Got %d filters is push down.", new Object[]{this.split.getFilters().size()});
        Filter filter = this.pushDownFilter(this.split.getFilters());
        if (this.split.getStartKey().getPrimaryKey().equals((Object)this.split.getEndKey().getPrimaryKey())) {
            log.info("Get single read cursor.");
            return new TablestoreSingleGetRecordCursor(this.client, this.split, this.columnHandles);
        }
        if (this.config.isEnableBulkRead()) {
            log.info("Get bulk read cursor.");
            return new TablestoreBulkReadRecordCursor(this.client, this.split, this.columnHandles, filter);
        }
        log.info("Get range scan cursor.");
        return new TablestoreRangeScanRecordCursor(this.client, this.split, this.columnHandles, filter);
    }
}

