/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.alicloud.openservices.tablestore.writer.WriterResult;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.tablestore.TablestoreAsyncPageSink;
import com.facebook.presto.tablestore.TablestoreColumnHandle;
import com.facebook.presto.tablestore.TablestoreErrorCode;
import com.facebook.presto.tablestore.TablestoreInsertTableHandle;
import com.facebook.presto.tablestore.util.TypeUtil;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public class TablestorePageSink
implements ConnectorPageSink {
    private static final Logger log = Logger.get(TablestorePageSink.class);
    private final TablestoreInsertTableHandle table;
    private final TablestoreAsyncPageSink asyncSink;
    private final TablestoreColumnHandle[] columns;
    private final List<Future<WriterResult>> writerResults;

    public TablestorePageSink(TablestoreInsertTableHandle table, TablestoreAsyncPageSink asyncSink) {
        this.table = table;
        this.asyncSink = asyncSink;
        this.columns = table.getColumns().toArray(new TablestoreColumnHandle[0]);
        this.writerResults = new ArrayList<Future<WriterResult>>();
    }

    public CompletableFuture<?> appendPage(Page page) {
        log.info("Append page, rows count: %d", new Object[]{page.getPositionCount()});
        ArrayList<RowChange> rows = new ArrayList<RowChange>(page.getPositionCount());
        for (int position = 0; position < page.getPositionCount(); ++position) {
            RowUpdateChange rowChange = new RowUpdateChange(this.asyncSink.getOriginTableName());
            PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                this.appendColumn(primaryKeyBuilder, rowChange, page, position, channel);
            }
            rowChange.setPrimaryKey(primaryKeyBuilder.build());
            rows.add((RowChange)rowChange);
        }
        return this.asyncSink.insertRows(rows, this.writerResults);
    }

    private void appendColumn(PrimaryKeyBuilder primaryKeyBuilder, RowUpdateChange rowChange, Page page, int position, int channel) {
        TablestoreColumnHandle column = this.columns[channel];
        Block block = page.getBlock(channel);
        if (column.isPrimaryKey()) {
            if (block.isNull(position)) {
                throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.DIRTY_ROWS_ERROR, "The primary key column is null.");
            }
            primaryKeyBuilder.addPrimaryKeyColumn(column.getOriginColumnName(), TypeUtil.toPrimaryKeyValue(column.getColumnType(), block, position));
        } else if (block.isNull(position)) {
            rowChange.deleteColumns(column.getOriginColumnName());
        } else {
            rowChange.put(column.getOriginColumnName(), TypeUtil.toColumnValue(column.getColumnType(), block, position));
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        CompletableFutureHandler futureHandler = new CompletableFutureHandler(this);
        this.asyncSink.flush(futureHandler);
        return futureHandler;
    }

    public void abort() {
    }

    public static class CompletableFutureHandler
    extends CompletableFuture<Collection<Slice>> {
        private TablestorePageSink pageSink;

        private CompletableFutureHandler(TablestorePageSink pageSink) {
            this.pageSink = pageSink;
        }

        public void completed() {
            long totalRowsCount = 0L;
            long totalSucceedCount = 0L;
            long totalFailedCount = 0L;
            try {
                for (Future result : this.pageSink.writerResults) {
                    totalRowsCount += (long)((WriterResult)result.get()).getTotalCount();
                    totalSucceedCount += (long)((WriterResult)result.get()).getSucceedRows().size();
                    totalFailedCount += (long)((WriterResult)result.get()).getFailedRows().size();
                    for (WriterResult.RowChangeStatus status : ((WriterResult)result.get()).getFailedRows()) {
                        log.info("Write row failed: %s", new Object[]{status.getException().toString()});
                    }
                }
            }
            catch (Exception e) {
                this.completeExceptionally(e);
            }
            if (totalFailedCount == 0L) {
                this.complete(Collections.emptyList());
            } else {
                this.completeExceptionally(new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.REQUEST_FAILED, String.format("Some rows failed to write into table, total count is %d, succeed count is %d, failed count is %d.", totalRowsCount, totalSucceedCount, totalFailedCount)));
            }
        }

        public void failed(Throwable exc) {
            this.completeExceptionally(exc);
        }
    }
}

