/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.tablestore.TablestoreClient;
import com.facebook.presto.tablestore.TablestoreConfig;
import com.facebook.presto.tablestore.TablestoreConnector;
import com.facebook.presto.tablestore.TablestoreConnectorId;
import com.facebook.presto.tablestore.TablestoreMetadata;
import com.facebook.presto.tablestore.TablestorePageSinkProvider;
import com.facebook.presto.tablestore.TablestoreRecordSetProvider;
import com.facebook.presto.tablestore.TablestoreSplitManager;
import com.facebook.presto.tablestore.schema.localstore.TablestoreSchemaJsonConf;
import com.facebook.presto.tablestore.util.TablestoreTableSerde;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.util.Objects;
import javax.inject.Inject;

public class TablestoreModule
implements Module {
    private final String connectorId;
    private final TypeManager typeManager;

    public TablestoreModule(String connectorId, TypeManager typeManager) {
        this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public void configure(Binder binder) {
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(TablestoreConnector.class).in(Scopes.SINGLETON);
        binder.bind(TablestoreConnectorId.class).toInstance((Object)new TablestoreConnectorId(this.connectorId));
        binder.bind(TablestoreMetadata.class).in(Scopes.SINGLETON);
        binder.bind(TablestoreClient.class).in(Scopes.SINGLETON);
        binder.bind(TablestoreSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(TablestoreRecordSetProvider.class).in(Scopes.SINGLETON);
        binder.bind(TablestorePageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(TablestoreTableSerde.Deserializer.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(TablestoreConfig.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TablestoreSchemaJsonConf.class);
    }

    public static final class TypeDeserializer
    extends FromStringDeserializer<Type> {
        private final TypeManager typeManager;

        @Inject
        public TypeDeserializer(TypeManager typeManager) {
            super(Type.class);
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        }

        protected Type _deserialize(String value, DeserializationContext context) {
            return this.typeManager.getType(TypeSignature.parseTypeSignature((String)value));
        }
    }
}

