/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.tablestore.TablestoreConnector;
import com.facebook.presto.tablestore.TablestoreHandleResolver;
import com.facebook.presto.tablestore.TablestoreModule;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import java.util.Objects;

public class TablestoreConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "tablestore";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new TablestoreHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> requiredConfig, ConnectorContext context) {
        Objects.requireNonNull(requiredConfig, "requiredConfig is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new TablestoreModule(catalogName, context.getTypeManager())});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).initialize();
            return (Connector)injector.getInstance(TablestoreConnector.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

