/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.tablestore.TablestoreMetadata;
import com.facebook.presto.tablestore.TablestorePageSinkProvider;
import com.facebook.presto.tablestore.TablestoreRecordSetProvider;
import com.facebook.presto.tablestore.TablestoreSplitManager;
import com.facebook.presto.tablestore.TablestoreTransactionHandle;
import com.facebook.presto.tablestore.schema.TablestoreColumnProperties;
import com.facebook.presto.tablestore.schema.TablestoreSchemaProperties;
import com.facebook.presto.tablestore.schema.TablestoreTableProperties;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class TablestoreConnector
implements Connector {
    private static final Logger log = Logger.get(TablestoreConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final TablestoreMetadata metadata;
    private final TablestoreSplitManager splitManager;
    private final TablestoreRecordSetProvider recordSetProvider;
    private final TablestorePageSinkProvider pageSinkProvider;
    private final List<PropertyMetadata<?>> schemaProperties;
    private final List<PropertyMetadata<?>> tableProperties;
    private final List<PropertyMetadata<?>> columnProperties;

    @Inject
    public TablestoreConnector(LifeCycleManager lifeCycleManager, TablestoreMetadata metadata, TablestoreSplitManager splitManager, TablestoreRecordSetProvider recordSetProvider, TablestorePageSinkProvider pageSinkProvider) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        this.schemaProperties = TablestoreSchemaProperties.SCHEMA_PROPERTIES;
        this.tableProperties = TablestoreTableProperties.TABLE_PROPERTIES;
        this.columnProperties = TablestoreColumnProperties.COLUMN_PROPERTIES;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        return TablestoreTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public List<PropertyMetadata<?>> getSchemaProperties() {
        return this.schemaProperties;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public List<PropertyMetadata<?>> getColumnProperties() {
        return this.columnProperties;
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

