/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.model.BulkExportRequest;
import com.alicloud.openservices.tablestore.model.BulkExportResponse;
import com.alicloud.openservices.tablestore.model.DataBlockType;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.SimpleRowMatrixBlockParser;
import com.alicloud.openservices.tablestore.model.filter.Filter;
import com.alicloud.openservices.tablestore.model.tunnel.BulkExportQueryCriteria;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.tablestore.TablestoreClient;
import com.facebook.presto.tablestore.TablestoreColumnHandle;
import com.facebook.presto.tablestore.TablestoreRecordCursor;
import com.facebook.presto.tablestore.TablestoreSplit;
import java.util.List;

public class TablestoreBulkReadRecordCursor
extends TablestoreRecordCursor {
    private static final Logger log = Logger.get(TablestoreBulkReadRecordCursor.class);
    private BulkExportResponse exportResult;
    private SimpleRowMatrixBlockParser rowReader;
    private Filter filter;

    public TablestoreBulkReadRecordCursor(TablestoreClient client, TablestoreSplit split, List<TablestoreColumnHandle> columnHandles, Filter filter) {
        super(client, split, columnHandles);
        this.filter = filter;
        log.info("Start bulk read record cursor, column's count is %d.", new Object[]{columnHandles.size()});
    }

    public boolean advanceNextPosition() {
        if (this.exportResult == null) {
            this.exportResult = this.bulkExport(this.split.getStartKey().getPrimaryKey(), this.split.getEndKey().getPrimaryKey());
            this.rowReader = new SimpleRowMatrixBlockParser(this.exportResult.getRows());
        }
        if (this.rowReader.hasNext()) {
            this.rowReader.next();
            this.currentRow = this.rowReader.getRow();
            return true;
        }
        if (this.exportResult.getNextStartPrimaryKey() != null) {
            this.exportResult = this.bulkExport(this.exportResult.getNextStartPrimaryKey(), this.split.getEndKey().getPrimaryKey());
            this.rowReader = new SimpleRowMatrixBlockParser(this.exportResult.getRows());
            return this.advanceNextPosition();
        }
        return false;
    }

    private BulkExportResponse bulkExport(PrimaryKey startKey, PrimaryKey endKey) {
        SyncClient sc = this.client.getClient(this.split.getSchemaName());
        BulkExportRequest request = new BulkExportRequest();
        BulkExportQueryCriteria criteria = new BulkExportQueryCriteria(this.split.getTableName());
        criteria.setDataBlockType(DataBlockType.DBT_SIMPLE_ROW_MATRIX);
        criteria.setInclusiveStartPrimaryKey(startKey);
        criteria.setExclusiveEndPrimaryKey(endKey);
        if (this.filter != null) {
            criteria.setFilter(this.filter);
        }
        if (this.columnHandles.length == 0) {
            criteria.addColumnsToGet(startKey.getPrimaryKeyColumns()[0].getName());
        } else {
            for (TablestoreColumnHandle column : this.columnHandles) {
                criteria.addColumnsToGet(column.getOriginColumnName());
            }
        }
        request.setBulkExportQueryCriteria(criteria);
        return sc.bulkExport(request);
    }
}

