/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tablestore;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.DefaultTableStoreWriter;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.TableStoreWriter;
import com.alicloud.openservices.tablestore.model.ConsumedCapacity;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.writer.WriterResult;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.tablestore.TablestoreClient;
import com.facebook.presto.tablestore.TablestoreConfig;
import com.facebook.presto.tablestore.TablestoreErrorCode;
import com.facebook.presto.tablestore.TablestorePageSink;
import com.facebook.presto.tablestore.model.TablestoreTable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class TablestoreAsyncPageSink {
    private static final Logger log = Logger.get(TablestoreAsyncPageSink.class);
    private final TablestoreClient client;
    private final TablestoreConfig config;
    private final TableStoreWriter writer;
    private final TablestoreTable table;
    private final AtomicLong succeedRows;
    private final AtomicLong failedRows;
    private final AtomicLong rowsInBuffer;
    private List<CompletableFuture> waitForBufferFree;
    private List<TablestorePageSink.CompletableFutureHandler> waitForFlushFuture;
    private Thread flushThread;
    private AtomicBoolean shutdown;

    public TablestoreAsyncPageSink(String schema, TablestoreClient client, TablestoreConfig config, TablestoreTable table, Executor executor) {
        this.client = client;
        this.config = config;
        this.table = table;
        this.succeedRows = new AtomicLong(0L);
        this.failedRows = new AtomicLong(0L);
        this.rowsInBuffer = new AtomicLong(0L);
        this.waitForBufferFree = new ArrayList<CompletableFuture>();
        this.waitForFlushFuture = new ArrayList<TablestorePageSink.CompletableFutureHandler>();
        this.shutdown = new AtomicBoolean(false);
        log.info("Init tablestore writer for table [%s].", new Object[]{table.getOriginName()});
        this.writer = new DefaultTableStoreWriter(client.getClient(schema).asAsyncClient(), table.getOriginName(), config.getWriterConfig(), (TableStoreCallback)new WriteCallback(), executor);
        this.flushThread = new Thread(new CheckBufferFree());
        this.flushThread.start();
    }

    public CompletableFuture<?> insertRows(List<RowChange> rowsChange, List<Future<WriterResult>> writerResults) {
        try {
            writerResults.add(this.writer.addRowChangeWithFuture(rowsChange));
        }
        catch (ClientException e) {
            throw new PrestoException((ErrorCodeSupplier)TablestoreErrorCode.DIRTY_ROWS_ERROR, (Throwable)e);
        }
        return this.checkBufferFull(rowsChange.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(TablestorePageSink.CompletableFutureHandler future) {
        log.info("Flush async page sink, total count of written rows is (%d/%d/%d).", new Object[]{this.succeedRows.get(), this.failedRows.get(), this.rowsInBuffer.get()});
        List<TablestorePageSink.CompletableFutureHandler> list = this.waitForFlushFuture;
        synchronized (list) {
            this.waitForFlushFuture.add(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture checkBufferFull(long rowsWritten) {
        long currentRowsInBuffer = this.rowsInBuffer.addAndGet(rowsWritten);
        if (currentRowsInBuffer >= this.config.getRowsBufferForSinkPerTable()) {
            log.warn("Table[%s]'s async sink buffer is full, total count of written rows is (%d/%d/%d).", new Object[]{this.table.getOriginName(), this.succeedRows.get(), this.failedRows.get(), this.rowsInBuffer.get()});
            CompletableFuture future = new CompletableFuture();
            List<CompletableFuture> list = this.waitForBufferFree;
            synchronized (list) {
                this.waitForBufferFree.add(future);
            }
            return future;
        }
        return ConnectorPageSink.NOT_BLOCKED;
    }

    public String getOriginTableName() {
        return this.table.getOriginName();
    }

    public void shutdown() throws InterruptedException {
        this.shutdown.set(true);
        this.flushThread.join();
        this.writer.close();
    }

    private class WriteCallback
    implements TableStoreCallback<RowChange, ConsumedCapacity> {
        private WriteCallback() {
        }

        public void onCompleted(RowChange req, ConsumedCapacity res) {
            TablestoreAsyncPageSink.this.succeedRows.getAndIncrement();
            TablestoreAsyncPageSink.this.rowsInBuffer.decrementAndGet();
        }

        public void onFailed(RowChange req, Exception ex) {
            log.error("Write row failed.", new Object[]{ex});
            TablestoreAsyncPageSink.this.failedRows.getAndIncrement();
            TablestoreAsyncPageSink.this.rowsInBuffer.decrementAndGet();
        }
    }

    private class CheckBufferFree
    implements Runnable {
        private CheckBufferFree() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!TablestoreAsyncPageSink.this.shutdown.get()) {
                List list = TablestoreAsyncPageSink.this.waitForBufferFree;
                synchronized (list) {
                    if (TablestoreAsyncPageSink.this.rowsInBuffer.get() < TablestoreAsyncPageSink.this.config.getRowsBufferForSinkPerTable()) {
                        for (CompletableFuture future : TablestoreAsyncPageSink.this.waitForBufferFree) {
                            future.complete(null);
                        }
                        TablestoreAsyncPageSink.this.waitForBufferFree.clear();
                    }
                }
                list = TablestoreAsyncPageSink.this.waitForFlushFuture;
                synchronized (list) {
                    if (!TablestoreAsyncPageSink.this.waitForFlushFuture.isEmpty()) {
                        TablestoreAsyncPageSink.this.writer.flush();
                        for (CompletableFuture future : TablestoreAsyncPageSink.this.waitForFlushFuture) {
                            ((TablestorePageSink.CompletableFutureHandler)future).completed();
                        }
                        TablestoreAsyncPageSink.this.waitForFlushFuture.clear();
                    }
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

