/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb2.db;

import com.aliyun.polardb2.Settings;
import com.aliyun.polardb2.Util;
import com.aliyun.polardb2.db.IDBHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public abstract class DBHandler
implements IDBHandler {
    protected Connection conn = null;
    protected String productName = null;
    protected String dbVersion = null;
    protected int stmtDmlCounter = 0;
    protected Statement commonStmt = null;

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public Statement getStatement() {
        return this.commonStmt;
    }

    @Override
    public void closeConnection() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.conn.createStatement();
    }

    @Override
    public void execute(String[] sqlTokens, String sql) throws SQLException {
        this.commonStmt.execute(sql);
    }

    @Override
    public void execute(String[] sqlTokens, boolean isCodeBlock, String sql) throws SQLException {
        this.execute(sqlTokens, sql);
    }

    @Override
    public abstract boolean isSelect(String[] var1);

    @Override
    public void printWarnings(Settings sessionSettings) throws SQLException {
        for (SQLWarning warn = this.commonStmt.getWarnings(); warn != null; warn = warn.getNextWarning()) {
            Util.println(warn.getMessage(), sessionSettings);
        }
    }

    @Override
    public void cancelStatement() throws SQLException {
        this.commonStmt.cancel();
        this.commonStmt.close();
        this.commonStmt = this.createStatement();
        this.silentRollback();
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getProductVersion() {
        return this.dbVersion;
    }

    @Override
    public abstract String getSupportedVersion();

    @Override
    public abstract void describeObject(String var1, Settings var2);

    @Override
    public abstract String getAlterUserSQL(String var1, String var2);

    @Override
    public abstract String getServerVarSQL(String var1);

    @Override
    public void commit(Settings s) throws SQLException {
        this.conn.commit();
    }

    @Override
    public void rollback(Settings s) throws SQLException {
        this.conn.rollback();
    }

    @Override
    public abstract void silentCommit();

    @Override
    public abstract void silentRollback();

    @Override
    public abstract void implicitRollback();

    @Override
    public void changeUserPassword(Settings sessionSettings, String userId, String newPassword) throws SQLException {
        this.commonStmt.execute(this.getAlterUserSQL(userId, newPassword));
        this.silentCommit();
    }

    @Override
    public void setConnAutoCommit(boolean autoCommit) throws SQLException {
        this.conn.setAutoCommit(autoCommit);
    }
}

