/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb2.db;

import com.aliyun.polardb2.Settings;
import com.aliyun.polardb2.Util;
import com.aliyun.polardb2.db.DBHandler;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DB2DBHandler
extends DBHandler {
    public static final String DEFAULT_PRODUCT_NAME = "IBM DB2";
    public static final String MINIMUM_SUPPORTED_DB_VERSION = "9.5";
    public static final String DEFAULT_DB_PORT = "50000";
    public static final String DEFAULT_DB_NAME = "SAMPLE";

    public DB2DBHandler() {
        this.productName = DEFAULT_PRODUCT_NAME;
    }

    @Override
    public Connection createConnection(String host, String port, String dbName, String userName, String password, String urlOptions) throws ClassNotFoundException, SQLException {
        Class.forName("com.ibm.db2.jcc.DB2Driver");
        this.conn = DriverManager.getConnection("jdbc:db2://" + host + ":" + port + "/" + dbName, userName, password);
        this.productName = this.conn.getMetaData().getDatabaseProductName();
        this.dbVersion = this.conn.getMetaData().getDatabaseProductVersion();
        this.commonStmt = this.createStatement();
        return this.conn;
    }

    @Override
    public boolean isSelect(String[] sqlTokens) {
        return sqlTokens[0].equals("select");
    }

    @Override
    public void printNotifications(Settings s) throws SQLException {
    }

    @Override
    public void handleCommandComplete(String[] sqlTokens, Settings s) throws SQLException {
        int updateCount = this.commonStmt.getUpdateCount();
        if (!sqlTokens[0].equals("begin") && !sqlTokens[0].equals("declare") || !s.feedback.equals("ON")) {
            if (sqlTokens[0].equals("commit")) {
                this.stmtDmlCounter = 0;
                if (s.feedback.equals("ON")) {
                    Util.println("\nCOMMIT completed.\n", s);
                }
            } else if (sqlTokens[0].equals("rollback")) {
                this.stmtDmlCounter = 0;
                if (s.feedback.equals("ON")) {
                    Util.println("\nROLLBACK completed.\n", s);
                }
            } else if (sqlTokens[0].equals("insert") && s.feedback.equals("ON")) {
                if (updateCount < 0) {
                    Util.println("\nINSERT completed.\n", s);
                } else if (updateCount == 1) {
                    Util.println("\n1 row INSERTED.\n", s);
                } else {
                    Util.println("\n" + updateCount + " rows INSERTED.\n", s);
                }
            } else if (sqlTokens[0].equals("update") && s.feedback.equals("ON")) {
                if (updateCount < 0) {
                    Util.println("\nUPDATE completed.\n", s);
                } else if (updateCount == 1) {
                    Util.println("\n1 row UPDATED.\n", s);
                } else {
                    Util.println("\n" + updateCount + " rows UPDATED.\n", s);
                }
            } else if (sqlTokens[0].equals("delete") && s.feedback.equals("ON")) {
                if (updateCount < 0) {
                    Util.println("\nDELETE completed.\n", s);
                } else if (updateCount == 1) {
                    Util.println("\n1 row DELETED.\n", s);
                } else {
                    Util.println("\n" + updateCount + " rows DELETED.\n", s);
                }
            } else if ((sqlTokens[0].equals("create") || sqlTokens[0].equals("drop") || sqlTokens[0].equals("truncate")) && s.feedback.equals("ON")) {
                if (sqlTokens.length >= 2) {
                    String description = "\n" + sqlTokens[1].toUpperCase().charAt(0) + sqlTokens[1].substring(1).toLowerCase() + " " + sqlTokens[0].toLowerCase();
                    if (sqlTokens[0].equals("drop")) {
                        description = description + "p";
                    }
                    if (!description.endsWith("e")) {
                        description = description + "e";
                    }
                    description = description + "d.";
                    description = description + "\n";
                    Util.println(description, s);
                }
            } else if (!sqlTokens[0].equals("select") && !sqlTokens[0].equals("declare") && !sqlTokens[0].equals("begin") && s.feedback.equals("ON")) {
                String description = "\n" + sqlTokens[0].toUpperCase().charAt(0) + sqlTokens[0].substring(1).toLowerCase() + " completed.\n";
                Util.println(description, s);
            }
        }
        if (sqlTokens[0].equals("insert") || sqlTokens[0].equals("update") || sqlTokens[0].equals("delete")) {
            ++this.stmtDmlCounter;
            if (this.stmtDmlCounter >= s.autocommitRows && s.autocommit.equals("ON")) {
                this.stmtDmlCounter = 0;
                if (s.feedback.equals("ON")) {
                    this.commit(s);
                } else {
                    this.silentCommit();
                }
            }
        }
        if (sqlTokens[0].equals("drop") || sqlTokens[0].equals("create") || sqlTokens[0].equals("truncate") || sqlTokens[0].equals("alter") || sqlTokens[0].equals("grant") || sqlTokens[0].equals("revoke")) {
            this.silentCommit();
        }
    }

    @Override
    public String getSupportedVersion() {
        return MINIMUM_SUPPORTED_DB_VERSION;
    }

    @Override
    public void describeObject(String arg, Settings s) {
        Util.println("\nEDB*PLUS does not support this feature for DB2\n", s);
    }

    @Override
    public String getAlterUserSQL(String userName, String password) {
        throw new UnsupportedOperationException("\nEDB*PLUS does not support this feature for DB2\n");
    }

    @Override
    public String getServerVarSQL(String varName) {
        throw new UnsupportedOperationException("\nEDB*PLUS does not support this feature for DB2\n");
    }

    @Override
    public void commit(Settings s) throws SQLException {
        this.conn.commit();
        Util.println("\nCOMMIT completed.\n", s);
    }

    @Override
    public void rollback(Settings s) throws SQLException {
        this.conn.rollback();
        Util.println("\nROLLBACK completed.\n", s);
    }

    @Override
    public void silentCommit() {
        try {
            this.conn.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void silentRollback() {
        try {
            this.conn.rollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public String getDefaultDBPort() {
        return DEFAULT_DB_PORT;
    }

    @Override
    public String getDefaultDBName() {
        return DEFAULT_DB_NAME;
    }

    @Override
    public void implicitRollback() {
        this.silentRollback();
    }

    @Override
    public boolean isStandardConformingStrings() {
        return false;
    }
}

