/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb2;

import com.aliyun.polardb2.ProcessInput;
import com.aliyun.polardb2.Settings;
import com.aliyun.polardb2.Util;
import com.aliyun.polardb2.db.IDBHandler;
import com.aliyun.polardb2.io.BufferedConsoleReader;
import com.aliyun.polardb2.unicode.UnicodeOutputStream;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.logging.LogManager;
import jline.UnixTerminal;
import jline.console.ConsoleReader;
import jline.console.internal.ConsoleRunner;

public class PolarPlus {
    private static final String VERSION_INFO = "polar*Plus: Release 11 (Build 37.0.0)";
    private static final String COPYRIGHT_INFO = "Copyright (c) 2008-2018, Alibaba Corporation.  All rights reserved.";
    public static Settings sessionSettings = null;
    private static ProcessInput pi = new ProcessInput();
    public static ConsoleReader in = null;
    public static boolean isTerminal = false;
    private static IDBHandler.DbType dbType = IDBHandler.DbType.PolarDB;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String cmdFile = null;
        try {
            String jLineConfig = PolarPlus.class.getResource("/jline.configuration").toString();
            System.setProperty("jline.configuration", jLineConfig);
            LogManager.getLogManager().readConfiguration(PolarPlus.class.getResourceAsStream("/logging.properties"));
            if (args.length <= 0 || !"CalledFromCode".equals(args[0])) {
                Console console;
                if (args.length == 0) {
                    sessionSettings = new Settings(dbType);
                    sessionSettings.connectDB(" ");
                } else {
                    int i;
                    for (i = 0; i < args.length; ++i) {
                        if (args[i].toLowerCase().startsWith("-h") && "-help".startsWith(args[i].toLowerCase())) {
                            sessionSettings = new Settings(dbType);
                            PolarPlus.printUsage();
                            return;
                        }
                        if (!args[i].toLowerCase().startsWith("-v") || !"-version".startsWith(args[i].toLowerCase())) continue;
                        sessionSettings = new Settings(dbType);
                        PolarPlus.printVersion();
                        return;
                    }
                    for (i = 0; i < args.length; ++i) {
                        if (!args[i].equalsIgnoreCase("-d") && !args[i].equalsIgnoreCase("-dbtype")) continue;
                        if (i + 1 < args.length) {
                            if (args[i + 1].equalsIgnoreCase("POLARDB") || args[i + 1].equalsIgnoreCase("POLARDB")) {
                                dbType = IDBHandler.DbType.PolarDB;
                                continue;
                            }
                            if (args[i + 1].equalsIgnoreCase("DB2")) {
                                dbType = IDBHandler.DbType.DB2;
                                continue;
                            }
                            System.err.println("ERROR: Invalid database type, choose a valid option; POLARDB|DB2");
                            return;
                        }
                        PolarPlus.printUsage();
                        return;
                    }
                    sessionSettings = new Settings(dbType);
                    boolean connectStringPresent = false;
                    for (int i2 = 0; i2 < args.length; ++i2) {
                        if (args[i2].toLowerCase().equals("-s") || args[i2].toLowerCase().equals("-silent")) {
                            PolarPlus.sessionSettings.silent = true;
                            continue;
                        }
                        if (args[i2].startsWith("@")) {
                            cmdFile = args[i2];
                            if (cmdFile.contains(" ")) {
                                cmdFile = cmdFile.substring(0, cmdFile.lastIndexOf("@")) + "\"" + cmdFile.substring(cmdFile.lastIndexOf("@") + 1) + "\"";
                            }
                            cmdFile = cmdFile.replace("\\", "\\\\");
                            for (int z = i2 + 1; z < args.length; ++z) {
                                cmdFile = cmdFile + " \"" + args[z] + "\"";
                            }
                            pi.startCommand(cmdFile, sessionSettings);
                            break;
                        }
                        if (args[i2].equalsIgnoreCase("-d") || args[i2].equalsIgnoreCase("-dbtype")) {
                            ++i2;
                            continue;
                        }
                        connectStringPresent = true;
                        sessionSettings.connectDB(args[i2]);
                    }
                    if (!connectStringPresent) {
                        sessionSettings.connectDB(" ");
                    }
                }
                if (!PolarPlus.sessionSettings.silent) {
                    Util.println(VERSION_INFO, sessionSettings);
                    Util.println("Copyright (c) 2008-2018, Alibaba Corporation.  All rights reserved.\n", sessionSettings);
                }
                if ((console = System.console()) != null) {
                    String[] arguments = new String[args.length + 2];
                    arguments[0] = "com.aliyun.polardb2.PolarPlus";
                    arguments[1] = "CalledFromCode";
                    System.arraycopy(args, 0, arguments, 2, args.length);
                    ConsoleRunner.main(arguments);
                    return;
                }
            }
            BufferedReader reader = null;
            Console console = System.console();
            if (console != null) {
                isTerminal = true;
                PolarPlus.initTerminal();
                reader = new BufferedConsoleReader(in);
            } else {
                reader = new BufferedReader(new InputStreamReader(System.in));
            }
            pi.inputLooper(reader, sessionSettings, true);
            reader.close();
        }
        catch (IOException ie) {
            Util.println("ERROR: Unable to read file \"" + cmdFile + "\"", sessionSettings);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (sessionSettings != null) {
                sessionSettings.disconnectDB();
            }
        }
        System.exit(0);
    }

    static void initTerminal() throws Exception {
        if (!System.getProperty("os.name").toLowerCase().contains("windows")) {
            in = new ConsoleReader();
            try {
                Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "stty intr ^^ < /dev/tty"});
                try {
                    p.waitFor();
                }
                catch (InterruptedException ie) {
                    System.err.println("Could not wait for completion of stty command: " + ie.getMessage());
                }
                try {
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void start() {
                            try {
                                ((UnixTerminal)in.getTerminal()).restore();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (AbstractMethodError abstractMethodError) {
                }
            }
            catch (IOException ioe) {
                System.err.println("ERROR:  Terminal initialization failed -- " + ioe.getMessage());
            }
        } else {
            Charset charSet = Charset.defaultCharset();
            in = "UTF-8".equalsIgnoreCase(charSet.toString()) ? new ConsoleReader(System.in, new UnicodeOutputStream()) : new ConsoleReader();
        }
        in.setExpandEvents(false);
    }

    public static ProcessInput getProcessInput() {
        return pi;
    }

    static void printUsage() {
        Util.println(VERSION_INFO, sessionSettings);
        Util.println("Copyright (c) 2008-2018, Alibaba Corporation.  All rights reserved.\n", sessionSettings);
        Util.println("Usage:", sessionSettings);
        Util.println("    polarplus [-H[ELP]] [-V[ERSION]] [-S[ILENT]] ", sessionSettings);
        Util.println("            [[/NOLOG] | [LOG INFO]]", sessionSettings);
        Util.println("            [-D[BTYPE] DBSERVER]", sessionSettings);
        Util.println("            [@commandFile] [param [param...]]", sessionSettings);
        Util.println(" ", sessionSettings);
        Util.println("    -H[ELP]       Displays polar*Plus version and usage.", sessionSettings);
        Util.println("    -V[ERSION]    Displays polar*Plus version.", sessionSettings);
        Util.println("    -S[SILENT]    Launches polar*Plus in silent mode. In this mode it does not ", sessionSettings);
        Util.println("                  display version information, prompt and commands entered.", sessionSettings);
        Util.println("    /NOLOG        Launces polar*Plus without connecting to the database.", sessionSettings);
        Util.println("    [LOG INFO]    Login information in the following format. ", sessionSettings);
        Util.println("                  [username/password[@host:port/dbname | user-variable] ]", sessionSettings);
        Util.println("                  User can specify user name, password, host, port and database", sessionSettings);
        Util.println("                  OR can use variable defined in login.sql available in current", sessionSettings);
        Util.println("                  folder.", sessionSettings);
        Util.println(" -D[BTYPE] SERVER The database server to connect with, supported options are \"POLARDB\" and \"DB2\" [default=POLARDB]", sessionSettings);
        Util.println("    @commandFile  Executes the specified polar*Plus script file with specified", sessionSettings);
        Util.println("                  parameters.", sessionSettings);
        Util.println(" ", sessionSettings);
        Util.println("For more information type HELP or HELP <command name> within polar*Plus or", sessionSettings);
        Util.println("consult polar*Plus section in POLARDB documentation.", sessionSettings);
    }

    static void printVersion() {
        Util.println(VERSION_INFO, sessionSettings);
    }
}

