/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb2.jdbc;

import com.aliyun.polardb2.util.GT;
import com.aliyun.polardb2.util.PSQLException;
import com.aliyun.polardb2.util.PSQLState;
import com.aliyun.polardb2.util.internal.Nullness;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PgClobText
implements Clob {
    private @Nullable String data;
    private boolean freed = false;

    public PgClobText() {
        this.data = null;
    }

    public PgClobText(@Nullable String s) {
        this.data = s;
    }

    @Override
    public void free() {
        if (!this.freed) {
            this.data = null;
        }
        this.freed = true;
    }

    private void checkIfFreed() throws SQLException {
        if (this.freed) {
            throw new SQLException("Operation forbidden on freed Clob");
        }
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.checkIfFreed();
        if (this.data != null) {
            return new ByteArrayInputStream(this.data.getBytes());
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkIfFreed();
        if (this.data != null) {
            return new StringReader(this.data);
        }
        return new StringReader("");
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkIfFreed();
        --pos;
        if (this.data != null) {
            return new StringReader(this.data.substring((int)pos, (int)(pos + length)));
        }
        return new StringReader("");
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        this.checkIfFreed();
        if (this.data != null) {
            if (pos < 1L) {
                throw new PSQLException(GT.tr("Invalid pos parameter {0}", pos), PSQLState.INVALID_PARAMETER_VALUE);
            }
            if (length < 0) {
                throw new PSQLException(GT.tr("Invalid length parameter {0}", length), PSQLState.INVALID_PARAMETER_VALUE);
            }
            long dlen = this.data.length();
            if (--pos + (long)length > dlen) {
                length = (int)(dlen - pos);
            }
            return this.data.substring((int)pos, (int)(pos + (long)length));
        }
        return Nullness.castNonNull(this.data);
    }

    @Override
    public long length() throws SQLException {
        this.checkIfFreed();
        if (this.data != null) {
            return this.data.length();
        }
        return 0L;
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        this.checkIfFreed();
        return this.position(searchstr.getSubString(1L, (int)searchstr.length()), start);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        this.checkIfFreed();
        if (this.data != null) {
            int pos = this.data.indexOf(searchstr, (int)(start - 1L));
            return pos == -1 ? -1L : (long)(pos + 1);
        }
        return -1L;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.checkIfFreed();
        return new TextClobOutputStream(pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        this.checkIfFreed();
        return new TextClobOutputStreamWriter(new TextClobOutputStream(pos));
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        this.checkIfFreed();
        if (pos < 1L) {
            throw new PSQLException(GT.tr("Invalid pos parameter {0}", pos), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.data == null) {
            if (pos == 1L) {
                this.data = "";
            } else {
                throw new PSQLException(GT.tr("Called setString on null Clob", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
        StringBuilder buf = new StringBuilder(this.data);
        int len = str.length();
        try {
            buf.replace((int)pos - 1, (int)(pos + (long)len - 1L), str);
            this.data = buf.toString();
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new PSQLException(GT.tr("Invalid pos parameter {0}", pos), PSQLState.INVALID_PARAMETER_VALUE);
        }
        return len;
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkIfFreed();
        if (pos < 1L) {
            throw new PSQLException(GT.tr("Invalid pos parameter {0}", pos), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.data == null) {
            if (pos == 1L) {
                this.data = "";
            } else {
                throw new PSQLException(GT.tr("Called setString on null Clob", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
        StringBuilder buf = new StringBuilder(this.data);
        try {
            String repl = str.substring(offset, offset + len);
            buf.replace((int)pos - 1, (int)(pos + (long)repl.length() - 1L), repl);
            this.data = buf.toString();
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new PSQLException(GT.tr("Invalid pos parameter {0}", pos), PSQLState.INVALID_PARAMETER_VALUE);
        }
        return len;
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.checkIfFreed();
        if (this.data == null) {
            throw new PSQLException(GT.tr("Called truncate on null Clob}", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (len > (long)this.data.length()) {
            throw new PSQLException(GT.tr("Called truncate with length too long for string of length {0}", this.data.length()), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.data = this.data.substring(0, (int)len);
    }

    public String toString() {
        return Nullness.castNonNull(this.data);
    }

    private class TextClobOutputStreamWriter
    extends OutputStreamWriter {
        TextClobOutputStreamWriter(OutputStream os) {
            super(os);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            super.write(cbuf, off, len);
            this.flush();
        }

        @Override
        public void write(int c) throws IOException {
            super.write(c);
            this.flush();
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            super.write(str, off, len);
            this.flush();
        }
    }

    private class TextClobOutputStream
    extends OutputStream {
        private int writePos;

        TextClobOutputStream(long pos) {
            this.writePos = (int)pos;
        }

        @Override
        public void write(int b) throws IOException {
            char c = (char)b;
            byte[] nb = String.valueOf(c).getBytes();
            this.write(nb);
        }

        @Override
        public void write(byte[] b) throws IOException {
            String sb = new String(b);
            try {
                this.writePos += PgClobText.this.setString(this.writePos, sb, 0, sb.length());
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            String sb = new String(b);
            try {
                this.writePos += PgClobText.this.setString(this.writePos, sb, off, len);
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
        }
    }
}

