/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb2.jdbc;

import com.aliyun.polardb2.PGProperty;
import com.aliyun.polardb2.util.GT;
import com.aliyun.polardb2.util.PSQLException;
import com.aliyun.polardb2.util.PSQLState;
import java.util.Properties;

public enum GSSEncMode {
    DISABLE("disable"),
    ALLOW("allow"),
    PREFER("prefer"),
    REQUIRE("require");

    private static final GSSEncMode[] VALUES;
    public final String value;

    private GSSEncMode(String value) {
        this.value = value;
    }

    public boolean requireEncryption() {
        return this.compareTo(REQUIRE) >= 0;
    }

    public static GSSEncMode of(Properties info) throws PSQLException {
        String gssEncMode = PGProperty.GSS_ENC_MODE.getOrDefault(info);
        if (gssEncMode == null) {
            return ALLOW;
        }
        for (GSSEncMode mode : VALUES) {
            if (!mode.value.equalsIgnoreCase(gssEncMode)) continue;
            return mode;
        }
        throw new PSQLException(GT.tr("Invalid gssEncMode value: {0}", gssEncMode), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    static {
        VALUES = GSSEncMode.values();
    }
}

