/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb2.core;

import com.aliyun.polardb2.core.BaseQueryKey;
import com.aliyun.polardb2.core.CachedQuery;
import com.aliyun.polardb2.core.CallableQueryKey;
import com.aliyun.polardb2.core.JdbcCallParseInfo;
import com.aliyun.polardb2.core.NativeQuery;
import com.aliyun.polardb2.core.Parser;
import com.aliyun.polardb2.core.Query;
import com.aliyun.polardb2.core.QueryExecutor;
import com.aliyun.polardb2.core.QueryWithReturningColumnsKey;
import com.aliyun.polardb2.jdbc.EscapeSyntaxCallMode;
import com.aliyun.polardb2.jdbc.PreferQueryMode;
import com.aliyun.polardb2.polarora.UnNamedProc;
import com.aliyun.polardb2.util.LruCache;
import com.aliyun.polardb2.util.internal.Nullness;
import java.sql.SQLException;
import java.util.List;

class CachedQueryCreateAction
implements LruCache.CreateAction<Object, CachedQuery> {
    private static final String[] EMPTY_RETURNING = new String[0];
    private final QueryExecutor queryExecutor;

    CachedQueryCreateAction(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    @Override
    public CachedQuery create(Object key) throws SQLException {
        boolean isFunction;
        String parsedSql;
        BaseQueryKey queryKey;
        assert (key instanceof String || key instanceof BaseQueryKey) : "Query key should be String or BaseQueryKey. Given " + key.getClass() + ", sql: " + key;
        if (key instanceof BaseQueryKey) {
            queryKey = (BaseQueryKey)key;
            parsedSql = queryKey.sql;
        } else {
            queryKey = null;
            parsedSql = (String)key;
        }
        UnNamedProc proc = null;
        if (this.queryExecutor.supportUnnamedProc() && (proc = new UnNamedProc(parsedSql, key instanceof CallableQueryKey)).isUnamedProc()) {
            parsedSql = proc.getUnamedProcSql();
        }
        if (key instanceof String || Nullness.castNonNull(queryKey).escapeProcessing) {
            parsedSql = Parser.replaceProcessing(parsedSql, true, this.queryExecutor.getStandardConformingStrings());
        }
        if (key instanceof CallableQueryKey) {
            JdbcCallParseInfo callInfo = Parser.modifyJdbcCall(parsedSql, this.queryExecutor.getStandardConformingStrings(), this.queryExecutor.getServerVersionNum(), this.queryExecutor.getProtocolVersion(), proc != null && proc.isUnamedProc() ? EscapeSyntaxCallMode.of("call") : this.queryExecutor.getEscapeSyntaxCallMode());
            parsedSql = callInfo.getSql();
            isFunction = callInfo.isFunction();
        } else {
            isFunction = false;
        }
        boolean isParameterized = key instanceof String || Nullness.castNonNull(queryKey).isParameterized;
        boolean splitStatements = isParameterized || this.queryExecutor.getPreferQueryMode().compareTo(PreferQueryMode.EXTENDED) >= 0;
        String[] returningColumns = key instanceof QueryWithReturningColumnsKey ? ((QueryWithReturningColumnsKey)key).columnNames : EMPTY_RETURNING;
        List<NativeQuery> queries = Parser.parseJdbcSql(parsedSql, this.queryExecutor.getStandardConformingStrings(), isParameterized, splitStatements, this.queryExecutor.isReWriteBatchedInsertsEnabled(), this.queryExecutor.getQuoteReturningIdentifiers(), this.queryExecutor.isNamedParam(), returningColumns);
        Query query = this.queryExecutor.wrap(queries);
        return new CachedQuery(key, query, isFunction, proc);
    }
}

