/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.xa;

import com.aliyun.polardb.util.Base64;
import java.util.Arrays;
import javax.transaction.xa.Xid;

class RecoveredXid
implements Xid {
    int formatId;
    byte[] globalTransactionId;
    byte[] branchQualifier;

    RecoveredXid() {
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.branchQualifier);
        result = 31 * result + this.formatId;
        result = 31 * result + Arrays.hashCode(this.globalTransactionId);
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Xid)) {
            return false;
        }
        Xid other = (Xid)o;
        if (other.getFormatId() != this.formatId) {
            return false;
        }
        if (!Arrays.equals(this.globalTransactionId, other.getGlobalTransactionId())) {
            return false;
        }
        return Arrays.equals(this.branchQualifier, other.getBranchQualifier());
    }

    public String toString() {
        return RecoveredXid.xidToString(this);
    }

    static String xidToString(Xid xid) {
        return xid.getFormatId() + "_" + Base64.encodeBytes(xid.getGlobalTransactionId(), 8) + "_" + Base64.encodeBytes(xid.getBranchQualifier(), 8);
    }

    static String xidToStringV2(Xid xid) {
        String globalTxn = new String(xid.getGlobalTransactionId());
        String branchName = new String(xid.getBranchQualifier());
        if (globalTxn.indexOf("/") != -1 || globalTxn.indexOf("_") != -1) {
            throw new RuntimeException("'/' or '_' can't be used in global transaction");
        }
        if (branchName.indexOf("/") != -1 || branchName.indexOf("_") != -1) {
            throw new RuntimeException("'/' or '_' can't be used in branch name");
        }
        String result = "V" + xid.getFormatId() + "_" + new String(xid.getGlobalTransactionId()) + "_" + new String(xid.getBranchQualifier());
        if (result.length() > 190) {
            throw new RuntimeException("XID is too long after encoding");
        }
        if (!result.matches("\\A\\p{ASCII}*\\z")) {
            throw new RuntimeException("XID is invalid, please get byte[] from a valid ASCII string");
        }
        return result;
    }

    static Xid stringToXid(String s) {
        int b;
        RecoveredXid xid = new RecoveredXid();
        int a = s.indexOf("_");
        if (a == (b = s.lastIndexOf("_"))) {
            return null;
        }
        try {
            boolean isV2;
            boolean bl = isV2 = s.charAt(0) == 'V';
            if (!isV2) {
                xid.formatId = Integer.parseInt(s.substring(0, a));
                xid.globalTransactionId = Base64.decode(s.substring(a + 1, b));
                xid.branchQualifier = Base64.decode(s.substring(b + 1));
                if (xid.globalTransactionId == null || xid.branchQualifier == null) {
                    return null;
                }
            } else {
                xid.formatId = Integer.parseInt(s.substring(1, a));
                xid.globalTransactionId = s.substring(a + 1, b).getBytes();
                xid.branchQualifier = s.substring(b + 1).getBytes();
                if (xid.globalTransactionId == null || xid.branchQualifier == null) {
                    return null;
                }
            }
        }
        catch (Exception ex) {
            return null;
        }
        return xid;
    }
}

