/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.util;

import java.io.Writer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class WriterHandler
extends Handler {
    private boolean doneHeader;
    private Writer writer;

    public WriterHandler(Writer inWriter) {
        this.setLevel(Level.INFO);
        this.setFilter(null);
        this.setFormatter(new SimpleFormatter());
        this.writer = inWriter;
    }

    public WriterHandler(Writer inWriter, Formatter formatter) {
        this.setLevel(Level.INFO);
        this.setFilter(null);
        this.setFormatter(formatter);
        this.writer = inWriter;
    }

    @Override
    public synchronized void publish(LogRecord record) {
        String msg;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            msg = this.getFormatter().format(record);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return;
        }
        try {
            if (!this.doneHeader) {
                this.writer.write(this.getFormatter().getHead(this));
                this.doneHeader = true;
            }
            this.writer.write(msg);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 1);
        }
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        if (this.writer == null || record == null) {
            return false;
        }
        return super.isLoggable(record);
    }

    @Override
    public synchronized void flush() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (Exception ex) {
                this.reportError(null, ex, 2);
            }
        }
    }

    private synchronized void flushAndClose() throws SecurityException {
        if (this.writer != null) {
            try {
                if (!this.doneHeader) {
                    this.writer.write(this.getFormatter().getHead(this));
                    this.doneHeader = true;
                }
                this.writer.write(this.getFormatter().getTail(this));
                this.writer.flush();
                this.writer.close();
            }
            catch (Exception ex) {
                this.reportError(null, ex, 3);
            }
            this.writer = null;
        }
    }

    @Override
    public synchronized void close() throws SecurityException {
        this.flushAndClose();
    }
}

