/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.replication.fluent.physical;

import com.aliyun.polardb.core.BaseConnection;
import com.aliyun.polardb.replication.LogSequenceNumber;
import com.aliyun.polardb.replication.ReplicationSlotInfo;
import com.aliyun.polardb.replication.ReplicationType;
import com.aliyun.polardb.replication.fluent.AbstractCreateSlotBuilder;
import com.aliyun.polardb.replication.fluent.physical.ChainedPhysicalCreateSlotBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class PhysicalCreateSlotBuilder
extends AbstractCreateSlotBuilder<ChainedPhysicalCreateSlotBuilder>
implements ChainedPhysicalCreateSlotBuilder {
    public PhysicalCreateSlotBuilder(BaseConnection connection) {
        super(connection);
    }

    @Override
    protected ChainedPhysicalCreateSlotBuilder self() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicationSlotInfo make() throws SQLException {
        if (this.slotName == null || this.slotName.isEmpty()) {
            throw new IllegalArgumentException("Replication slotName can't be null");
        }
        Statement statement = this.connection.createStatement();
        ResultSet result = null;
        ReplicationSlotInfo slotInfo = null;
        try {
            statement.execute(String.format("CREATE_REPLICATION_SLOT %s %s PHYSICAL", this.slotName, this.temporaryOption ? "TEMPORARY" : ""));
            result = statement.getResultSet();
            if (result != null && result.next()) {
                slotInfo = new ReplicationSlotInfo(result.getString("slot_name"), ReplicationType.PHYSICAL, LogSequenceNumber.valueOf(result.getString("consistent_point")), result.getString("snapshot_name"), result.getString("output_plugin"));
            }
        }
        finally {
            if (result != null) {
                result.close();
            }
            statement.close();
        }
        return slotInfo;
    }
}

