/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.AbstractBeanField;
import com.opencsv.bean.AbstractCsvConverter;
import com.opencsv.bean.AbstractMappingStrategy;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.BeanFieldJoinStringIndex;
import com.opencsv.bean.BeanFieldSingleValue;
import com.opencsv.bean.BeanFieldSplit;
import com.opencsv.bean.ComplexFieldMapEntry;
import com.opencsv.bean.CsvBindAndJoinByName;
import com.opencsv.bean.CsvBindAndSplitByName;
import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvConverter;
import com.opencsv.bean.CsvCustomBindByName;
import com.opencsv.bean.FieldMap;
import com.opencsv.bean.FieldMapByName;
import com.opencsv.bean.FieldMapByNameEntry;
import com.opencsv.exceptions.CsvBadConverterException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class HeaderColumnNameMappingStrategy<T>
extends AbstractMappingStrategy<String, String, ComplexFieldMapEntry<String, String, T>, T> {
    protected FieldMapByName<T> fieldMap = null;
    protected Comparator<String> writeOrder = null;

    @Override
    public void captureHeader(CSVReader reader) throws IOException, CsvRequiredFieldEmptyException {
        if (this.type == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("type.unset"));
        }
        Object[] header = ObjectUtils.defaultIfNull(reader.readNext(), ArrayUtils.EMPTY_STRING_ARRAY);
        this.headerIndex.initializeHeaderIndex((String[])header);
        List<FieldMapByNameEntry<T>> missingRequiredHeaders = this.fieldMap.determineMissingRequiredHeaders((String[])header);
        if (!missingRequiredHeaders.isEmpty()) {
            Object[] requiredHeaderNames = new String[missingRequiredHeaders.size()];
            ArrayList<Field> requiredFields = new ArrayList<Field>(missingRequiredHeaders.size());
            for (int i = 0; i < missingRequiredHeaders.size(); ++i) {
                FieldMapByNameEntry<T> fme = missingRequiredHeaders.get(i);
                requiredHeaderNames[i] = fme.isRegexPattern() ? String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("matching"), fme.getName()) : fme.getName();
                requiredFields.add(fme.getField().getField());
            }
            String missingRequiredFields = StringUtils.join(requiredHeaderNames, ", ");
            String allHeaders = StringUtils.join(header, ',');
            CsvRequiredFieldEmptyException e = new CsvRequiredFieldEmptyException(this.type, requiredFields, String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("header.required.field.absent"), missingRequiredFields, allHeaders));
            e.setLine((String[])header);
            throw e;
        }
    }

    @Override
    protected Object chooseMultivaluedFieldIndexFromHeaderIndex(int index) {
        String[] s2 = this.headerIndex.getHeaderIndex();
        return index >= s2.length ? null : s2[index];
    }

    @Override
    public void verifyLineLength(int numberOfFields) throws CsvRequiredFieldEmptyException {
        if (!this.headerIndex.isEmpty() && numberOfFields != this.headerIndex.getHeaderIndexLength()) {
            throw new CsvRequiredFieldEmptyException(this.type, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("header.data.mismatch"));
        }
    }

    @Override
    public BeanField<T> findField(int col) throws CsvBadConverterException {
        BeanField beanField = null;
        String columnName = this.getColumnName(col);
        if (StringUtils.isNotBlank(columnName)) {
            beanField = this.fieldMap.get(columnName.toUpperCase().trim());
        }
        return beanField;
    }

    @Override
    protected void loadFieldMap() throws CsvBadConverterException {
        this.fieldMap = new FieldMapByName(this.errorLocale);
        this.fieldMap.setColumnOrderOnWrite(this.writeOrder);
        for (Field field : this.loadFields(this.getType())) {
            String format;
            String capture;
            String locale;
            boolean required;
            Object converter;
            String columnName;
            Annotation annotation;
            if (field.isAnnotationPresent(CsvCustomBindByName.class)) {
                annotation = field.getAnnotation(CsvCustomBindByName.class);
                columnName = annotation.column().toUpperCase().trim();
                if (StringUtils.isEmpty(columnName)) {
                    columnName = field.getName().toUpperCase();
                }
                converter = field.getAnnotation(CsvCustomBindByName.class).converter();
                BeanField bean = this.instantiateCustomConverter((Class<? extends AbstractBeanField>)converter);
                bean.setField(field);
                required = annotation.required();
                bean.setRequired(required);
                this.fieldMap.put(columnName, bean);
                continue;
            }
            if (field.isAnnotationPresent(CsvBindAndSplitByName.class)) {
                annotation = field.getAnnotation(CsvBindAndSplitByName.class);
                required = annotation.required();
                columnName = annotation.column().toUpperCase().trim();
                locale = annotation.locale();
                String splitOn = annotation.splitOn();
                String writeDelimiter = annotation.writeDelimiter();
                Class<? extends Collection> collectionType = annotation.collectionType();
                Class<?> elementType = annotation.elementType();
                Class<? extends AbstractCsvConverter> splitConverter = annotation.converter();
                capture = annotation.capture();
                format = annotation.format();
                CsvConverter converter2 = this.determineConverter(field, elementType, locale, splitConverter);
                if (StringUtils.isEmpty(columnName)) {
                    this.fieldMap.put(field.getName().toUpperCase(), new BeanFieldSplit(field, required, this.errorLocale, converter2, splitOn, writeDelimiter, collectionType, capture, format));
                    continue;
                }
                this.fieldMap.put(columnName, new BeanFieldSplit(field, required, this.errorLocale, converter2, splitOn, writeDelimiter, collectionType, capture, format));
                continue;
            }
            if (field.isAnnotationPresent(CsvBindAndJoinByName.class)) {
                annotation = field.getAnnotation(CsvBindAndJoinByName.class);
                required = annotation.required();
                String columnRegex = annotation.column();
                locale = annotation.locale();
                Class<?> elementType = annotation.elementType();
                Class<? extends MultiValuedMap> mapType = annotation.mapType();
                Class<? extends AbstractCsvConverter> joinConverter = annotation.converter();
                capture = annotation.capture();
                format = annotation.format();
                CsvConverter converter3 = this.determineConverter(field, elementType, locale, joinConverter);
                if (StringUtils.isEmpty(columnRegex)) {
                    this.fieldMap.putComplex(field.getName(), new BeanFieldJoinStringIndex(field, required, this.errorLocale, converter3, mapType, capture, format));
                    continue;
                }
                this.fieldMap.putComplex(columnRegex, new BeanFieldJoinStringIndex(field, required, this.errorLocale, converter3, mapType, capture, format));
                continue;
            }
            annotation = field.getAnnotation(CsvBindByName.class);
            required = annotation.required();
            columnName = annotation.column().toUpperCase().trim();
            locale = annotation.locale();
            capture = annotation.capture();
            format = annotation.format();
            converter = this.determineConverter(field, field.getType(), locale, null);
            if (StringUtils.isEmpty(columnName)) {
                this.fieldMap.put(field.getName().toUpperCase(), new BeanFieldSingleValue(field, required, this.errorLocale, (CsvConverter)converter, capture, format));
                continue;
            }
            this.fieldMap.put(columnName, new BeanFieldSingleValue(field, required, this.errorLocale, (CsvConverter)converter, capture, format));
        }
    }

    private List<Field> loadFields(Class<? extends T> cls) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Field field : FieldUtils.getAllFields(cls)) {
            if (!field.isAnnotationPresent(CsvBindByName.class) && !field.isAnnotationPresent(CsvCustomBindByName.class) && !field.isAnnotationPresent(CsvBindAndSplitByName.class) && !field.isAnnotationPresent(CsvBindAndJoinByName.class)) continue;
            fields.add(field);
        }
        this.setAnnotationDriven(!fields.isEmpty());
        return fields;
    }

    @Override
    protected FieldMap<String, String, ? extends ComplexFieldMapEntry<String, String, T>, T> getFieldMap() {
        return this.fieldMap;
    }

    @Override
    public String findHeader(int col) {
        return this.headerIndex.getByPosition(col);
    }

    @Override
    public Integer getColumnIndex(String name) {
        if (this.headerIndex.isEmpty()) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("header.unread"));
        }
        return super.getColumnIndex(name);
    }

    public void setColumnOrderOnWrite(Comparator<String> writeOrder) {
        this.writeOrder = writeOrder;
        if (this.fieldMap != null) {
            this.fieldMap.setColumnOrderOnWrite(this.writeOrder);
        }
    }
}

