/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.crypto;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.crypto.AesCtr;
import com.aliyun.oss.crypto.CryptoCipher;
import com.aliyun.oss.crypto.CryptoRuntime;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public abstract class CryptoScheme {
    public static final int BLOCK_SIZE = 16;
    public static final CryptoScheme AES_CTR;

    public abstract String getKeyGeneratorAlgorithm();

    public abstract int getKeyLengthInBits();

    public abstract String getContentChiperAlgorithm();

    public abstract int getContentChiperIVLength();

    public abstract byte[] adjustIV(byte[] var1, long var2);

    public CryptoCipher newCryptoCipher(Cipher cipher, SecretKey cek, int cipherMode) {
        return new CryptoCipher(cipher, this, cek, cipherMode);
    }

    public CryptoCipher createCryptoCipher(SecretKey cek, byte[] iv, int cipherMode, Provider provider) {
        try {
            Cipher cipher = null;
            cipher = provider != null ? Cipher.getInstance(this.getContentChiperAlgorithm(), provider) : Cipher.getInstance(this.getContentChiperAlgorithm());
            cipher.init(cipherMode, (Key)cek, new IvParameterSpec(iv));
            return this.newCryptoCipher(cipher, cek, cipherMode);
        }
        catch (Exception e) {
            throw new ClientException("Unable to build cipher: " + e.getMessage(), e);
        }
    }

    public static byte[] incrementBlocks(byte[] counter2, long blockDelta) {
        if (blockDelta == 0L) {
            return counter2;
        }
        if (counter2 == null || counter2.length != 16) {
            throw new IllegalArgumentException();
        }
        ByteBuffer bb = ByteBuffer.allocate(8);
        for (int i = 12; i <= 15; ++i) {
            bb.put(i - 8, counter2[i]);
        }
        long val = bb.getLong() + blockDelta;
        bb.rewind();
        byte[] result = bb.putLong(val).array();
        for (int i = 8; i <= 15; ++i) {
            counter2[i] = result[i - 8];
        }
        return counter2;
    }

    public static CryptoScheme fromCEKAlgo(String cekAlgo) {
        if (AES_CTR.getContentChiperAlgorithm().equals(cekAlgo)) {
            return AES_CTR;
        }
        throw new UnsupportedOperationException("Unsupported content encryption scheme: " + cekAlgo);
    }

    static {
        CryptoRuntime.enableBouncyCastle();
        AES_CTR = new AesCtr();
    }
}

