/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.provider;

import com.aliyun.credentials.Configuration;
import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.http.CompatibleUrlConnClient;
import com.aliyun.credentials.models.Config;
import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.credentials.provider.ECSMetadataServiceCredentialsFetcher;
import com.aliyun.credentials.provider.RefreshCachedSupplier;
import com.aliyun.credentials.provider.RefreshResult;
import com.aliyun.credentials.provider.SessionCredentialsProvider;
import com.aliyun.credentials.utils.AuthUtils;
import com.aliyun.credentials.utils.StringUtils;
import com.aliyun.tea.logging.ClientLogger;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class EcsRamRoleCredentialProvider
extends SessionCredentialsProvider {
    private static final ClientLogger logger = new ClientLogger(EcsRamRoleCredentialProvider.class);
    private static final int ASYNC_REFRESH_INTERVAL_TIME_MINUTES = 1;
    private ECSMetadataServiceCredentialsFetcher fetcher;
    private volatile ScheduledExecutorService executor;
    private volatile boolean shouldRefresh = false;

    @Deprecated
    public EcsRamRoleCredentialProvider(String roleName) {
        super(new BuilderImpl());
        if (StringUtils.isEmpty(roleName)) {
            try (CompatibleUrlConnClient client = new CompatibleUrlConnClient();){
                roleName = new ECSMetadataServiceCredentialsFetcher("").fetchRoleName(client);
            }
        }
        this.fetcher = new ECSMetadataServiceCredentialsFetcher(roleName);
        this.checkCredentialsUpdateAsynchronously();
    }

    @Deprecated
    public EcsRamRoleCredentialProvider(Configuration config) {
        super(new BuilderImpl());
        if (StringUtils.isEmpty(config.getRoleName())) {
            try (CompatibleUrlConnClient client = new CompatibleUrlConnClient();){
                String roleName = new ECSMetadataServiceCredentialsFetcher("").fetchRoleName(client);
                config.setRoleName(roleName);
            }
        }
        this.fetcher = new ECSMetadataServiceCredentialsFetcher(config.getRoleName(), config.getConnectTimeout(), config.getReadTimeout());
        this.checkCredentialsUpdateAsynchronously();
    }

    @Deprecated
    public EcsRamRoleCredentialProvider(Config config) {
        super(new BuilderImpl());
        String roleName = config.roleName;
        if (StringUtils.isEmpty(roleName)) {
            try (CompatibleUrlConnClient client = new CompatibleUrlConnClient();){
                roleName = new ECSMetadataServiceCredentialsFetcher("", config.disableIMDSv1, config.connectTimeout, config.timeout).fetchRoleName(client);
            }
        }
        this.fetcher = new ECSMetadataServiceCredentialsFetcher(roleName, config.disableIMDSv1, config.connectTimeout, config.timeout);
        this.checkCredentialsUpdateAsynchronously();
    }

    private EcsRamRoleCredentialProvider(BuilderImpl builder) {
        super(builder);
        if (AuthUtils.isDisableECSMetaData()) {
            throw new CredentialException("IMDS credentials is disabled.");
        }
        String roleName = builder.roleName == null ? AuthUtils.getEnvironmentECSMetaData() : builder.roleName;
        boolean disableIMDSv1 = builder.disableIMDSv1 == null ? AuthUtils.getDisableECSIMDSv1() : builder.disableIMDSv1;
        this.fetcher = new ECSMetadataServiceCredentialsFetcher(roleName, disableIMDSv1, builder.connectionTimeout, builder.readTimeout);
        this.checkCredentialsUpdateAsynchronously();
    }

    private void checkCredentialsUpdateAsynchronously() {
        if (this.isAsyncCredentialUpdateEnabled()) {
            this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setName("imds-credentials-check-and-refresh");
                    t.setDaemon(true);
                    return t;
                }
            });
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (EcsRamRoleCredentialProvider.this.shouldRefresh) {
                            logger.info("Begin checking or refreshing credentials asynchronously");
                            EcsRamRoleCredentialProvider.this.getCredentials();
                        }
                    }
                    catch (Exception re) {
                        this.handleAsyncRefreshError(re);
                    }
                }

                private void handleAsyncRefreshError(Exception e) {
                    logger.warning("Failed when checking or refreshing credentials asynchronously, error: {}.", e.getMessage());
                }
            }, 0L, 1L, TimeUnit.MINUTES);
        }
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public RefreshResult<CredentialModel> refreshCredentials() {
        try (CompatibleUrlConnClient client = new CompatibleUrlConnClient();){
            RefreshResult<CredentialModel> result = this.fetcher.fetch(client);
            this.shouldRefresh = true;
            RefreshResult<CredentialModel> refreshResult = result;
            return refreshResult;
        }
    }

    public ECSMetadataServiceCredentialsFetcher getFetcher() {
        return this.fetcher;
    }

    public void setFetcher(ECSMetadataServiceCredentialsFetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public String getProviderName() {
        return "ecs_ram_role";
    }

    @Override
    public void close() {
        super.close();
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    private static final class BuilderImpl
    extends SessionCredentialsProvider.BuilderImpl<EcsRamRoleCredentialProvider, Builder>
    implements Builder {
        private String roleName;
        private Boolean disableIMDSv1;
        private boolean enableIMDSv2;
        private int metadataTokenDuration;
        private Integer connectionTimeout;
        private Integer readTimeout;

        private BuilderImpl() {
            this.asyncCredentialUpdateEnabled = true;
            this.jitterEnabled = true;
            this.staleValueBehavior = RefreshCachedSupplier.StaleValueBehavior.ALLOW;
        }

        @Override
        public Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        @Override
        public Builder disableIMDSv1(Boolean disableIMDSv1) {
            this.disableIMDSv1 = disableIMDSv1;
            return this;
        }

        @Override
        public Builder enableIMDSv2(boolean enableIMDSv2) {
            this.enableIMDSv2 = enableIMDSv2;
            return this;
        }

        @Override
        public Builder metadataTokenDuration(int metadataTokenDuration) {
            if (metadataTokenDuration > 0) {
                this.metadataTokenDuration = metadataTokenDuration;
            }
            return this;
        }

        @Override
        public Builder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        @Override
        public Builder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Override
        public EcsRamRoleCredentialProvider build() {
            return new EcsRamRoleCredentialProvider(this);
        }
    }

    public static interface Builder
    extends SessionCredentialsProvider.Builder<EcsRamRoleCredentialProvider, Builder> {
        public Builder roleName(String var1);

        public Builder disableIMDSv1(Boolean var1);

        @Deprecated
        public Builder enableIMDSv2(boolean var1);

        @Deprecated
        public Builder metadataTokenDuration(int var1);

        public Builder connectionTimeout(Integer var1);

        public Builder readTimeout(Integer var1);

        @Override
        public EcsRamRoleCredentialProvider build();
    }
}

