/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.provider;

import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;
import com.aliyun.credentials.provider.EcsRamRoleCredentialProvider;
import com.aliyun.credentials.provider.OIDCRoleArnCredentialProvider;
import com.aliyun.credentials.provider.RamRoleArnCredentialProvider;
import com.aliyun.credentials.provider.StaticCredentialsProvider;
import com.aliyun.credentials.utils.AuthUtils;
import com.aliyun.credentials.utils.StringUtils;
import com.aliyun.tea.utils.Validate;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;

public class CLIProfileCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    private final String CLI_CREDENTIALS_CONFIG_PATH = System.getProperty("user.home") + "/.aliyun/config.json";
    private volatile AlibabaCloudCredentialsProvider credentialsProvider;
    private volatile String currentProfileName;
    private final Object credentialsProviderLock = new Object();

    private CLIProfileCredentialsProvider(Builder builder) {
        this.currentProfileName = builder.profileName == null ? System.getenv("ALIBABA_CLOUD_PROFILE") : builder.profileName;
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CredentialModel getCredentials() {
        if (AuthUtils.isDisableCLIProfile()) {
            throw new CredentialException("CLI credentials file is disabled.");
        }
        Config config = this.parseProfile(this.CLI_CREDENTIALS_CONFIG_PATH);
        if (null == config) {
            throw new CredentialException("Unable to get profile from empty CLI credentials file.");
        }
        String refreshedProfileName = System.getenv("ALIBABA_CLOUD_PROFILE");
        if (this.shouldReloadCredentialsProvider(refreshedProfileName)) {
            Object object = this.credentialsProviderLock;
            synchronized (object) {
                if (this.shouldReloadCredentialsProvider(refreshedProfileName)) {
                    if (!StringUtils.isEmpty(refreshedProfileName)) {
                        this.currentProfileName = refreshedProfileName;
                    }
                    this.credentialsProvider = this.reloadCredentialsProvider(config, this.currentProfileName);
                }
            }
        }
        CredentialModel credential = this.credentialsProvider.getCredentials();
        return CredentialModel.builder().accessKeyId(credential.getAccessKeyId()).accessKeySecret(credential.getAccessKeySecret()).securityToken(credential.getSecurityToken()).expiration(credential.getExpiration()).type(credential.getType()).providerName(String.format("%s/%s", this.getProviderName(), credential.getProviderName())).build();
    }

    AlibabaCloudCredentialsProvider reloadCredentialsProvider(Config config, String profileName) {
        String currentProfileName = !StringUtils.isEmpty(profileName) ? profileName : config.getCurrent();
        List<Profile> profiles = config.getProfiles();
        if (profiles != null && !profiles.isEmpty()) {
            for (Profile profile : profiles) {
                if (StringUtils.isEmpty(profile.getName()) || !profile.getName().equals(currentProfileName)) continue;
                switch (profile.getMode()) {
                    case "AK": {
                        return StaticCredentialsProvider.builder().credential(CredentialModel.builder().accessKeyId(Validate.notNull(profile.getAccessKeyId(), "AccessKeyId must not be null.", new Object[0])).accessKeySecret(Validate.notNull(profile.getAccessKeySecret(), "AccessKeySecret must not be null.", new Object[0])).type("access_key").providerName("static_ak").build()).build();
                    }
                    case "RamRoleArn": {
                        StaticCredentialsProvider innerProvider = StaticCredentialsProvider.builder().credential(CredentialModel.builder().accessKeyId(Validate.notNull(profile.getAccessKeyId(), "AccessKeyId must not be null.", new Object[0])).accessKeySecret(Validate.notNull(profile.getAccessKeySecret(), "AccessKeySecret must not be null.", new Object[0])).type("access_key").providerName("static_ak").build()).build();
                        return RamRoleArnCredentialProvider.builder().credentialsProvider(innerProvider).durationSeconds(profile.getDurationSeconds()).roleArn(profile.getRoleArn()).roleSessionName(profile.getRoleSessionName()).stsRegionId(profile.getStsRegionId()).enableVpc(profile.getEnableVpc()).policy(profile.getPolicy()).externalId(profile.getExternalId()).build();
                    }
                    case "EcsRamRole": {
                        return EcsRamRoleCredentialProvider.builder().roleName(profile.getRamRoleName()).build();
                    }
                    case "OIDC": {
                        return OIDCRoleArnCredentialProvider.builder().durationSeconds(profile.getDurationSeconds()).roleArn(profile.getRoleArn()).roleSessionName(profile.getRoleSessionName()).oidcProviderArn(profile.getOidcProviderArn()).oidcTokenFilePath(profile.getOidcTokenFile()).stsRegionId(profile.getStsRegionId()).enableVpc(profile.getEnableVpc()).policy(profile.getPolicy()).build();
                    }
                    case "ChainableRamRoleArn": {
                        AlibabaCloudCredentialsProvider previousProvider = this.reloadCredentialsProvider(config, profile.getSourceProfile());
                        return RamRoleArnCredentialProvider.builder().credentialsProvider(previousProvider).durationSeconds(profile.getDurationSeconds()).roleArn(profile.getRoleArn()).roleSessionName(profile.getRoleSessionName()).stsRegionId(profile.getStsRegionId()).enableVpc(profile.getEnableVpc()).policy(profile.getPolicy()).externalId(profile.getExternalId()).build();
                    }
                }
                throw new CredentialException(String.format("Unsupported profile mode '%s' form CLI credentials file.", profile.getMode()));
            }
        }
        throw new CredentialException(String.format("Unable to get profile with '%s' form CLI credentials file.", currentProfileName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Config parseProfile(String configFilePath) {
        File configFile = new File(configFilePath);
        if (!(configFile.exists() && configFile.isFile() && configFile.canRead())) {
            throw new CredentialException(String.format("Unable to open credentials file: %s.", configFile.getAbsolutePath()));
        }
        Gson gson = new Gson();
        try (BufferedReader br = new BufferedReader(new FileReader(configFile));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String jsonContent = sb.toString();
            Config config = gson.fromJson(jsonContent, Config.class);
            return config;
        }
        catch (Exception e) {
            throw new CredentialException(String.format("Failed to parse credential form CLI credentials file: %s.", configFile.getAbsolutePath()));
        }
    }

    boolean shouldReloadCredentialsProvider(String profileName) {
        return this.credentialsProvider == null || !StringUtils.isEmpty(this.currentProfileName) && !StringUtils.isEmpty(profileName) && !this.currentProfileName.equals(profileName);
    }

    String getProfileName() {
        return this.currentProfileName;
    }

    @Override
    public String getProviderName() {
        return "cli_profile";
    }

    @Override
    public void close() {
    }

    static class Profile {
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="mode")
        private String mode;
        @SerializedName(value="access_key_id")
        private String accessKeyId;
        @SerializedName(value="access_key_secret")
        private String accessKeySecret;
        @SerializedName(value="ram_role_arn")
        private String roleArn;
        @SerializedName(value="ram_session_name")
        private String roleSessionName;
        @SerializedName(value="expired_seconds")
        private Integer durationSeconds;
        @SerializedName(value="sts_region")
        private String stsRegionId;
        @SerializedName(value="enable_vpc")
        private Boolean enableVpc;
        @SerializedName(value="ram_role_name")
        private String ramRoleName;
        @SerializedName(value="oidc_token_file")
        private String oidcTokenFile;
        @SerializedName(value="oidc_provider_arn")
        private String oidcProviderArn;
        @SerializedName(value="source_profile")
        private String sourceProfile;
        @SerializedName(value="policy")
        private String policy;
        @SerializedName(value="external_id")
        private String externalId;

        Profile() {
        }

        public String getName() {
            return this.name;
        }

        public String getMode() {
            return this.mode;
        }

        public String getAccessKeyId() {
            return this.accessKeyId;
        }

        public String getAccessKeySecret() {
            return this.accessKeySecret;
        }

        public String getRoleArn() {
            return this.roleArn;
        }

        public String getRoleSessionName() {
            return this.roleSessionName;
        }

        public Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        public String getStsRegionId() {
            return this.stsRegionId;
        }

        public Boolean getEnableVpc() {
            return this.enableVpc;
        }

        public String getRamRoleName() {
            return this.ramRoleName;
        }

        public String getOidcTokenFile() {
            return this.oidcTokenFile;
        }

        public String getOidcProviderArn() {
            return this.oidcProviderArn;
        }

        public String getSourceProfile() {
            return this.sourceProfile;
        }

        public String getPolicy() {
            return this.policy;
        }

        public String getExternalId() {
            return this.externalId;
        }
    }

    static class Config {
        @SerializedName(value="current")
        private String current;
        @SerializedName(value="profiles")
        private List<Profile> profiles;

        Config() {
        }

        public String getCurrent() {
            return this.current;
        }

        public List<Profile> getProfiles() {
            return this.profiles;
        }
    }

    public static final class Builder {
        private String profileName;

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public CLIProfileCredentialsProvider build() {
            return new CLIProfileCredentialsProvider(this);
        }
    }
}

