/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.jdbc;

import com.aliyun.polardb.core.BaseConnection;
import com.aliyun.polardb.core.BaseStatement;
import com.aliyun.polardb.core.ServerVersion;
import com.aliyun.polardb.core.TypeInfo;
import com.aliyun.polardb.util.GT;
import com.aliyun.polardb.util.PGobject;
import com.aliyun.polardb.util.PSQLException;
import com.aliyun.polardb.util.PSQLState;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TypeInfoCache
implements TypeInfo {
    private Map<String, Integer> _pgNameToSQLType;
    private Map<String, String> _pgNameToJavaClass;
    private Map<Integer, String> _oidToPgName;
    private Map<String, Integer> _pgNameToOid;
    private Map<String, Class<? extends PGobject>> _pgNameToPgObject;
    private Map<Integer, Integer> _pgArrayToPgType;
    private Map<Integer, List> _pgStructToPgTypes;
    private Map<String, Integer> _pgNameToRelkind;
    private Map<Integer, Character> _arrayOidToDelimiter;
    private Map _sqlTypeToOid;
    private BaseConnection _conn;
    private final int _unknownLength;
    private PreparedStatement _getOidStatementSimple;
    private PreparedStatement _getOidStatementComplexNonArray;
    private PreparedStatement _getOidStatementComplexArray;
    private PreparedStatement _getNameStatement;
    private PreparedStatement _getArrayElementOidStatement;
    private PreparedStatement _getArrayDelimiterStatement;
    private PreparedStatement _getTypeInfoStatement;
    private PreparedStatement _getTypeInfoStatementComplex;
    private PreparedStatement _getRelkindStatement;
    private PreparedStatement _getRelkindStatementComplex;
    private PreparedStatement _getStructElementOidStatement;
    private static final Object[][] types = new Object[][]{{"int2", 21, 5, "java.lang.Integer", 1005}, {"int4", 23, 4, "java.lang.Integer", 1007}, {"oid", 26, -5, "java.lang.Long", 1028}, {"int8", 20, -5, "java.lang.Long", 1016}, {"money", 790, 8, "java.lang.Double", 791}, {"numeric", 1700, 2, "java.math.BigDecimal", 1231}, {"float4", 700, 7, "java.lang.Float", 1021}, {"float8", 701, 8, "java.lang.Double", 1022}, {"char", 18, 1, "java.lang.String", 1002}, {"bpchar", 1042, 1, "java.lang.String", 1014}, {"text", 25, 12, "java.lang.String", 1009}, {"name", 19, 12, "java.lang.String", 1003}, {"varchar", 1043, 12, "java.lang.String", 1015}, {"bytea", 17, -2, "[B", 1001}, {"bool", 16, -7, "java.lang.Boolean", 1000}, {"bit", 1560, -7, "java.lang.Boolean", 1561}, {"date", 1082, 91, "java.sql.Date", 1182}, {"time", 1083, 92, "java.sql.Time", 1183}, {"timetz", 1266, 92, "java.sql.Time", 1270}, {"timestamp", 1114, 93, "java.sql.Timestamp", 1115}, {"timestamptz", 1184, 93, "java.sql.Timestamp", 1185}, {"refcursor", 1790, 2012, "java.sql.ResultSet", 2201}, {"json", 114, 1111, "com.aliyun.polardb.util.PGobject", 199}, {"point", 600, 1111, "com.aliyun.polardb.geometric.PGpoint", 1017}};
    private static final HashMap<String, String> typeAliases = new HashMap();

    public TypeInfoCache(BaseConnection conn, int unknownLength) {
        this._conn = conn;
        this._unknownLength = unknownLength;
        this._oidToPgName = new HashMap<Integer, String>();
        this._pgNameToOid = new HashMap<String, Integer>();
        this._pgNameToJavaClass = new HashMap<String, String>();
        this._pgNameToPgObject = new HashMap<String, Class<? extends PGobject>>();
        this._pgArrayToPgType = new HashMap<Integer, Integer>();
        this._arrayOidToDelimiter = new HashMap<Integer, Character>();
        this._sqlTypeToOid = new HashMap();
        this._pgNameToSQLType = Collections.synchronizedMap(new HashMap());
        for (Object[] type : types) {
            String pgTypeName = (String)type[0];
            Integer oid = (Integer)type[1];
            Integer sqlType = (Integer)type[2];
            String javaClass = (String)type[3];
            Integer arrayOid = (Integer)type[4];
            this.addCoreType(pgTypeName, oid, sqlType, javaClass, arrayOid);
        }
        this._pgNameToJavaClass.put("hstore", Map.class.getName());
        this._pgStructToPgTypes = new HashMap<Integer, List>();
        this._pgNameToRelkind = new HashMap<String, Integer>();
    }

    @Override
    public synchronized void addCoreType(String pgTypeName, Integer oid, Integer sqlType, String javaClass, Integer arrayOid) {
        this._pgNameToJavaClass.put(pgTypeName, javaClass);
        this._pgNameToOid.put(pgTypeName, oid);
        this._oidToPgName.put(oid, pgTypeName);
        this._pgArrayToPgType.put(arrayOid, oid);
        this._pgNameToSQLType.put(pgTypeName, sqlType);
        this._sqlTypeToOid.put(sqlType, oid);
        Character delim = Character.valueOf(',');
        this._arrayOidToDelimiter.put(oid, delim);
        String pgArrayTypeName = pgTypeName + "[]";
        this._pgNameToJavaClass.put(pgArrayTypeName, "java.sql.Array");
        this._pgNameToSQLType.put(pgArrayTypeName, 2003);
        this._pgNameToOid.put(pgArrayTypeName, arrayOid);
        pgArrayTypeName = "_" + pgTypeName;
        if (!this._pgNameToJavaClass.containsKey(pgArrayTypeName)) {
            this._pgNameToJavaClass.put(pgArrayTypeName, "java.sql.Array");
            this._pgNameToSQLType.put(pgArrayTypeName, 2003);
            this._pgNameToOid.put(pgArrayTypeName, arrayOid);
            this._oidToPgName.put(arrayOid, pgArrayTypeName);
        }
    }

    @Override
    public synchronized void addDataType(String type, Class<? extends PGobject> klass) throws SQLException {
        this._pgNameToPgObject.put(type, klass);
        this._pgNameToJavaClass.put(type, klass.getName());
    }

    @Override
    public Iterator<String> getPGTypeNamesWithSQLTypes() {
        return this._pgNameToSQLType.keySet().iterator();
    }

    @Override
    public int getSQLType(int oid) throws SQLException {
        return this.getSQLType(this.getPGType(oid));
    }

    @Override
    public synchronized int getSQLType(String pgTypeName) throws SQLException {
        if (pgTypeName.endsWith("[]")) {
            return 2003;
        }
        Integer i = this._pgNameToSQLType.get(pgTypeName);
        if (i != null) {
            return i;
        }
        PreparedStatement typeInfoStatement = this.getTypeInfoStatement(pgTypeName);
        if (!((BaseStatement)((Object)typeInfoStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = typeInfoStatement.getResultSet();
        Integer type = null;
        if (rs.next()) {
            boolean isArray = rs.getBoolean(1);
            String typtype = rs.getString(2);
            if (isArray) {
                type = 2003;
            } else if ("c".equals(typtype)) {
                type = 2002;
            } else if ("d".equals(typtype)) {
                type = 2001;
            } else if ("e".equals(typtype)) {
                type = 12;
            }
        }
        if (type == null) {
            type = 1111;
        }
        rs.close();
        if (pgTypeName != null) {
            this._pgNameToSQLType.put(pgTypeName, type);
        }
        return type;
    }

    private PreparedStatement getTypeInfoStatement(String pgTypeName) throws SQLException {
        boolean isArray = pgTypeName.endsWith("[]");
        boolean hasQuote = pgTypeName.contains("\"");
        int dotIndex = pgTypeName.indexOf(46);
        String typInput = "typinput='array_in'::regproc";
        if (this._conn.haveMinimumServerVersion(ServerVersion.v9_2)) {
            typInput = typInput + " OR typinput='nestedtable_in'::regproc";
        }
        if (dotIndex == -1 && !hasQuote) {
            if (this._getTypeInfoStatement == null) {
                String sql = "SELECT " + typInput + ", typtype   FROM pg_catalog.pg_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))[s.r] as nspname                    from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace  WHERE typname = ?  ORDER BY sp.r, pg_type.oid DESC LIMIT 1;";
                this._getTypeInfoStatement = this._conn.prepareStatement(sql);
            }
            this._getTypeInfoStatement.setString(1, pgTypeName);
            return this._getTypeInfoStatement;
        }
        if (this._getTypeInfoStatementComplex == null) {
            String sql = "SELECT " + typInput + ", typtype  FROM pg_catalog.pg_type  JOIN pg_catalog.pg_namespace n ON typnamespace = n.oid  WHERE typname = ? AND (n.nspname = ? OR ? IS NULL AND n.nspname = ANY (current_schemas(false))) ORDER BY pg_type.oid DESC LIMIT 1;";
            this._getTypeInfoStatementComplex = this._conn.prepareStatement(sql);
        }
        PreparedStatement typeInfoStatementComplex = this._getTypeInfoStatementComplex;
        String[] pgTypeNameParts = TypeInfoCache.splitTypeName(pgTypeName);
        String schema = pgTypeNameParts[0];
        String name = pgTypeNameParts[1];
        boolean stringVarcharFlag = this._conn.getStringVarcharFlag();
        this._conn.setStringVarcharFlag(true);
        typeInfoStatementComplex.setString(1, name);
        typeInfoStatementComplex.setString(2, schema);
        typeInfoStatementComplex.setString(3, schema);
        this._conn.setStringVarcharFlag(stringVarcharFlag);
        return typeInfoStatementComplex;
    }

    private PreparedStatement getRelkindStatement(String pgTypeName) throws SQLException {
        boolean isArray = pgTypeName.endsWith("[]");
        boolean hasQuote = pgTypeName.contains("\"");
        int dotIndex = pgTypeName.indexOf(46);
        String typInput = "typinput='array_in'::regproc";
        if (this._conn.haveMinimumServerVersion(ServerVersion.v9_2)) {
            typInput = typInput + " OR typinput='nestedtable_in'::regproc";
        }
        if (dotIndex == -1 && !hasQuote) {
            if (this._getRelkindStatement == null) {
                String sql = "SELECT " + typInput + ", relkind   FROM pg_catalog.pg_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))[s.r] as nspname                    from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace  LEFT JOIN pg_catalog.pg_class as pc ON typrelid = pc.oid  WHERE typname = ?  ORDER BY sp.r, pg_type.oid DESC LIMIT 1;";
                this._getRelkindStatement = this._conn.prepareStatement(sql);
            }
            this._getRelkindStatement.setString(1, pgTypeName);
            return this._getRelkindStatement;
        }
        if (this._getRelkindStatementComplex == null) {
            String sql = "SELECT " + typInput + ", relkind  FROM pg_catalog.pg_type  JOIN pg_catalog.pg_namespace n ON typnamespace = n.oid  LEFT JOIN pg_catalog.pg_class as pc ON typrelid = pc.oid  WHERE typname = ? AND (n.nspname = ? OR ? IS NULL AND n.nspname = ANY (current_schemas(false))) ORDER BY pg_type.oid DESC LIMIT 1;";
            this._getRelkindStatementComplex = this._conn.prepareStatement(sql);
        }
        PreparedStatement typeRelkindStatementComplex = this._getRelkindStatementComplex;
        String[] pgTypeNameParts = TypeInfoCache.splitTypeName(pgTypeName);
        String schema = pgTypeNameParts[0];
        String name = pgTypeNameParts[1];
        typeRelkindStatementComplex.setString(1, name);
        typeRelkindStatementComplex.setString(2, schema);
        typeRelkindStatementComplex.setString(3, schema);
        return typeRelkindStatementComplex;
    }

    @Override
    public synchronized int getRelkindSQLType(int oid) throws SQLException {
        return this.getRelkindSQLType(this.getPGType(oid));
    }

    @Override
    public synchronized int getRelkindSQLType(String pgTypeName) throws SQLException {
        if (pgTypeName.endsWith("[]")) {
            return 2003;
        }
        Integer i = this._pgNameToRelkind.get(pgTypeName);
        if (i != null) {
            return i;
        }
        PreparedStatement relkindStatement = this.getRelkindStatement(pgTypeName);
        if (relkindStatement == null) {
            return 1111;
        }
        if (!((BaseStatement)((Object)relkindStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = relkindStatement.getResultSet();
        Integer type = null;
        if (rs.next()) {
            boolean isArray = rs.getBoolean(1);
            String relkind = rs.getString(2);
            if (isArray) {
                type = 2003;
            } else if ("c".equals(relkind)) {
                type = 2002;
            } else if ("d".equals(relkind)) {
                type = 2001;
            } else if ("e".equals(relkind)) {
                type = 12;
            }
        }
        if (type == null) {
            type = 1111;
        }
        rs.close();
        if (pgTypeName != null) {
            this._pgNameToRelkind.put(pgTypeName, type);
        }
        return type;
    }

    private PreparedStatement getOidStatement(String pgTypeName) throws SQLException {
        String name;
        String schema;
        String fullName;
        PreparedStatement oidStatementComplex;
        String sql;
        boolean isArray = pgTypeName.endsWith("[]");
        boolean hasQuote = pgTypeName.contains("\"");
        int dotIndex = pgTypeName.indexOf(46);
        if (dotIndex == -1 && !hasQuote && !isArray) {
            if (this._getOidStatementSimple == null) {
                String sql2 = "SELECT pg_type.oid, typname   FROM pg_catalog.pg_type   LEFT   JOIN (select ns.oid as nspoid, ns.nspname, r.r           from pg_namespace as ns           join ( select s.r, (current_schemas(false))[s.r] as nspname                    from generate_series(1, array_upper(current_schemas(false), 1)) as s(r) ) as r          using ( nspname )        ) as sp     ON sp.nspoid = typnamespace  WHERE typname = ?  ORDER BY sp.r, pg_type.oid DESC LIMIT 1;";
                this._getOidStatementSimple = this._conn.prepareStatement(sql2);
            }
            String lcName = pgTypeName.toLowerCase();
            this._getOidStatementSimple.setString(1, lcName);
            return this._getOidStatementSimple;
        }
        if (isArray) {
            if (this._getOidStatementComplexArray == null) {
                sql = this._conn.haveMinimumServerVersion(ServerVersion.v8_3) ? "SELECT t.typarray, arr.typname   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid  JOIN pg_catalog.pg_type arr ON arr.oid = t.typarray WHERE t.typname = ? AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.oid DESC LIMIT 1" : "SELECT t.oid, t.typname   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.typelem = (SELECT oid FROM pg_catalog.pg_type WHERE typname = ?) AND substring(t.typname, 1, 1) = '_' AND t.typlen = -1 AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.typelem DESC LIMIT 1";
                this._getOidStatementComplexArray = this._conn.prepareStatement(sql);
            }
            oidStatementComplex = this._getOidStatementComplexArray;
        } else {
            if (this._getOidStatementComplexNonArray == null) {
                sql = "SELECT t.oid, t.typname   FROM pg_catalog.pg_type t  JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.typname = ? AND (n.nspname = ? OR ? AND n.nspname = ANY (current_schemas(true))) ORDER BY t.oid DESC LIMIT 1";
                this._getOidStatementComplexNonArray = this._conn.prepareStatement(sql);
            }
            oidStatementComplex = this._getOidStatementComplexNonArray;
        }
        String string = fullName = isArray ? pgTypeName.substring(0, pgTypeName.length() - 2) : pgTypeName;
        if (dotIndex == -1) {
            schema = null;
            name = fullName;
        } else if (fullName.startsWith("\"")) {
            if (fullName.endsWith("\"")) {
                String[] parts = fullName.split("\"\\.\"");
                schema = parts.length == 2 ? parts[0] + "\"" : null;
                name = parts.length == 2 ? "\"" + parts[1] : parts[0];
            } else {
                int lastDotIndex = fullName.lastIndexOf(46);
                name = fullName.substring(lastDotIndex + 1);
                schema = fullName.substring(0, lastDotIndex);
            }
        } else {
            schema = fullName.substring(0, dotIndex);
            name = fullName.substring(dotIndex + 1);
        }
        if (schema != null && schema.startsWith("\"") && schema.endsWith("\"")) {
            schema = schema.substring(1, schema.length() - 1);
        } else if (schema != null) {
            schema = schema.toLowerCase();
        }
        name = name.startsWith("\"") && name.endsWith("\"") ? name.substring(1, name.length() - 1) : name.toLowerCase();
        oidStatementComplex.setString(1, name);
        oidStatementComplex.setString(2, schema);
        oidStatementComplex.setBoolean(3, schema == null);
        return oidStatementComplex;
    }

    @Override
    public synchronized int getPGType(String pgTypeName) throws SQLException {
        Integer oid = this._pgNameToOid.get(pgTypeName);
        if (oid != null) {
            return oid;
        }
        PreparedStatement oidStatement = this.getOidStatement(pgTypeName);
        if (!((BaseStatement)((Object)oidStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        oid = 0;
        ResultSet rs = oidStatement.getResultSet();
        if (rs.next()) {
            oid = (int)rs.getLong(1);
            String internalName = rs.getString(2);
            this._oidToPgName.put(oid, internalName);
            this._pgNameToOid.put(internalName, oid);
        }
        this._pgNameToOid.put(pgTypeName, oid);
        rs.close();
        return oid;
    }

    @Override
    public synchronized String getPGType(int oid) throws SQLException {
        if (oid == 0) {
            return null;
        }
        String pgTypeName = this._oidToPgName.get(oid);
        if (pgTypeName != null) {
            return pgTypeName;
        }
        if (this._getNameStatement == null) {
            String sql = "SELECT n.nspname = ANY(current_schemas(true)), n.nspname, t.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this._getNameStatement = this._conn.prepareStatement(sql);
        }
        this._getNameStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getNameStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getNameStatement.getResultSet();
        if (rs.next()) {
            boolean onPath = rs.getBoolean(1);
            String schema = rs.getString(2);
            String name = rs.getString(3);
            if (onPath) {
                pgTypeName = name;
                this._pgNameToOid.put(schema + "." + name, oid);
            } else {
                pgTypeName = "\"" + schema + "\".\"" + name + "\"";
                if (schema.equals(schema.toLowerCase()) && schema.indexOf(46) == -1 && name.equals(name.toLowerCase()) && name.indexOf(46) == -1) {
                    this._pgNameToOid.put(schema + "." + name, oid);
                }
            }
            this._pgNameToOid.put(pgTypeName, oid);
            this._oidToPgName.put(oid, pgTypeName);
        }
        rs.close();
        return pgTypeName;
    }

    @Override
    public int getPGArrayType(String elementTypeName) throws SQLException {
        elementTypeName = this.getTypeForAlias(elementTypeName);
        return this.getPGType(elementTypeName + "[]");
    }

    protected synchronized int convertArrayToBaseOid(int oid) {
        Integer i = this._pgArrayToPgType.get(oid);
        if (i == null) {
            return oid;
        }
        return i;
    }

    @Override
    public synchronized char getArrayDelimiter(int oid) throws SQLException {
        if (oid == 0) {
            return ',';
        }
        Character delim = this._arrayOidToDelimiter.get(oid);
        if (delim != null) {
            return delim.charValue();
        }
        if (this._getArrayDelimiterStatement == null) {
            String sql = "SELECT e.typdelim FROM pg_catalog.pg_type t, pg_catalog.pg_type e WHERE t.oid = ? and t.typelem = e.oid";
            this._getArrayDelimiterStatement = this._conn.prepareStatement(sql);
        }
        this._getArrayDelimiterStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getArrayDelimiterStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getArrayDelimiterStatement.getResultSet();
        if (!rs.next()) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        String s = rs.getString(1);
        delim = Character.valueOf(s.charAt(0));
        this._arrayOidToDelimiter.put(oid, delim);
        rs.close();
        return delim.charValue();
    }

    @Override
    public synchronized int getPGArrayElement(int oid) throws SQLException {
        if (oid == 0) {
            return 0;
        }
        Integer pgType = this._pgArrayToPgType.get(oid);
        if (pgType != null) {
            return pgType;
        }
        if (this._getArrayElementOidStatement == null) {
            String sql = "SELECT e.oid, n.nspname = ANY(current_schemas(true)), n.nspname, e.typname FROM pg_catalog.pg_type t JOIN pg_catalog.pg_type e ON t.typelem = e.oid JOIN pg_catalog.pg_namespace n ON t.typnamespace = n.oid WHERE t.oid = ?";
            this._getArrayElementOidStatement = this._conn.prepareStatement(sql);
        }
        this._getArrayElementOidStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getArrayElementOidStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getArrayElementOidStatement.getResultSet();
        if (!rs.next()) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        pgType = (int)rs.getLong(1);
        boolean onPath = rs.getBoolean(2);
        String schema = rs.getString(3);
        String name = rs.getString(4);
        this._pgArrayToPgType.put(oid, pgType);
        this._pgNameToOid.put(schema + "." + name, pgType);
        String fullName = "\"" + schema + "\".\"" + name + "\"";
        this._pgNameToOid.put(fullName, pgType);
        if (onPath && name.equals(name.toLowerCase())) {
            this._oidToPgName.put(pgType, name);
            this._pgNameToOid.put(name, pgType);
        } else {
            this._oidToPgName.put(pgType, fullName);
        }
        rs.close();
        return pgType;
    }

    @Override
    public synchronized List getStructAttributes(int oid) throws SQLException {
        if (oid == 0) {
            return null;
        }
        ArrayList<Integer> pgTypes = this._pgStructToPgTypes.get(oid);
        if (pgTypes != null) {
            return pgTypes;
        }
        if (this._getStructElementOidStatement == null) {
            String sql = "select a.oid, n.nspname = ANY(current_schemas(true)), n.nspname, a.typname from pg_type t  join pg_class on (reltype = t.oid) join pg_attribute on (attrelid = pg_class.oid and attnum > 0)  join pg_type a on (atttypid = a.oid) join pg_namespace n on (a.typnamespace = n.oid)  where t.oid = ? order by pg_attribute.attnum ";
            this._getStructElementOidStatement = this._conn.prepareStatement(sql);
        }
        this._getStructElementOidStatement.setInt(1, oid);
        if (!((BaseStatement)((Object)this._getStructElementOidStatement)).executeWithFlags(16)) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        ResultSet rs = this._getStructElementOidStatement.getResultSet();
        int pgType = 0;
        pgTypes = new ArrayList<Integer>();
        while (rs.next()) {
            pgType = (int)rs.getLong(1);
            boolean onPath = rs.getBoolean(2);
            String schema = rs.getString(3);
            String name = rs.getString(4);
            this._pgNameToOid.put(schema + "." + name, pgType);
            String fullName = "\"" + schema + "\".\"" + name + "\"";
            this._pgNameToOid.put(fullName, pgType);
            if (onPath && name.equals(name.toLowerCase())) {
                this._oidToPgName.put(pgType, name);
                this._pgNameToOid.put(name, pgType);
            } else {
                this._oidToPgName.put(pgType, fullName);
            }
            pgTypes.add(pgType);
        }
        rs.close();
        if (pgTypes.size() == 0) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        this._pgStructToPgTypes.put(oid, pgTypes);
        return pgTypes;
    }

    @Override
    public synchronized Class<? extends PGobject> getPGobject(String type) {
        return this._pgNameToPgObject.get(type);
    }

    @Override
    public synchronized String getJavaClass(int oid) throws SQLException {
        String pgTypeName = this.getPGType(oid);
        String result = this._pgNameToJavaClass.get(pgTypeName);
        if (result != null) {
            return result;
        }
        if (this.getSQLType(pgTypeName) == 2003) {
            result = "java.sql.Array";
            this._pgNameToJavaClass.put(pgTypeName, result);
        }
        return result;
    }

    @Override
    public String getTypeForAlias(String alias) {
        String type = typeAliases.get(alias);
        if (type != null) {
            return type;
        }
        if (alias.indexOf(34) == -1 && (type = typeAliases.get(alias.toLowerCase())) != null) {
            return type;
        }
        return alias;
    }

    @Override
    public int getPrecision(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 21: {
                return 5;
            }
            case 23: 
            case 26: {
                return 10;
            }
            case 20: {
                return 19;
            }
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return (typmod - 4 & 0xFFFF0000) >> 16;
            }
            case 16: 
            case 18: {
                return 1;
            }
            case 1042: 
            case 1043: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod - 4;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: {
                return this.getDisplaySize(oid, typmod);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod;
            }
        }
        return this._unknownLength;
    }

    @Override
    public int getScale(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typmod == -1) {
                    return 0;
                }
                return typmod - 4 & 0xFFFF;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod;
            }
            case 1186: {
                if (typmod == -1) {
                    return 6;
                }
                return typmod & 0xFFFF;
            }
        }
        return 0;
    }

    @Override
    public boolean isCaseSensitive(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 700: 
            case 701: 
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: 
            case 1560: 
            case 1562: 
            case 1700: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSigned(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 20: 
            case 21: 
            case 23: 
            case 700: 
            case 701: 
            case 1700: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getDisplaySize(int oid, int typmod) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 21: {
                return 6;
            }
            case 23: {
                return 11;
            }
            case 26: {
                return 10;
            }
            case 20: {
                return 20;
            }
            case 700: {
                return 15;
            }
            case 701: {
                return 25;
            }
            case 18: {
                return 1;
            }
            case 16: {
                return 1;
            }
            case 1082: {
                return 13;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                int secondSize;
                switch (typmod) {
                    case -1: {
                        secondSize = 7;
                        break;
                    }
                    case 0: {
                        secondSize = 0;
                        break;
                    }
                    case 1: {
                        secondSize = 3;
                        break;
                    }
                    default: {
                        secondSize = typmod + 1;
                    }
                }
                switch (oid) {
                    case 1083: {
                        return 8 + secondSize;
                    }
                    case 1266: {
                        return 8 + secondSize + 6;
                    }
                    case 1114: {
                        return 22 + secondSize;
                    }
                    case 1184: {
                        return 22 + secondSize + 6;
                    }
                }
            }
            case 1186: {
                return 49;
            }
            case 1042: 
            case 1043: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod - 4;
            }
            case 1700: {
                if (typmod == -1) {
                    return 131089;
                }
                int precision = typmod - 4 >> 16 & 0xFFFF;
                int scale = typmod - 4 & 0xFFFF;
                return 1 + precision + (scale != 0 ? 1 : 0);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return this._unknownLength;
                }
                return typmod;
            }
            case 17: 
            case 25: {
                return this._unknownLength;
            }
        }
        return this._unknownLength;
    }

    @Override
    public int getMaximumPrecision(int oid) {
        oid = this.convertArrayToBaseOid(oid);
        switch (oid) {
            case 1700: {
                return 1000;
            }
            case 1083: 
            case 1266: {
                return 6;
            }
            case 1114: 
            case 1184: 
            case 1186: {
                return 6;
            }
            case 1042: 
            case 1043: {
                return 0xA00000;
            }
            case 1560: 
            case 1562: {
                return 0x5000000;
            }
        }
        return 0;
    }

    @Override
    public boolean requiresQuoting(int oid) throws SQLException {
        int sqlType = this.getSQLType(oid);
        return this.requiresQuotingSqlType(sqlType);
    }

    @Override
    public boolean requiresQuotingSqlType(int sqlType) throws SQLException {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Integer getOid(Integer sqlType) {
        Integer oid = (Integer)this._sqlTypeToOid.get(sqlType);
        if (oid == null) {
            oid = new Integer(0);
        }
        return oid;
    }

    public static boolean compareTypeNames(String pgTypeName1, String pgTypeName2) throws SQLException {
        String[] pgTypeNameParts1 = TypeInfoCache.splitTypeName(pgTypeName1);
        String[] pgTypeNameParts2 = TypeInfoCache.splitTypeName(pgTypeName2);
        if (pgTypeNameParts1[0] == null || pgTypeNameParts2[0] == null) {
            return pgTypeNameParts1[1].equals(pgTypeNameParts2[1]);
        }
        return pgTypeNameParts1[0].equals(pgTypeNameParts2[0]) && pgTypeNameParts1[1].equals(pgTypeNameParts2[1]);
    }

    public static String[] splitTypeName(String pgTypeName) {
        String name;
        String schema;
        String fullName1;
        boolean isArray = pgTypeName.endsWith("[]");
        boolean hasQuote = pgTypeName.contains("\"");
        int dotIndex = pgTypeName.indexOf(46);
        String string = fullName1 = isArray ? pgTypeName.substring(0, pgTypeName.length() - 2) : pgTypeName;
        if (dotIndex == -1) {
            schema = null;
            name = fullName1;
        } else if (fullName1.startsWith("\"")) {
            if (fullName1.endsWith("\"")) {
                String[] parts = fullName1.split("\"\\.\"");
                schema = parts.length == 2 ? parts[0] + "\"" : null;
                name = parts.length == 2 ? "\"" + parts[1] : parts[0];
            } else {
                int lastDotIndex = fullName1.lastIndexOf(46);
                name = fullName1.substring(lastDotIndex + 1);
                schema = fullName1.substring(0, lastDotIndex);
            }
        } else {
            schema = fullName1.substring(0, dotIndex);
            name = fullName1.substring(dotIndex + 1);
        }
        if (schema != null && schema.startsWith("\"") && schema.endsWith("\"")) {
            schema = schema.substring(1, schema.length() - 1);
        } else if (schema != null) {
            schema = schema.toLowerCase();
        }
        name = name.startsWith("\"") && name.endsWith("\"") ? name.substring(1, name.length() - 1) : name.toLowerCase();
        String[] pgTypeNameParts = new String[]{schema, name};
        return pgTypeNameParts;
    }

    static {
        typeAliases.put("smallint", "int2");
        typeAliases.put("integer", "int4");
        typeAliases.put("int", "int4");
        typeAliases.put("bigint", "int8");
        typeAliases.put("float", "float8");
        typeAliases.put("boolean", "bool");
        typeAliases.put("decimal", "numeric");
        typeAliases.put("varchar2", "varchar");
    }
}

