/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.core;

import com.aliyun.polardb.core.BaseQueryKey;
import com.aliyun.polardb.core.CachedQuery;
import com.aliyun.polardb.core.CallableQueryKey;
import com.aliyun.polardb.core.JdbcCallParseInfo;
import com.aliyun.polardb.core.NativeQuery;
import com.aliyun.polardb.core.Parser;
import com.aliyun.polardb.core.Query;
import com.aliyun.polardb.core.QueryExecutor;
import com.aliyun.polardb.core.QueryWithReturningColumnsKey;
import com.aliyun.polardb.jdbc.PreferQueryMode;
import com.aliyun.polardb.util.LruCache;
import java.sql.SQLException;
import java.util.List;
import java.util.Random;

class CachedQueryCreateAction
implements LruCache.CreateAction<Object, CachedQuery> {
    private static final String[] EMPTY_RETURNING = new String[0];
    private final QueryExecutor queryExecutor;
    private boolean isUnamedProc;
    private String unamedProcName;
    private String fakeUnamedProcSql;

    CachedQueryCreateAction(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
        this.isUnamedProc = false;
        this.fakeUnamedProcSql = "";
        this.unamedProcName = "";
    }

    private String[] polar_is_unamed_proc(String sql, boolean isCallableQuery) {
        boolean isUnamedProc;
        String beginFollow;
        if (!this.queryExecutor.supportUnnamedProc()) {
            return new String[]{sql, sql};
        }
        String sqlLowerCase = sql.toLowerCase().trim();
        StringBuilder os = new StringBuilder();
        int declareStartIndex = sqlLowerCase.indexOf("declare");
        int beginStartIndex = sqlLowerCase.toLowerCase().indexOf("begin");
        int endStartIndex = sqlLowerCase.indexOf("end");
        int paramIndex = sqlLowerCase.indexOf("?");
        if (beginStartIndex >= 0 && (beginFollow = sqlLowerCase.substring(beginStartIndex + "begin".length()).trim()).length() > 0 && beginFollow.charAt(0) == ';') {
            this.resetUnnamedProcStatus();
            return new String[]{sql, sql};
        }
        boolean bl = isUnamedProc = paramIndex != -1 && (declareStartIndex == 0 || beginStartIndex == 0 && endStartIndex != -1);
        if (isUnamedProc) {
            Random rd = new Random();
            int randomSeq = rd.nextInt(1000000);
            String fakeCallStmtSql = "";
            if (isCallableQuery) {
                fakeCallStmtSql = fakeCallStmtSql + "{";
            }
            fakeCallStmtSql = fakeCallStmtSql + "call polar_unamed_proc_" + randomSeq + "(";
            boolean containParam = false;
            boolean inSingleQuote = false;
            boolean inDoubleQuote = false;
            boolean inLineComment = false;
            boolean inComment = false;
            boolean inDollarQuota = false;
            char previousChar = '\u0000';
            int osPosition = 0;
            int paramNumber = 0;
            for (int i = 0; i < sql.length(); ++i) {
                char ch = sql.charAt(i);
                switch (ch) {
                    case '\'': {
                        if (inDoubleQuote || inDollarQuota) break;
                        inSingleQuote = !inSingleQuote;
                        break;
                    }
                    case '\"': {
                        if (inSingleQuote || inDollarQuota) break;
                        inDoubleQuote = !inDoubleQuote;
                        break;
                    }
                    case '$': {
                        if (previousChar != '$' || inSingleQuote || inDoubleQuote) break;
                        inDollarQuota = !inDollarQuota;
                        break;
                    }
                    case '-': {
                        if (previousChar != '-' || inSingleQuote || inDoubleQuote || inDollarQuota) break;
                        inLineComment = true;
                        break;
                    }
                    case '/': {
                        if (inSingleQuote || inDoubleQuote || inDollarQuota) break;
                        if (previousChar == '/') {
                            inLineComment = true;
                            break;
                        }
                        if (previousChar != '*') break;
                        inComment = false;
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if (inSingleQuote || inDoubleQuote || inDollarQuota) break;
                        inLineComment = false;
                        break;
                    }
                    case '*': {
                        if (previousChar != '/' || inSingleQuote || inDoubleQuote || inDollarQuota) break;
                        inComment = true;
                        break;
                    }
                    case '?': {
                        if (inSingleQuote || inDoubleQuote || inLineComment || inComment || inDollarQuota) break;
                        containParam = true;
                        fakeCallStmtSql = fakeCallStmtSql + "?,";
                        os.append(sql.substring(osPosition, i));
                        os.append("$" + ++paramNumber);
                        osPosition = i + 1;
                    }
                }
                previousChar = ch;
            }
            if (containParam) {
                fakeCallStmtSql = fakeCallStmtSql.substring(0, fakeCallStmtSql.length() - 1);
                fakeCallStmtSql = fakeCallStmtSql + ")";
                if (isCallableQuery) {
                    fakeCallStmtSql = fakeCallStmtSql + "}";
                }
                this.isUnamedProc = true;
                this.fakeUnamedProcSql = fakeCallStmtSql;
                this.unamedProcName = "polar_unamed_proc_" + randomSeq;
                os.append(sql.substring(osPosition, sql.length()));
                return new String[]{this.fakeUnamedProcSql, os.toString()};
            }
        }
        this.resetUnnamedProcStatus();
        return new String[]{sql, sql};
    }

    private void resetUnnamedProcStatus() {
        this.isUnamedProc = false;
        this.fakeUnamedProcSql = "";
        this.unamedProcName = "";
    }

    @Override
    public CachedQuery create(Object key) throws SQLException {
        boolean isCallable;
        boolean outParmBeforeFunc;
        boolean isFunction;
        String parsedSql;
        BaseQueryKey queryKey;
        assert (key instanceof String || key instanceof BaseQueryKey) : "Query key should be String or BaseQueryKey. Given " + key.getClass() + ", sql: " + String.valueOf(key);
        if (key instanceof BaseQueryKey) {
            queryKey = (BaseQueryKey)key;
            parsedSql = queryKey.sql;
        } else {
            queryKey = null;
            parsedSql = (String)key;
        }
        boolean isCallableQuery = key instanceof CallableQueryKey;
        String[] unamed_proc_ret = this.polar_is_unamed_proc(parsedSql, isCallableQuery);
        parsedSql = unamed_proc_ret[0];
        String oriSql = unamed_proc_ret[1];
        if (key instanceof String || queryKey.escapeProcessing) {
            parsedSql = Parser.replaceProcessing(parsedSql, true, this.queryExecutor.getStandardConformingStrings());
        }
        if (key instanceof CallableQueryKey) {
            JdbcCallParseInfo callInfo = Parser.modifyJdbcCall(parsedSql, this.queryExecutor.getStandardConformingStrings(), this.queryExecutor.getServerVersionNum(), this.queryExecutor.getProtocolVersion(), this.queryExecutor.getPolarDBServer());
            parsedSql = callInfo.getSql();
            isFunction = callInfo.isFunction();
            outParmBeforeFunc = callInfo.isOutParmBeforeFunc();
            isCallable = callInfo.isCallable();
        } else {
            isFunction = false;
            outParmBeforeFunc = false;
            isCallable = false;
        }
        boolean isParameterized = key instanceof String || queryKey.isParameterized;
        boolean splitStatements = isParameterized || this.queryExecutor.getPreferQueryMode().compareTo(PreferQueryMode.EXTENDED) >= 0;
        String[] returningColumns = key instanceof QueryWithReturningColumnsKey ? ((QueryWithReturningColumnsKey)key).columnNames : EMPTY_RETURNING;
        List<NativeQuery> queries = Parser.parseJdbcSql(parsedSql, this.queryExecutor.getStandardConformingStrings(), isParameterized, splitStatements, this.queryExecutor.isReWriteBatchedInsertsEnabled(), this.queryExecutor.getSkipQuotesOnReturning(), this.queryExecutor.getAllowMultipleQueryPerStatement(), this.queryExecutor.isNamedParam(), returningColumns);
        Query query = this.queryExecutor.wrap(queries);
        if (this.isUnamedProc) {
            return new CachedQuery(key, query, isFunction, outParmBeforeFunc, isCallable, this.isUnamedProc, this.unamedProcName, this.fakeUnamedProcSql, oriSql);
        }
        return new CachedQuery(key, query, isFunction, outParmBeforeFunc, isCallable);
    }
}

