/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.ssl;

import com.aliyun.polardb.PGProperty;
import com.aliyun.polardb.jdbc.SslMode;
import com.aliyun.polardb.ssl.LazyKeyManager;
import com.aliyun.polardb.ssl.NonValidatingFactory;
import com.aliyun.polardb.ssl.WrappedFactory;
import com.aliyun.polardb.util.GT;
import com.aliyun.polardb.util.ObjectFactory;
import com.aliyun.polardb.util.PSQLException;
import com.aliyun.polardb.util.PSQLState;
import java.io.Console;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class LibPQFactory
extends WrappedFactory {
    LazyKeyManager km;

    public LibPQFactory(Properties info) throws PSQLException {
        try {
            TrustManager[] tm;
            CallbackHandler cbh;
            String sslpasswordcallback;
            String sslkeyfile;
            SSLContext ctx = SSLContext.getInstance("TLS");
            String pathsep = System.getProperty("file.separator");
            boolean defaultfile = false;
            String defaultdir = System.getProperty("os.name").toLowerCase().contains("windows") ? System.getenv("APPDATA") + pathsep + "postgresql" + pathsep : System.getProperty("user.home") + pathsep + ".postgresql" + pathsep;
            String sslcertfile = PGProperty.SSL_CERT.get(info);
            if (sslcertfile == null) {
                defaultfile = true;
                sslcertfile = defaultdir + "postgresql.crt";
            }
            if ((sslkeyfile = PGProperty.SSL_KEY.get(info)) == null) {
                defaultfile = true;
                sslkeyfile = defaultdir + "postgresql.pk8";
            }
            if ((sslpasswordcallback = PGProperty.SSL_PASSWORD_CALLBACK.get(info)) != null) {
                try {
                    cbh = (CallbackHandler)ObjectFactory.instantiate(sslpasswordcallback, info, false, null);
                }
                catch (Exception e) {
                    throw new PSQLException(GT.tr("The password callback class provided {0} could not be instantiated.", sslpasswordcallback), PSQLState.CONNECTION_FAILURE, (Throwable)e);
                }
            } else {
                cbh = new ConsoleCallbackHandler(PGProperty.SSL_PASSWORD.get(info));
            }
            this.km = new LazyKeyManager("".equals(sslcertfile) ? null : sslcertfile, "".equals(sslkeyfile) ? null : sslkeyfile, cbh, defaultfile);
            SslMode sslMode = SslMode.of(info);
            if (!sslMode.verifyCertificate()) {
                tm = new TrustManager[]{new NonValidatingFactory.NonValidatingTM()};
            } else {
                FileInputStream fis;
                KeyStore ks;
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
                try {
                    ks = KeyStore.getInstance("jks");
                }
                catch (KeyStoreException e) {
                    throw new NoSuchAlgorithmException("jks KeyStore not available");
                }
                String sslrootcertfile = PGProperty.SSL_ROOT_CERT.get(info);
                if (sslrootcertfile == null) {
                    sslrootcertfile = defaultdir + "root.crt";
                }
                try {
                    fis = new FileInputStream(sslrootcertfile);
                }
                catch (FileNotFoundException ex) {
                    throw new PSQLException(GT.tr("Could not open SSL root certificate file {0}.", sslrootcertfile), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
                }
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    Certificate[] certs = cf.generateCertificates(fis).toArray(new Certificate[0]);
                    ks.load(null, null);
                    for (int i = 0; i < certs.length; ++i) {
                        ks.setCertificateEntry("cert" + i, certs[i]);
                    }
                    tmf.init(ks);
                }
                catch (IOException ioex) {
                    throw new PSQLException(GT.tr("Could not read SSL root certificate file {0}.", sslrootcertfile), PSQLState.CONNECTION_FAILURE, (Throwable)ioex);
                }
                catch (GeneralSecurityException gsex) {
                    throw new PSQLException(GT.tr("Loading the SSL root certificate {0} into a TrustManager failed.", sslrootcertfile), PSQLState.CONNECTION_FAILURE, (Throwable)gsex);
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
                tm = tmf.getTrustManagers();
            }
            try {
                ctx.init(new KeyManager[]{this.km}, tm, null);
            }
            catch (KeyManagementException ex) {
                throw new PSQLException(GT.tr("Could not initialize SSL context.", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
            }
            this.factory = ctx.getSocketFactory();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new PSQLException(GT.tr("Could not find a java cryptographic algorithm: {0}.", ex.getMessage()), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
    }

    public void throwKeyManagerException() throws PSQLException {
        if (this.km != null) {
            this.km.throwKeyManagerException();
        }
    }

    public static class ConsoleCallbackHandler
    implements CallbackHandler {
        private char[] password = null;

        ConsoleCallbackHandler(String password) {
            if (password != null) {
                this.password = password.toCharArray();
            }
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            Console cons = System.console();
            if (cons == null && this.password == null) {
                throw new UnsupportedCallbackException(callbacks[0], "Console is not available");
            }
            for (Callback callback : callbacks) {
                if (!(callback instanceof PasswordCallback)) {
                    throw new UnsupportedCallbackException(callback);
                }
                PasswordCallback pwdCallback = (PasswordCallback)callback;
                if (this.password != null) {
                    pwdCallback.setPassword(this.password);
                    continue;
                }
                pwdCallback.setPassword(cons.readPassword("%s", pwdCallback.getPrompt()));
            }
        }
    }
}

