/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.jdbc2;

import com.aliyun.polardb.Driver;
import com.aliyun.polardb.core.BaseConnection;
import com.aliyun.polardb.util.StructUtils;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class Struct
implements java.sql.Struct {
    private int oid;
    protected BaseConnection connection = null;
    private String sqlTypeName = null;
    protected String attributesString = null;
    protected List attributeOids = null;
    boolean standardConformingStrings = false;

    private Struct(BaseConnection connection, int oid) throws SQLException {
        this.connection = connection;
        this.oid = oid;
        this.sqlTypeName = connection.getTypeInfo().getPGType(oid);
        this.standardConformingStrings = connection.getStandardConformingStrings();
    }

    public Struct(BaseConnection connection, int oid, String attributesString) throws SQLException {
        this(connection, oid);
        this.attributesString = attributesString;
    }

    public Struct(BaseConnection connection, int oid, Object[] attributes) throws SQLException {
        this(connection, oid);
        this.attributeOids = this.getAttributesOids();
        this.attributesString = StructUtils.toString(connection, attributes, this.standardConformingStrings, true);
    }

    public int getOid() {
        return this.oid;
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        if (this.attributeOids == null) {
            this.attributeOids = this.getAttributesOids();
        }
        return StructUtils.parse(this.connection, this.attributeOids, this.attributesString).toArray();
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.sqlTypeName;
    }

    public Object[] getAttributes(Map map) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getAttributes(Map)");
    }

    private List getAttributesOids() throws SQLException {
        return this.connection.getTypeInfo().getStructAttributes(this.oid);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        boolean result = false;
        if (obj instanceof Struct) {
            Struct temp = (Struct)obj;
            result = this.toString().equals(temp.toString());
            if (result) {
                boolean bl = this.sqlTypeName == null || temp.sqlTypeName == null ? true : (result = this.sqlTypeName != null ? this.sqlTypeName.equals(temp.sqlTypeName) : temp.sqlTypeName.equals(this.sqlTypeName));
            }
            if (result) {
                result = this.standardConformingStrings == temp.standardConformingStrings;
            }
        }
        return result;
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + (this.attributesString != null ? this.attributesString.hashCode() : 0);
        hash = 73 * hash + (this.sqlTypeName != null ? this.sqlTypeName.hashCode() : 0);
        hash = 73 * hash + (this.standardConformingStrings ? 1 : 0);
        return hash;
    }

    public String toString() {
        if (this.attributesString != null) {
            return this.attributesString;
        }
        return "NULL";
    }
}

