/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb.jdbc;

import com.aliyun.polardb.Driver;
import com.aliyun.polardb.PGNotification;
import com.aliyun.polardb.PGProperty;
import com.aliyun.polardb.copy.CopyManager;
import com.aliyun.polardb.core.BaseConnection;
import com.aliyun.polardb.core.BaseStatement;
import com.aliyun.polardb.core.CachedQuery;
import com.aliyun.polardb.core.ConnectionFactory;
import com.aliyun.polardb.core.Encoding;
import com.aliyun.polardb.core.Oid;
import com.aliyun.polardb.core.Provider;
import com.aliyun.polardb.core.Query;
import com.aliyun.polardb.core.QueryExecutor;
import com.aliyun.polardb.core.ReplicationProtocol;
import com.aliyun.polardb.core.ResultHandlerBase;
import com.aliyun.polardb.core.ServerVersion;
import com.aliyun.polardb.core.SqlCommand;
import com.aliyun.polardb.core.TransactionState;
import com.aliyun.polardb.core.TypeInfo;
import com.aliyun.polardb.core.Utils;
import com.aliyun.polardb.core.Version;
import com.aliyun.polardb.fastpath.Fastpath;
import com.aliyun.polardb.geometric.PGbox;
import com.aliyun.polardb.geometric.PGcircle;
import com.aliyun.polardb.geometric.PGline;
import com.aliyun.polardb.geometric.PGlseg;
import com.aliyun.polardb.geometric.PGpath;
import com.aliyun.polardb.geometric.PGpoint;
import com.aliyun.polardb.geometric.PGpolygon;
import com.aliyun.polardb.jdbc.AutoSave;
import com.aliyun.polardb.jdbc.FieldMetadata;
import com.aliyun.polardb.jdbc.PSQLSavepoint;
import com.aliyun.polardb.jdbc.PgArray;
import com.aliyun.polardb.jdbc.PgBlob;
import com.aliyun.polardb.jdbc.PgBlobBytea;
import com.aliyun.polardb.jdbc.PgCallableStatement;
import com.aliyun.polardb.jdbc.PgClob;
import com.aliyun.polardb.jdbc.PgClobText;
import com.aliyun.polardb.jdbc.PgDatabaseMetaData;
import com.aliyun.polardb.jdbc.PgPreparedStatement;
import com.aliyun.polardb.jdbc.PgSQLXML;
import com.aliyun.polardb.jdbc.PgStatement;
import com.aliyun.polardb.jdbc.PreferQueryMode;
import com.aliyun.polardb.jdbc.PrimitiveArraySupport;
import com.aliyun.polardb.jdbc.TimestampUtils;
import com.aliyun.polardb.jdbc.TypeInfoCache;
import com.aliyun.polardb.jdbc2.Struct;
import com.aliyun.polardb.largeobject.LargeObjectManager;
import com.aliyun.polardb.replication.PGReplicationConnection;
import com.aliyun.polardb.replication.PGReplicationConnectionImpl;
import com.aliyun.polardb.util.GT;
import com.aliyun.polardb.util.HostSpec;
import com.aliyun.polardb.util.LruCache;
import com.aliyun.polardb.util.PGBinaryObject;
import com.aliyun.polardb.util.PGInterval;
import com.aliyun.polardb.util.PGmoney;
import com.aliyun.polardb.util.PGobject;
import com.aliyun.polardb.util.PSQLException;
import com.aliyun.polardb.util.PSQLState;
import com.aliyun.polardb.util.PolarCompMode;
import com.aliyun.polardb.util.StructUtils;
import com.aliyun.polardb.xml.DefaultPGXmlFactoryFactory;
import com.aliyun.polardb.xml.LegacyInsecurePGXmlFactoryFactory;
import com.aliyun.polardb.xml.PGXmlFactoryFactory;
import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PgConnection
implements BaseConnection {
    private static final Logger LOGGER = Logger.getLogger(PgConnection.class.getName());
    private static final SQLPermission SQL_PERMISSION_ABORT = new SQLPermission("callAbort");
    private static final SQLPermission SQL_PERMISSION_NETWORK_TIMEOUT = new SQLPermission("setNetworkTimeout");
    private final Properties clientInfo;
    private final String creatingURL;
    private Throwable openStackTrace;
    private final QueryExecutor queryExecutor;
    private final String dbVersionNumber;
    private boolean skipQuotesOnReturning = false;
    private final Query commitQuery;
    private final Query rollbackQuery;
    private final TypeInfo typeCache;
    private boolean disableColumnSanitiser = false;
    protected int prepareThreshold;
    protected int defaultFetchSize;
    protected int defaultPolarMaxFetchSize;
    protected boolean forcebinary = false;
    private int rsHoldability = 2;
    private int savepointId = 0;
    private boolean autoCommit = true;
    private boolean readOnly = false;
    private boolean polarFetchCrossCommit = false;
    private boolean bindStringAsVarchar;
    private boolean blobAsBytea = false;
    private boolean clobAsText = false;
    private boolean polarComp = true;
    private int oracleCase = 0;
    private boolean autoCommitSpecCompliant = true;
    private boolean supportRowId = false;
    private PolarCompMode compMode = PolarCompMode.POLARDB;
    private boolean unknownDateType = true;
    private boolean boolAsInt = false;
    private boolean mapDateToTimestamp = false;
    private boolean collectWarning = true;
    private SQLWarning firstWarning = null;
    private volatile Timer cancelTimer = null;
    private PreparedStatement checkConnectionQuery;
    private final boolean replicationConnection;
    private final LruCache<FieldMetadata.Key, FieldMetadata> fieldMetadataCache;
    private final String xmlFactoryFactoryClass;
    private PGXmlFactoryFactory xmlFactoryFactory;
    private final TimestampUtils timestampUtils;
    protected Map<String, Class<?>> typemap;
    private Fastpath fastpath = null;
    private LargeObjectManager largeobject = null;
    protected DatabaseMetaData metadata;
    private CopyManager copyManager = null;
    private String serverName;

    final CachedQuery borrowQuery(String sql) throws SQLException {
        return this.queryExecutor.borrowQuery(sql);
    }

    final CachedQuery borrowCallableQuery(String sql) throws SQLException {
        return this.queryExecutor.borrowCallableQuery(sql);
    }

    private CachedQuery borrowReturningQuery(String sql, String[] columnNames) throws SQLException {
        return this.queryExecutor.borrowReturningQuery(sql, columnNames);
    }

    @Override
    public CachedQuery createQuery(String sql, boolean escapeProcessing, boolean isParameterized, String ... columnNames) throws SQLException {
        return this.queryExecutor.createQuery(sql, escapeProcessing, isParameterized, columnNames);
    }

    void releaseQuery(CachedQuery cachedQuery) {
        this.queryExecutor.releaseQuery(cachedQuery);
    }

    @Override
    public void setFlushCacheOnDeallocate(boolean flushCacheOnDeallocate) {
        this.queryExecutor.setFlushCacheOnDeallocate(flushCacheOnDeallocate);
        LOGGER.log(Level.FINE, "  setFlushCacheOnDeallocate = {0}", flushCacheOnDeallocate);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PgConnection(HostSpec[] hostSpecs, String user, String database, Properties info, String url) throws SQLException {
        String stringType;
        this.dbVersionNumber = null;
        LOGGER.log(Level.FINE, "PolarDB JDBC Driver 42.2.9.1.6");
        this.creatingURL = url;
        this.setDefaultFetchSize(PGProperty.DEFAULT_ROW_FETCH_SIZE.getInt(info));
        this.setDefaultPolarMaxFetchSize(PGProperty.DEFAULT_POLAR_MAX_FETCH_SIZE.getInt(info));
        this.setPrepareThreshold(PGProperty.PREPARE_THRESHOLD.getInt(info));
        if (this.prepareThreshold == -1) {
            this.setForceBinary(true);
        }
        this.polarSetParameters(info);
        this.queryExecutor = ConnectionFactory.openConnection(hostSpecs, user, database, info);
        if (LOGGER.isLoggable(Level.WARNING) && !this.haveMinimumServerVersion(ServerVersion.v8_2)) {
            LOGGER.log(Level.WARNING, "Unsupported Server Version: {0}", this.queryExecutor.getServerVersion());
        }
        if (PGProperty.READ_ONLY.getBoolean(info)) {
            this.setReadOnly(true);
        }
        if (PGProperty.POLAR_FETCH_CROSS_COMMIT.getBoolean(info)) {
            this.setPolarFetchCrossCommit(true, PGProperty.POLAR_MAX_PORTALS.getInteger(info));
        }
        Set<Integer> binaryOids = PgConnection.getBinaryOids(info);
        HashSet<Integer> useBinarySendForOids = new HashSet<Integer>(binaryOids);
        HashSet<Integer> useBinaryReceiveForOids = new HashSet<Integer>(binaryOids);
        useBinarySendForOids.remove(1082);
        this.queryExecutor.setBinaryReceiveOids(useBinaryReceiveForOids);
        this.queryExecutor.setBinarySendOids(useBinarySendForOids);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "    types using binary send = {0}", this.oidsToString(useBinarySendForOids));
            LOGGER.log(Level.FINEST, "    types using binary receive = {0}", this.oidsToString(useBinaryReceiveForOids));
            LOGGER.log(Level.FINEST, "    integer date/time = {0}", this.queryExecutor.getIntegerDateTimes());
        }
        if ((stringType = PGProperty.STRING_TYPE.get(info)) != null) {
            if (stringType.equalsIgnoreCase("unspecified")) {
                this.bindStringAsVarchar = false;
            } else {
                if (!stringType.equalsIgnoreCase("varchar")) throw new PSQLException(GT.tr("Unsupported value for stringtype parameter: {0}", stringType), PSQLState.INVALID_PARAMETER_VALUE);
                this.bindStringAsVarchar = true;
            }
        } else {
            this.bindStringAsVarchar = true;
        }
        if (PGProperty.CLOB_AS_TEXT.getBoolean(info)) {
            this.clobAsText = true;
        }
        if (PGProperty.BLOB_AS_BYTEA.getBoolean(info)) {
            this.blobAsBytea = true;
        }
        this.timestampUtils = new TimestampUtils(!this.queryExecutor.getIntegerDateTimes(), new Provider<TimeZone>(){

            @Override
            public TimeZone get() {
                return PgConnection.this.queryExecutor.getTimeZone();
            }
        });
        this.commitQuery = this.createQuery((String)"COMMIT", (boolean)false, (boolean)true, (String[])new String[0]).query;
        this.rollbackQuery = this.createQuery((String)"ROLLBACK", (boolean)false, (boolean)true, (String[])new String[0]).query;
        int unknownLength = PGProperty.UNKNOWN_LENGTH.getInt(info);
        this.typeCache = this.createTypeInfo(this, unknownLength);
        this.initObjectTypes(info);
        if (PGProperty.LOG_UNCLOSED_CONNECTIONS.getBoolean(info)) {
            this.openStackTrace = new Throwable("Connection was created at this point:");
        }
        this.disableColumnSanitiser = PGProperty.DISABLE_COLUMN_SANITISER.getBoolean(info);
        if (this.haveMinimumServerVersion(ServerVersion.v8_3)) {
            this.typeCache.addCoreType("uuid", 2950, 1111, "java.util.UUID", 2951);
            this.typeCache.addCoreType("xml", 142, 2009, "java.sql.SQLXML", 143);
        }
        this.clientInfo = new Properties();
        if (this.haveMinimumServerVersion(ServerVersion.v9_0)) {
            String appName = PGProperty.APPLICATION_NAME.get(info);
            if (appName == null) {
                appName = "";
            }
            this.clientInfo.put("ApplicationName", appName);
        }
        this.fieldMetadataCache = new LruCache(Math.max(0, PGProperty.DATABASE_METADATA_CACHE_FIELDS.getInt(info)), Math.max(0, PGProperty.DATABASE_METADATA_CACHE_FIELDS_MIB.getInt(info) * 1024 * 1024), false);
        this.replicationConnection = PGProperty.REPLICATION.get(info) != null;
        this.xmlFactoryFactoryClass = PGProperty.XML_FACTORY_FACTORY.get(info);
    }

    private static Set<Integer> getBinaryOids(Properties info) throws PSQLException {
        boolean binaryTransfer = PGProperty.BINARY_TRANSFER.getBoolean(info);
        HashSet<Integer> binaryOids = new HashSet<Integer>(32);
        if (binaryTransfer) {
            binaryOids.add(17);
            binaryOids.add(21);
            binaryOids.add(23);
            binaryOids.add(20);
            binaryOids.add(700);
            binaryOids.add(701);
            binaryOids.add(1083);
            binaryOids.add(1082);
            binaryOids.add(1266);
            binaryOids.add(1114);
            binaryOids.add(1184);
            binaryOids.add(1005);
            binaryOids.add(1007);
            binaryOids.add(1016);
            binaryOids.add(1021);
            binaryOids.add(1022);
            binaryOids.add(1015);
            binaryOids.add(1009);
            binaryOids.add(600);
            binaryOids.add(603);
            binaryOids.add(2950);
        }
        binaryOids.addAll(PgConnection.getOidSet(PGProperty.BINARY_TRANSFER_ENABLE.get(info)));
        binaryOids.removeAll(PgConnection.getOidSet(PGProperty.BINARY_TRANSFER_DISABLE.get(info)));
        return binaryOids;
    }

    private static Set<Integer> getOidSet(String oidList) throws PSQLException {
        HashSet<Integer> oids = new HashSet<Integer>();
        StringTokenizer tokenizer = new StringTokenizer(oidList, ",");
        while (tokenizer.hasMoreTokens()) {
            String oid = tokenizer.nextToken();
            oids.add(Oid.valueOf(oid));
        }
        return oids;
    }

    private String oidsToString(Set<Integer> oids) {
        StringBuilder sb = new StringBuilder();
        for (Integer oid : oids) {
            sb.append(Oid.toString(oid));
            sb.append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        } else {
            sb.append(" <none>");
        }
        return sb.toString();
    }

    @Override
    public TimestampUtils getTimestampUtils() {
        return this.timestampUtils;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        return this.typemap;
    }

    @Override
    public QueryExecutor getQueryExecutor() {
        return this.queryExecutor;
    }

    @Override
    public ReplicationProtocol getReplicationProtocol() {
        return this.queryExecutor.getReplicationProtocol();
    }

    public void addWarning(SQLWarning warn) {
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(warn);
        } else {
            this.firstWarning = warn;
        }
    }

    @Override
    public ResultSet execSQLQuery(String s) throws SQLException {
        return this.execSQLQuery(s, 1003, 1007);
    }

    @Override
    public ResultSet execSQLQuery(String s, int resultSetType, int resultSetConcurrency) throws SQLException {
        BaseStatement stat = (BaseStatement)this.createStatement(resultSetType, resultSetConcurrency);
        boolean hasResultSet = stat.executeWithFlags(s, 16);
        while (!hasResultSet && stat.getUpdateCount() != -1) {
            hasResultSet = stat.getMoreResults();
        }
        if (!hasResultSet) {
            throw new PSQLException(GT.tr("No results were returned by the query.", new Object[0]), PSQLState.NO_DATA);
        }
        SQLWarning warnings = stat.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        return stat.getResultSet();
    }

    @Override
    public void execSQLUpdate(String s) throws SQLException {
        BaseStatement stmt = (BaseStatement)this.createStatement();
        if (stmt.executeWithFlags(s, 22)) {
            throw new PSQLException(GT.tr("A result was returned when none was expected.", new Object[0]), PSQLState.TOO_MANY_RESULTS);
        }
        SQLWarning warnings = stmt.getWarnings();
        if (warnings != null) {
            this.addWarning(warnings);
        }
        stmt.close();
    }

    public void setCursorName(String cursor) throws SQLException {
        this.checkClosed();
    }

    public String getCursorName() throws SQLException {
        this.checkClosed();
        return null;
    }

    public String getURL() throws SQLException {
        return this.creatingURL;
    }

    public String getUserName() throws SQLException {
        return this.queryExecutor.getUser();
    }

    @Override
    public Fastpath getFastpathAPI() throws SQLException {
        this.checkClosed();
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this);
        }
        return this.fastpath;
    }

    @Override
    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        this.checkClosed();
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager(this);
        }
        return this.largeobject;
    }

    @Override
    public boolean getClobAsText() {
        return this.clobAsText;
    }

    @Override
    public boolean getBlobAsBytea() {
        return this.blobAsBytea;
    }

    @Override
    public Object getObject(String type, String value, byte[] byteValue) throws SQLException {
        Class<?> c;
        if (this.typemap != null && (c = this.typemap.get(type)) != null) {
            throw new PSQLException(GT.tr("Custom type maps are not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
        }
        PGobject obj = null;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Constructing object from type={0} value=<{1}>", new Object[]{type, value});
        }
        try {
            Class<? extends PGobject> klass = this.typeCache.getPGobject(type);
            if (klass != null) {
                obj = klass.newInstance();
                obj.setType(type);
                if (byteValue != null && obj instanceof PGBinaryObject) {
                    PGBinaryObject binObj = (PGBinaryObject)((Object)obj);
                    binObj.setByteValue(byteValue, 0);
                } else {
                    obj.setValue(value);
                }
            } else {
                obj = new PGobject();
                obj.setType(type);
                obj.setValue(value);
            }
            return obj;
        }
        catch (SQLException sx) {
            throw sx;
        }
        catch (Exception ex) {
            throw new PSQLException(GT.tr("Failed to create object for: {0}.", type), PSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
    }

    protected TypeInfo createTypeInfo(BaseConnection conn, int unknownLength) {
        return new TypeInfoCache(conn, unknownLength);
    }

    @Override
    public TypeInfo getTypeInfo() {
        return this.typeCache;
    }

    @Override
    public void addDataType(String type, String name) {
        try {
            this.addDataType(type, Class.forName(name).asSubclass(PGobject.class));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot register new type: " + e);
        }
    }

    @Override
    public void addDataType(String type, Class<? extends PGobject> klass) throws SQLException {
        this.checkClosed();
        this.typeCache.addDataType(type, klass);
    }

    private void initObjectTypes(Properties info) throws SQLException {
        this.addDataType("box", PGbox.class);
        this.addDataType("circle", PGcircle.class);
        this.addDataType("line", PGline.class);
        this.addDataType("lseg", PGlseg.class);
        this.addDataType("path", PGpath.class);
        this.addDataType("point", PGpoint.class);
        this.addDataType("polygon", PGpolygon.class);
        this.addDataType("money", PGmoney.class);
        this.addDataType("interval", PGInterval.class);
        Enumeration<?> e = info.propertyNames();
        while (e.hasMoreElements()) {
            Class<?> klass;
            String propertyName = (String)e.nextElement();
            if (!propertyName.startsWith("datatype.")) continue;
            String typeName = propertyName.substring(9);
            String className = info.getProperty(propertyName);
            try {
                klass = Class.forName(className);
            }
            catch (ClassNotFoundException cnfe) {
                throw new PSQLException(GT.tr("Unable to load the class {0} responsible for the datatype {1}", className, typeName), PSQLState.SYSTEM_ERROR, (Throwable)cnfe);
            }
            this.addDataType(typeName, klass.asSubclass(PGobject.class));
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.queryExecutor == null) {
            return;
        }
        this.releaseTimer();
        this.queryExecutor.close();
        this.openStackTrace = null;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        CachedQuery cachedQuery = this.queryExecutor.createQuery(sql, false, true, new String[0]);
        return cachedQuery.query.getNativeSql();
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        SQLWarning newWarnings = this.queryExecutor.getWarnings();
        if (this.firstWarning == null) {
            this.firstWarning = newWarnings;
        } else {
            this.firstWarning.setNextWarning(newWarnings);
        }
        return this.firstWarning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.queryExecutor.getWarnings();
        this.firstWarning = null;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        if (this.queryExecutor.getTransactionState() != TransactionState.IDLE) {
            throw new PSQLException(GT.tr("Cannot change transaction read-only property in the middle of a transaction.", new Object[0]), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        if (readOnly != this.readOnly) {
            String readOnlySql = "SET SESSION CHARACTERISTICS AS TRANSACTION " + (readOnly ? "READ ONLY" : "READ WRITE");
            this.execSQLUpdate(readOnlySql);
        }
        this.readOnly = readOnly;
        LOGGER.log(Level.FINE, "  setReadOnly = {0}", readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.readOnly;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (!this.autoCommit) {
            this.commit();
        }
        this.autoCommit = autoCommit;
        LOGGER.log(Level.FINE, "  setAutoCommit = {0}", autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.autoCommit;
    }

    private void executeTransactionCommand(Query query) throws SQLException {
        int flags = 22;
        if (this.prepareThreshold == 0) {
            flags |= 1;
        }
        try {
            this.getQueryExecutor().execute(query, null, new TransactionCommandHandler(), 0, 0, 0, flags, false, false);
        }
        catch (SQLException e) {
            if (query.getSubqueries() != null || !this.queryExecutor.willHealOnRetry(e)) {
                throw e;
            }
            query.close();
            this.getQueryExecutor().execute(query, null, new TransactionCommandHandler(), 0, 0, 0, flags, false, false);
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        if (this.autoCommit && this.autoCommitSpecCompliant) {
            throw new PSQLException(GT.tr("Cannot commit when autoCommit is enabled.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.queryExecutor.getTransactionState() != TransactionState.IDLE) {
            this.executeTransactionCommand(this.commitQuery);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new PSQLException(GT.tr("This connection has been closed.", new Object[0]), PSQLState.CONNECTION_DOES_NOT_EXIST);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        if (this.autoCommit && this.autoCommitSpecCompliant) {
            throw new PSQLException(GT.tr("Cannot rollback when autoCommit is enabled.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        if (this.queryExecutor.getTransactionState() != TransactionState.IDLE) {
            this.executeTransactionCommand(this.rollbackQuery);
        } else {
            LOGGER.log(Level.FINE, "Rollback requested but no transaction in progress");
        }
    }

    @Override
    public TransactionState getTransactionState() {
        return this.queryExecutor.getTransactionState();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        String level = null;
        ResultSet rs = this.execSQLQuery("SHOW TRANSACTION ISOLATION LEVEL");
        if (rs.next()) {
            level = rs.getString(1);
        }
        rs.close();
        if (level == null) {
            return 2;
        }
        if ((level = level.toUpperCase(Locale.US)).equals("READ COMMITTED")) {
            return 2;
        }
        if (level.equals("READ UNCOMMITTED")) {
            return 1;
        }
        if (level.equals("REPEATABLE READ")) {
            return 4;
        }
        if (level.equals("SERIALIZABLE")) {
            return 8;
        }
        return 2;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        if (this.queryExecutor.getTransactionState() != TransactionState.IDLE) {
            throw new PSQLException(GT.tr("Cannot change transaction isolation level in the middle of a transaction.", new Object[0]), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        String isolationLevelName = this.getIsolationLevelName(level);
        if (isolationLevelName == null) {
            throw new PSQLException(GT.tr("Transaction isolation level {0} not supported.", level), PSQLState.NOT_IMPLEMENTED);
        }
        String isolationLevelSQL = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + isolationLevelName;
        this.execSQLUpdate(isolationLevelSQL);
        LOGGER.log(Level.FINE, "  setTransactionIsolation = {0}", isolationLevelName);
    }

    protected String getIsolationLevelName(int level) {
        switch (level) {
            case 2: {
                return "READ COMMITTED";
            }
            case 8: {
                return "SERIALIZABLE";
            }
            case 1: {
                return "READ UNCOMMITTED";
            }
            case 4: {
                return "REPEATABLE READ";
            }
        }
        return null;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.queryExecutor.getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.openStackTrace != null) {
                LOGGER.log(Level.WARNING, GT.tr("Finalizing a Connection that was never closed:", new Object[0]), this.openStackTrace);
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public String getDBVersionNumber() {
        return this.queryExecutor.getServerVersion();
    }

    public int getServerMajorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.queryExecutor.getServerVersion(), ".");
            return PgConnection.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    public int getServerMinorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.queryExecutor.getServerVersion(), ".");
            versionTokens.nextToken();
            return PgConnection.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    @Override
    public boolean haveMinimumServerVersion(int ver) {
        return this.queryExecutor.getServerVersionNum() >= ver;
    }

    @Override
    public boolean haveMinimumServerVersion(Version ver) {
        return this.haveMinimumServerVersion(ver.getVersionNum());
    }

    @Override
    public Encoding getEncoding() {
        return this.queryExecutor.getEncoding();
    }

    @Override
    public byte[] encodeString(String str) throws SQLException {
        try {
            return this.getEncoding().encode(str);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Unable to translate data into the desired encoding.", new Object[0]), PSQLState.DATA_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public String escapeString(String str) throws SQLException {
        return Utils.escapeLiteral(null, str, this.queryExecutor.getStandardConformingStrings()).toString();
    }

    @Override
    public boolean getStandardConformingStrings() {
        return this.queryExecutor.getStandardConformingStrings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.queryExecutor.isClosed();
    }

    @Override
    public void cancelQuery() throws SQLException {
        this.checkClosed();
        this.queryExecutor.sendQueryCancel();
    }

    @Override
    public PGNotification[] getNotifications() throws SQLException {
        return this.getNotifications(-1);
    }

    @Override
    public PGNotification[] getNotifications(int timeoutMillis) throws SQLException {
        this.checkClosed();
        this.getQueryExecutor().processNotifies(timeoutMillis);
        PGNotification[] notifications = this.queryExecutor.getNotifications();
        return notifications.length == 0 ? null : notifications;
    }

    @Override
    public int getPrepareThreshold() {
        return this.prepareThreshold;
    }

    @Override
    public void setDefaultFetchSize(int fetchSize) throws SQLException {
        if (fetchSize < 0) {
            throw new PSQLException(GT.tr("Fetch size must be a value greater to or equal to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.defaultFetchSize = fetchSize;
        LOGGER.log(Level.FINE, "  setDefaultFetchSize = {0}", fetchSize);
    }

    @Override
    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    @Override
    public int getDefaultPolarMaxFetchSize() {
        return this.defaultPolarMaxFetchSize;
    }

    @Override
    public void setDefaultPolarMaxFetchSize(int maxFetchSize) throws SQLException {
        if (maxFetchSize < 0) {
            throw new PSQLException(GT.tr("Max fetch size must be a value greater to or equal to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.defaultPolarMaxFetchSize = maxFetchSize;
        LOGGER.log(Level.FINE, "  defaultPolarMaxFetchSize = {0}", maxFetchSize);
    }

    public void setPolarFetchCrossCommit(boolean fetchCrossCommit, Integer maxPortals) throws SQLException {
        this.checkClosed();
        if (this.queryExecutor.getTransactionState() != TransactionState.IDLE) {
            throw new PSQLException(GT.tr("Cannot change transaction read-only property in the middle of a transaction.", new Object[0]), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        if (fetchCrossCommit != this.polarFetchCrossCommit) {
            String fetchCrossCommitSql = "SET polar_force_holdable_portal = " + (fetchCrossCommit ? "ON" : "OFF");
            this.execSQLUpdate(fetchCrossCommitSql);
            if (maxPortals != 0) {
                String maxPortalsSql = "SET polar_max_portals = " + maxPortals;
                this.execSQLUpdate(maxPortalsSql);
            }
        }
        this.polarFetchCrossCommit = this.polarFetchCrossCommit;
        LOGGER.log(Level.FINE, "  setPolarFetchCrossCommit = {0}", this.polarFetchCrossCommit);
    }

    @Override
    public void setPrepareThreshold(int newThreshold) {
        this.prepareThreshold = newThreshold;
        LOGGER.log(Level.FINE, "  setPrepareThreshold = {0}", newThreshold);
    }

    public boolean getForceBinary() {
        return this.forcebinary;
    }

    public void setForceBinary(boolean newValue) {
        this.forcebinary = newValue;
        LOGGER.log(Level.FINE, "  setForceBinary = {0}", newValue);
    }

    public void setTypeMapImpl(Map<String, Class<?>> map) throws SQLException {
        this.typemap = map;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    public int getProtocolVersion() {
        return this.queryExecutor.getProtocolVersion();
    }

    @Override
    public boolean getStringVarcharFlag() {
        return this.bindStringAsVarchar;
    }

    @Override
    public void setStringVarcharFlag(boolean flag) {
        this.bindStringAsVarchar = flag;
    }

    @Override
    public CopyManager getCopyAPI() throws SQLException {
        this.checkClosed();
        if (this.copyManager == null) {
            this.copyManager = new CopyManager(this);
        }
        return this.copyManager;
    }

    @Override
    public boolean binaryTransferSend(int oid) {
        return this.queryExecutor.useBinaryForSend(oid);
    }

    @Override
    public int getBackendPID() {
        return this.queryExecutor.getBackendPID();
    }

    @Override
    public boolean isColumnSanitiserDisabled() {
        return this.disableColumnSanitiser;
    }

    public void setDisableColumnSanitiser(boolean disableColumnSanitiser) {
        this.disableColumnSanitiser = disableColumnSanitiser;
        LOGGER.log(Level.FINE, "  setDisableColumnSanitiser = {0}", disableColumnSanitiser);
    }

    @Override
    public PreferQueryMode getPreferQueryMode() {
        return this.queryExecutor.getPreferQueryMode();
    }

    @Override
    public AutoSave getAutosave() {
        return this.queryExecutor.getAutoSave();
    }

    @Override
    public void setAutosave(AutoSave autoSave) {
        this.queryExecutor.setAutoSave(autoSave);
        LOGGER.log(Level.FINE, "  setAutosave = {0}", autoSave.value());
    }

    protected void abort() {
        this.queryExecutor.abort();
    }

    private synchronized Timer getTimer() {
        if (this.cancelTimer == null) {
            this.cancelTimer = Driver.getSharedTimer().getTimer();
        }
        return this.cancelTimer;
    }

    private synchronized void releaseTimer() {
        if (this.cancelTimer != null) {
            this.cancelTimer = null;
            Driver.getSharedTimer().releaseTimer();
        }
    }

    @Override
    public void addTimerTask(TimerTask timerTask, long milliSeconds) {
        Timer timer = this.getTimer();
        timer.schedule(timerTask, milliSeconds);
    }

    @Override
    public void purgeTimerTasks() {
        Timer timer = this.cancelTimer;
        if (timer != null) {
            timer.purge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readServerName() {
        String name = "PostgreSQL";
        ResultSet rs = null;
        try {
            String version;
            rs = this.execSQLQuery("select version()");
            if (rs.next() && (version = rs.getString(1)).contains("POLARDB Database Compatible with Oracle")) {
                name = "POLARDB Database Compatible with Oracle";
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        if (!name.equals("POLARDB Database Compatible with Oracle")) {
            LOGGER.log(Level.WARNING, "PolarDB JDBC driver only support polardb.");
        }
        return this.compMode.getProductName();
    }

    public String getServerName() {
        if (this.serverName == null) {
            this.serverName = this.readServerName();
        }
        return this.serverName;
    }

    @Override
    public String escapeIdentifier(String identifier) throws SQLException {
        return Utils.escapeIdentifier(null, identifier).toString();
    }

    @Override
    public String escapeLiteral(String literal) throws SQLException {
        return Utils.escapeLiteral(null, literal, this.queryExecutor.getStandardConformingStrings()).toString();
    }

    @Override
    public LruCache<FieldMetadata.Key, FieldMetadata> getFieldMetadataCache() {
        return this.fieldMetadataCache;
    }

    @Override
    public PGReplicationConnection getReplicationAPI() {
        return new PGReplicationConnectionImpl(this);
    }

    public void appendArray(StringBuilder sb, Object elements, char delim) {
        sb.append('{');
        int nElements = Array.getLength(elements);
        for (int i = 0; i < nElements; ++i) {
            String text;
            java.sql.Struct struct;
            Object o;
            if (i > 0) {
                sb.append(delim);
            }
            if ((o = Array.get(elements, i)) == null) {
                sb.append("NULL");
                continue;
            }
            if (o.getClass().isArray()) {
                PrimitiveArraySupport<Object> arraySupport = PrimitiveArraySupport.getArraySupport(o);
                if (arraySupport != null) {
                    arraySupport.appendArray(sb, delim, o);
                    continue;
                }
                this.appendArray(sb, o, delim);
                continue;
            }
            if (o instanceof Struct) {
                struct = (java.sql.Struct)o;
                text = "";
                text = struct.toString();
                PgArray.escapeArrayElement(sb, text);
                continue;
            }
            if (o instanceof java.sql.Struct) {
                struct = (java.sql.Struct)o;
                text = "";
                try {
                    text = StructUtils.toString(this, struct.getAttributes(), this.getStandardConformingStrings(), this.haveMinimumServerVersion(ServerVersion.v9_6));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                PgArray.escapeArrayElement(sb, text);
                continue;
            }
            String s = o.toString();
            PgArray.escapeArrayElement(sb, s);
        }
        sb.append('}');
    }

    private static int integerPart(String dirtyString) {
        int end;
        int start;
        for (start = 0; start < dirtyString.length() && !Character.isDigit(dirtyString.charAt(start)); ++start) {
        }
        for (end = start; end < dirtyString.length() && Character.isDigit(dirtyString.charAt(end)); ++end) {
        }
        if (start == end) {
            return 0;
        }
        return Integer.parseInt(dirtyString.substring(start, end));
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return new PgStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return new PgPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return new PgCallableStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.metadata == null) {
            this.metadata = new PgDatabaseMetaData(this);
        }
        return this.metadata;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.setTypeMapImpl(map);
        LOGGER.log(Level.FINE, "  setTypeMap = {0}", map);
    }

    protected java.sql.Array makeArray(int oid, String fieldString) throws SQLException {
        return new PgArray((BaseConnection)this, oid, fieldString);
    }

    protected Blob makeBlob(long oid) throws SQLException {
        return new PgBlob(this, oid);
    }

    protected Clob makeClob(long oid) throws SQLException {
        return new PgClob(this, oid);
    }

    protected SQLXML makeSQLXML() throws SQLException {
        return new PgSQLXML(this);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        if (this.clobAsText) {
            return new PgClobText();
        }
        throw Driver.notImplemented(this.getClass(), "createClob()");
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        if (this.blobAsBytea) {
            return new PgBlobBytea();
        }
        throw Driver.notImplemented(this.getClass(), "createBlob()");
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createNClob()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return this.makeSQLXML();
    }

    @Override
    public java.sql.Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        if (attributes == null) {
            return null;
        }
        int oid = this.getTypeInfo().getPGType(typeName);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unable to find server struct type for provided name {0}.", typeName), PSQLState.INVALID_NAME);
        }
        return new Struct((BaseConnection)this, oid, attributes);
    }

    @Override
    public java.sql.Array createArrayOf(String typeName, Object elements) throws SQLException {
        String arrayString;
        this.checkClosed();
        TypeInfo typeInfo = this.getTypeInfo();
        int oid = typeInfo.getPGArrayType(typeName);
        char delim = typeInfo.getArrayDelimiter(oid);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unable to find server array type for provided name {0}.", typeName), PSQLState.INVALID_NAME);
        }
        if (elements == null) {
            return this.makeArray(oid, null);
        }
        PrimitiveArraySupport<Object> arraySupport = PrimitiveArraySupport.getArraySupport(elements);
        if (arraySupport != null) {
            if (oid == arraySupport.getDefaultArrayTypeOid(typeInfo) && arraySupport.supportBinaryRepresentation() && this.getPreferQueryMode() != PreferQueryMode.SIMPLE) {
                return new PgArray((BaseConnection)this, oid, arraySupport.toBinaryRepresentation(this, elements));
            }
            arrayString = arraySupport.toArrayString(delim, elements);
        } else {
            Class<?> clazz = elements.getClass();
            if (!clazz.isArray()) {
                throw new PSQLException(GT.tr("Invalid elements {0}", elements), PSQLState.INVALID_PARAMETER_TYPE);
            }
            StringBuilder sb = new StringBuilder();
            this.appendArray(sb, elements, delim);
            arrayString = sb.toString();
        }
        return this.makeArray(oid, arrayString);
    }

    @Override
    public java.sql.Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        int oid = this.getTypeInfo().getPGArrayType(typeName);
        if (oid == 0) {
            throw new PSQLException(GT.tr("Unable to find server array type for provided name {0}.", typeName), PSQLState.INVALID_NAME);
        }
        if (elements == null) {
            return this.makeArray(oid, null);
        }
        char delim = this.getTypeInfo().getArrayDelimiter(oid);
        StringBuilder sb = new StringBuilder();
        this.appendArray(sb, elements, delim);
        return this.makeArray(oid, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        boolean bl;
        if (timeout < 0) {
            throw new PSQLException(GT.tr("Invalid timeout ({0}<0).", timeout), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (this.isClosed()) {
            return false;
        }
        int savedNetworkTimeOut = this.getNetworkTimeout();
        try {
            this.setNetworkTimeout(null, timeout * 1000);
            if (this.replicationConnection) {
                Statement statement = this.createStatement();
                statement.execute("IDENTIFY_SYSTEM");
                statement.close();
            } else {
                if (this.checkConnectionQuery == null) {
                    this.checkConnectionQuery = this.prepareStatement("");
                }
                this.checkConnectionQuery.setQueryTimeout(timeout);
                this.checkConnectionQuery.executeUpdate();
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                this.setNetworkTimeout(null, savedNetworkTimeOut);
                throw throwable;
            }
            catch (SQLException e) {
                if (PSQLState.IN_FAILED_SQL_TRANSACTION.getState().equals(e.getSQLState())) {
                    return true;
                }
                LOGGER.log(Level.FINE, GT.tr("Validating connection.", new Object[0]), e);
                return false;
            }
        }
        this.setNetworkTimeout(null, savedNetworkTimeOut);
        return bl;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkClosed();
        }
        catch (SQLException cause) {
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
            throw new SQLClientInfoException(GT.tr("This connection has been closed.", new Object[0]), failures, (Throwable)cause);
        }
        if (this.haveMinimumServerVersion(ServerVersion.v9_0) && "ApplicationName".equals(name)) {
            String oldValue;
            if (value == null) {
                value = "";
            }
            if (value.equals(oldValue = this.queryExecutor.getApplicationName())) {
                return;
            }
            try {
                StringBuilder sql = new StringBuilder("SET application_name = '");
                Utils.escapeLiteral(sql, value, this.getStandardConformingStrings());
                sql.append("'");
                this.execSQLUpdate(sql.toString());
            }
            catch (SQLException sqle) {
                HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
                failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
                throw new SQLClientInfoException(GT.tr("Failed to set ClientInfo property: {0}", "ApplicationName"), sqle.getSQLState(), failures, (Throwable)sqle);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "  setClientInfo = {0} {1}", new Object[]{name, value});
            }
            this.clientInfo.put(name, value);
            return;
        }
        this.addWarning(new SQLWarning(GT.tr("ClientInfo property not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED.getState()));
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkClosed();
        }
        catch (SQLException cause) {
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                failures.put((String)e.getKey(), ClientInfoStatus.REASON_UNKNOWN);
            }
            throw new SQLClientInfoException(GT.tr("This connection has been closed.", new Object[0]), failures, (Throwable)cause);
        }
        HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
        for (String name : new String[]{"ApplicationName"}) {
            try {
                this.setClientInfo(name, properties.getProperty(name, null));
            }
            catch (SQLClientInfoException e) {
                failures.putAll(e.getFailedProperties());
            }
        }
        if (!failures.isEmpty()) {
            throw new SQLClientInfoException(GT.tr("One or more ClientInfo failed.", new Object[0]), PSQLState.NOT_IMPLEMENTED.getState(), failures);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        this.clientInfo.put("ApplicationName", this.queryExecutor.getApplicationName());
        return this.clientInfo.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        this.clientInfo.put("ApplicationName", this.queryExecutor.getApplicationName());
        return this.clientInfo;
    }

    public <T> T createQueryObject(Class<T> ifc) throws SQLException {
        this.checkClosed();
        throw Driver.notImplemented(this.getClass(), "createQueryObject(Class<T>)");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        try (Statement stmt = this.createStatement();){
            ResultSet rs;
            block8: {
                String string;
                rs = stmt.executeQuery("select current_schema()");
                try {
                    if (rs.next()) break block8;
                    string = null;
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return string;
            }
            String string = rs.getString(1);
            rs.close();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        try (Statement stmt = this.createStatement();){
            if (schema == null) {
                stmt.executeUpdate("SET SESSION search_path TO DEFAULT");
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("SET SESSION search_path TO '");
                Utils.escapeLiteral(sb, schema, this.getStandardConformingStrings());
                sb.append("'");
                stmt.executeUpdate(sb.toString());
                LOGGER.log(Level.FINE, "  setSchema = {0}", schema);
            }
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw new SQLException("executor is null");
        }
        if (this.isClosed()) {
            return;
        }
        SQL_PERMISSION_ABORT.checkGuard(this);
        AbortCommand command = new AbortCommand();
        executor.execute(command);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkClosed();
        if (milliseconds < 0) {
            throw new PSQLException(GT.tr("Network timeout must be a value greater than or equal to 0.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SQL_PERMISSION_NETWORK_TIMEOUT);
        }
        try {
            this.queryExecutor.setNetworkTimeout(milliseconds);
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Unable to set network timeout.", new Object[0]), PSQLState.COMMUNICATION_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkClosed();
        try {
            return this.queryExecutor.getNetworkTimeout();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Unable to get network timeout.", new Object[0]), PSQLState.COMMUNICATION_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        switch (holdability) {
            case 2: {
                this.rsHoldability = holdability;
                break;
            }
            case 1: {
                this.rsHoldability = holdability;
                break;
            }
            default: {
                throw new PSQLException(GT.tr("Unknown ResultSet holdability setting: {0}.", holdability), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
        LOGGER.log(Level.FINE, "  setHoldability = {0}", holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw new PSQLException(GT.tr("Cannot establish a savepoint in auto-commit mode.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        PSQLSavepoint savepoint = new PSQLSavepoint(this.savepointId++);
        String pgName = savepoint.getPGName();
        Statement stmt = this.createStatement();
        stmt.executeUpdate("SAVEPOINT " + pgName);
        stmt.close();
        return savepoint;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw new PSQLException(GT.tr("Cannot establish a savepoint in auto-commit mode.", new Object[0]), PSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        PSQLSavepoint savepoint = new PSQLSavepoint(name);
        Statement stmt = this.createStatement();
        stmt.executeUpdate("SAVEPOINT " + savepoint.getPGName());
        stmt.close();
        return savepoint;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        PSQLSavepoint pgSavepoint = (PSQLSavepoint)savepoint;
        this.execSQLUpdate("ROLLBACK TO SAVEPOINT " + pgSavepoint.getPGName());
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        PSQLSavepoint pgSavepoint = (PSQLSavepoint)savepoint;
        this.execSQLUpdate("RELEASE SAVEPOINT " + pgSavepoint.getPGName());
        pgSavepoint.invalidate();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.createStatement(resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 1) {
            return this.prepareStatement(sql);
        }
        return this.prepareStatement(sql, (String[])null);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes != null && columnIndexes.length == 0) {
            return this.prepareStatement(sql);
        }
        this.checkClosed();
        throw new PSQLException(GT.tr("Returning autogenerated keys is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (columnNames != null && columnNames.length == 0) {
            return this.prepareStatement(sql);
        }
        CachedQuery cachedQuery = this.borrowReturningQuery(sql, columnNames);
        PgPreparedStatement ps = new PgPreparedStatement(this, cachedQuery, false, 1003, 1007, this.getHoldability());
        Query query = cachedQuery.query;
        SqlCommand sqlCommand = query.getSqlCommand();
        if (sqlCommand != null) {
            ps.wantsGeneratedKeysAlways = sqlCommand.isReturningKeywordPresent();
        }
        return ps;
    }

    @Override
    public final Map<String, String> getParameterStatuses() {
        return this.queryExecutor.getParameterStatuses();
    }

    @Override
    public final String getParameterStatus(String parameterName) {
        return this.queryExecutor.getParameterStatus(parameterName);
    }

    @Override
    public PGXmlFactoryFactory getXmlFactoryFactory() throws SQLException {
        if (this.xmlFactoryFactory == null) {
            if (this.xmlFactoryFactoryClass == null || this.xmlFactoryFactoryClass.equals("")) {
                this.xmlFactoryFactory = DefaultPGXmlFactoryFactory.INSTANCE;
            } else if (this.xmlFactoryFactoryClass.equals("LEGACY_INSECURE")) {
                this.xmlFactoryFactory = LegacyInsecurePGXmlFactoryFactory.INSTANCE;
            } else {
                Class<PGXmlFactoryFactory> clazz;
                try {
                    clazz = Class.forName(this.xmlFactoryFactoryClass);
                }
                catch (ClassNotFoundException ex) {
                    throw new PSQLException(GT.tr("Could not instantiate xmlFactoryFactory: {0}", this.xmlFactoryFactoryClass), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)ex);
                }
                if (!clazz.isAssignableFrom(PGXmlFactoryFactory.class)) {
                    throw new PSQLException(GT.tr("Connection property xmlFactoryFactory must implement PGXmlFactoryFactory: {0}", this.xmlFactoryFactoryClass), PSQLState.INVALID_PARAMETER_VALUE);
                }
                try {
                    this.xmlFactoryFactory = (PGXmlFactoryFactory)clazz.newInstance();
                }
                catch (Exception ex) {
                    throw new PSQLException(GT.tr("Could not instantiate xmlFactoryFactory: {0}", this.xmlFactoryFactoryClass), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)ex);
                }
            }
        }
        return this.xmlFactoryFactory;
    }

    private void polarSetParameters(Properties info) {
        this.autoCommit = PGProperty.AUTO_COMMIT.getBoolean(info);
        this.polarComp = PGProperty.POLAR_COMP.getBoolean(info);
        this.autoCommitSpecCompliant = PGProperty.AUTO_COMMIT_SPEC_COMPLIANT.getBoolean(info);
        this.supportRowId = PGProperty.SUPPORT_ROWID.getBoolean(info);
        this.compMode = PolarCompMode.forName(PGProperty.COMP_MODE.get(info));
        this.unknownDateType = PGProperty.UNKNOWN_DATE_TYPE.getBoolean(info);
        this.boolAsInt = PGProperty.BOOL_AS_INT.getBoolean(info);
        this.mapDateToTimestamp = PGProperty.MAP_DATE_TO_TIMESTAMP.getBoolean(info);
        this.collectWarning = PGProperty.COLLECT_WARNING.getBoolean(info);
        String OracleCaseLabel = PGProperty.ORACLE_CASE.get(info);
        this.oracleCase = OracleCaseLabel == null || OracleCaseLabel.equalsIgnoreCase("false") ? 0 : (OracleCaseLabel.equalsIgnoreCase("true") ? 1 : (OracleCaseLabel.equalsIgnoreCase("strict") ? 2 : 0));
    }

    @Override
    public boolean isPolarComp() {
        return this.polarComp;
    }

    @Override
    public boolean isSupportRowId() {
        return this.supportRowId;
    }

    @Override
    public boolean isOracleCase() {
        return this.oracleCase == 1;
    }

    @Override
    public boolean isOracleCaseStrict() {
        return this.oracleCase == 2;
    }

    @Override
    public boolean isUnknownDateType() {
        return this.unknownDateType;
    }

    @Override
    public boolean isBoolAsInt() {
        return this.boolAsInt;
    }

    @Override
    public boolean isMapDateToTimestamp() {
        return this.mapDateToTimestamp;
    }

    @Override
    public boolean isCollectWarning() {
        return this.collectWarning;
    }

    public class AbortCommand
    implements Runnable {
        @Override
        public void run() {
            PgConnection.this.abort();
        }
    }

    private class TransactionCommandHandler
    extends ResultHandlerBase {
        private TransactionCommandHandler() {
        }

        @Override
        public void handleCompletion() throws SQLException {
            SQLWarning warning = this.getWarning();
            if (warning != null) {
                PgConnection.this.addWarning(warning);
            }
            super.handleCompletion();
        }
    }
}

