/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb;

import com.aliyun.polardb.util.GT;
import com.aliyun.polardb.util.PSQLException;
import com.aliyun.polardb.util.PSQLState;
import java.sql.DriverPropertyInfo;
import java.util.Properties;

public enum PGProperty {
    PG_DBNAME("PGDBNAME", null, "Database name to connect to (may be specified directly in the JDBC URL)", true),
    PG_HOST("PGHOST", null, "Hostname of the PostgreSQL server (may be specified directly in the JDBC URL)", false),
    PG_PORT("PGPORT", null, "Port of the PostgreSQL server (may be specified directly in the JDBC URL)"),
    USER("user", null, "Username to connect to the database as.", true),
    PASSWORD("password", null, "Password to use when authenticating.", false),
    PROTOCOL_VERSION("protocolVersion", null, "Force use of a particular protocol version when connecting, currently only version 3 is supported.", false, "3"),
    OPTIONS("options", null, "Specify 'options' connection initialization parameter."),
    BLOB_AS_BYTEA("blobAsBytea", "false", "Treat BLOB as bytea rather than as PostgreSQL Large Objects", true),
    CLOB_AS_TEXT("clobAsText", "false", "Treat CLOB as text rather than as PostgreSQL Large Objects", true),
    LOGGER_LEVEL("loggerLevel", null, "Logger level of the driver", false, "OFF", "DEBUG", "TRACE"),
    LOGGER_FILE("loggerFile", null, "File name output of the Logger"),
    PREPARE_THRESHOLD("prepareThreshold", "5", "Statement prepare threshold. A value of {@code -1} stands for forceBinary"),
    PREPARED_STATEMENT_CACHE_QUERIES("preparedStatementCacheQueries", "256", "Specifies the maximum number of entries in per-connection cache of prepared statements. A value of {@code 0} disables the cache."),
    PREPARED_STATEMENT_CACHE_SIZE_MIB("preparedStatementCacheSizeMiB", "5", "Specifies the maximum size (in megabytes) of a per-connection prepared statement cache. A value of {@code 0} disables the cache."),
    DATABASE_METADATA_CACHE_FIELDS("databaseMetadataCacheFields", "65536", "Specifies the maximum number of fields to be cached per connection. A value of {@code 0} disables the cache."),
    DATABASE_METADATA_CACHE_FIELDS_MIB("databaseMetadataCacheFieldsMiB", "5", "Specifies the maximum size (in megabytes) of fields to be cached per connection. A value of {@code 0} disables the cache."),
    DEFAULT_ROW_FETCH_SIZE("defaultRowFetchSize", "0", "Positive number of rows that should be fetched from the database when more rows are needed for ResultSet by each fetch iteration"),
    DEFAULT_POLAR_MAX_FETCH_SIZE("defaultPolarMaxFetchSize", "0", "Max limit number of rows that should be fetched from the database when more rows are needed for ResultSet by each fetch iteration"),
    POLAR_FETCH_CROSS_COMMIT("polarFetchCrossCommit", "false", "Polar: enable fetch cross commit, which compatible with Oracle"),
    POLAR_MAX_PORTALS("polarMaxPortals", "0", "Polar: max portal count, to prevent resource leak when enable fetch cross commit."),
    BINARY_TRANSFER("binaryTransfer", "true", "Use binary format for sending and receiving data if possible"),
    READ_ONLY("readOnly", "false", "Puts this connection in read-only mode"),
    BINARY_TRANSFER_ENABLE("binaryTransferEnable", "", "Comma separated list of types to enable binary transfer. Either OID numbers or names"),
    BINARY_TRANSFER_DISABLE("binaryTransferDisable", "", "Comma separated list of types to disable binary transfer. Either OID numbers or names. Overrides values in the driver default set and values set with binaryTransferEnable."),
    STRING_TYPE("stringtype", null, "The type to bind String parameters as (usually 'varchar', 'unspecified' allows implicit casting to other types)", false, "unspecified", "varchar"),
    UNKNOWN_LENGTH("unknownLength", Integer.toString(Integer.MAX_VALUE), "Specifies the length to return for types of unknown length"),
    LOG_UNCLOSED_CONNECTIONS("logUnclosedConnections", "false", "When connections that are not explicitly closed are garbage collected, log the stacktrace from the opening of the connection to trace the leak source"),
    DISABLE_COLUMN_SANITISER("disableColumnSanitiser", "false", "Enable optimization that disables column name sanitiser"),
    SSL("ssl", null, "Control use of SSL (any non-null value causes SSL to be required)"),
    SSL_MODE("sslmode", null, "Parameter governing the use of SSL", false, "disable", "allow", "prefer", "require", "verify-ca", "verify-full"),
    SSL_FACTORY("sslfactory", null, "Provide a SSLSocketFactory class when using SSL."),
    SSL_FACTORY_ARG("sslfactoryarg", null, "Argument forwarded to constructor of SSLSocketFactory class."),
    SSL_HOSTNAME_VERIFIER("sslhostnameverifier", null, "A class, implementing javax.net.ssl.HostnameVerifier that can verify the server"),
    SSL_CERT("sslcert", null, "The location of the client's SSL certificate"),
    SSL_KEY("sslkey", null, "The location of the client's PKCS#8 SSL key"),
    SSL_ROOT_CERT("sslrootcert", null, "The location of the root certificate for authenticating the server."),
    SSL_PASSWORD("sslpassword", null, "The password for the client's ssl key (ignored if sslpasswordcallback is set)"),
    SSL_PASSWORD_CALLBACK("sslpasswordcallback", null, "A class, implementing javax.security.auth.callback.CallbackHandler that can handle PassworCallback for the ssl password."),
    TCP_KEEP_ALIVE("tcpKeepAlive", "false", "Enable or disable TCP keep-alive. The default is {@code false}."),
    LOGIN_TIMEOUT("loginTimeout", "0", "Specify how long to wait for establishment of a database connection."),
    CONNECT_TIMEOUT("connectTimeout", "10", "The timeout value used for socket connect operations."),
    SOCKET_TIMEOUT("socketTimeout", "0", "The timeout value used for socket read operations."),
    CANCEL_SIGNAL_TIMEOUT("cancelSignalTimeout", "10", "The timeout that is used for sending cancel command."),
    SOCKET_FACTORY("socketFactory", null, "Specify a socket factory for socket creation"),
    SOCKET_FACTORY_ARG("socketFactoryArg", null, "Argument forwarded to constructor of SocketFactory class."),
    RECEIVE_BUFFER_SIZE("receiveBufferSize", "-1", "Socket read buffer size"),
    SEND_BUFFER_SIZE("sendBufferSize", "-1", "Socket write buffer size"),
    ASSUME_MIN_SERVER_VERSION("assumeMinServerVersion", null, "Assume the server is at least that version"),
    APPLICATION_NAME("ApplicationName", "PolarDB JDBC Driver", "Name of the Application (backend >= 9.0)"),
    JAAS_LOGIN("jaasLogin", "true", "Login with JAAS before doing GSSAPI authentication"),
    JAAS_APPLICATION_NAME("jaasApplicationName", null, "Specifies the name of the JAAS system or application login configuration."),
    KERBEROS_SERVER_NAME("kerberosServerName", null, "The Kerberos service name to use when authenticating with GSSAPI."),
    USE_SPNEGO("useSpnego", "false", "Use SPNEGO in SSPI authentication requests"),
    XML_FACTORY_FACTORY("xmlFactoryFactory", "", "Factory class to instantiate factories for XML processing"),
    GSS_LIB("gsslib", "auto", "Force SSSPI or GSSAPI", false, "auto", "sspi", "gssapi"),
    SSPI_SERVICE_CLASS("sspiServiceClass", "POSTGRES", "The Windows SSPI service class for SPN"),
    ALLOW_ENCODING_CHANGES("allowEncodingChanges", "false", "Allow for changes in client_encoding"),
    CURRENT_SCHEMA("currentSchema", null, "Specify the schema to be set in the search-path"),
    TARGET_SERVER_TYPE("targetServerType", "any", "Specifies what kind of server to connect", false, "any", "master", "slave", "secondary", "preferSlave", "preferSyncSlave", "preferSecondary", "preferSyncSecondary"),
    LOAD_BALANCE_HOSTS("loadBalanceHosts", "false", "If disabled hosts are connected in the given order. If enabled hosts are chosen randomly from the set of suitable candidates"),
    HOST_RECHECK_SECONDS("hostRecheckSeconds", "10", "Specifies period (seconds) after which the host status is checked again in case it has changed"),
    PREFER_QUERY_MODE("preferQueryMode", "extended", "Specifies which mode is used to execute queries to database: simple means ('Q' execute, no parse, no bind, text mode only), extended means always use bind/execute messages, extendedForPrepared means extended for prepared statements only, extendedCacheEverything means use extended protocol and try cache every statement (including Statement.execute(String sql)) in a query cache.", false, "extended", "extendedForPrepared", "extendedCacheEverything", "simple"),
    AUTOSAVE("autosave", "never", "Specifies what the driver should do if a query fails. In autosave=always mode, JDBC driver sets a savepoint before each query, and rolls back to that savepoint in case of failure. In autosave=never mode (default), no savepoint dance is made ever. In autosave=conservative mode, safepoint is set for each query, however the rollback is done only for rare cases like 'cached statement cannot change return type' or 'statement XXX is not valid' so JDBC driver rollsback and retries", false, "always", "never", "conservative"),
    CLEANUP_SAVEPOINTS("cleanupSavepoints", "false", "Determine whether SAVEPOINTS used in AUTOSAVE will be released per query or not", false, "true", "false"),
    REWRITE_BATCHED_INSERTS("reWriteBatchedInserts", "false", "Enable optimization to rewrite and collapse compatible INSERT statements that are batched."),
    REPLICATION("replication", null, "Connection parameter passed in startup message, one of 'true' or 'database' Passing 'true' tells the backend to go into walsender mode, wherein a small set of replication commands can be issued instead of SQL statements. Only the simple query protocol can be used in walsender mode. Passing 'database' as the value instructs walsender to connect to the database specified in the dbname parameter, which will allow the connection to be used for logical replication from that database. (backend >= 9.4)"),
    SKIP_QUOTES_ON_RETURNING("skipQuotesOnReturning", "false", "Quotes not used for returning column names added by the driver."),
    ALLOW_MULTIPLE_QUERY_PER_STATEMENT("allowMultipleQueryPerStatement", "true", "Allow multiple create queries seperated by semicolon in one statement"),
    POLAR_COMP("polarComp", "true", "Polar Comparability or not.", false, "true", "false"),
    AUTO_COMMIT("autoCommit", "true", "Connection is autoCommit or not.", false, "true", "false"),
    EXTRA_FLOAT_DIGITS("extraFloatDigits", null, "set extraFloatDigits", false),
    NAMED_PARAM("namedParam", "false", "Use named parameters or not.", false, "true", "false"),
    SUPPORT_ROWID("supportRowId", "false", "Support rowId or not.", false, "true", "false"),
    SWALLOW_CONNECT_EXCEPTION("swallowConnectException", "true", "For multi host connection, if connection failed, log exception or not.", false, "true", "false"),
    ORACLE_CASE("oracleCase", "false", "The column name is upper case or not.", false, "true", "false", "strict"),
    AUTO_COMMIT_SPEC_COMPLIANT("autoCommitSpecCompliant", "true", "Call commit compliant or not if autoCommit is on", false, "true", "false"),
    UNNAMED_PROC("unnamedProc", "true", "Support prepared statement anonymous transaction block.", false, "true", "false"),
    UNKNOWN_DATE_TYPE("unknownDateType", "true", "Use unknown date/timestamp type or not.", false, "true", "false"),
    BOOL_AS_INT("boolAsInt", "false", "Treat bool as int or not.", false, "true", "false"),
    COMP_MODE("compMode", "polardb", "PolarDB compatibility mode", false, "polardb", "oracle", "postgresql", "polardb1"),
    MAP_DATE_TO_TIMESTAMP("mapDateToTimestamp", "true", "Map date to timestamp.", false, "true", "false"),
    SKIP_CALL_FLUSH_IF_DEADLOCK_RISK("skipCallFlushIfDeadlockRisk", "true", "skip call statement when flushIfDeadlockRisk ).", false, "true", "false"),
    RESET_NLS_FORMAT("resetNlsFormat", "true", "Reset nls_timestamp_format/nls_timestamptz_format/nls_date_format at connection startup", false, "true", "false"),
    FORCE_DRIVER_TYPE("forceDriverType", null, "PolarDB force driver type pg/ora/ora11/ora14", false, "pg", "ora", "ora11", "ora14"),
    COLLECT_WARNING("collectWarning", "true", "collect notice/warning in PLSQL", false, "true", "false");

    private String _name;
    private String _defaultValue;
    private boolean _required;
    private String _description;
    private String[] _choices;

    private PGProperty(String name, String defaultValue, String description) {
        this(name, defaultValue, description, false);
    }

    private PGProperty(String name, String defaultValue, String description, boolean required) {
        this(name, defaultValue, description, required, null);
    }

    private PGProperty(String name, String defaultValue, String description, boolean required, String ... choices) {
        this._name = name;
        this._defaultValue = defaultValue;
        this._required = required;
        this._description = description;
        this._choices = choices;
    }

    public String getName() {
        return this._name;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public String[] getChoices() {
        return this._choices;
    }

    public String get(Properties properties) {
        return properties.getProperty(this._name, this._defaultValue);
    }

    public void set(Properties properties, String value) {
        if (value == null) {
            properties.remove(this._name);
        } else {
            properties.setProperty(this._name, value);
        }
    }

    public boolean getBoolean(Properties properties) {
        return Boolean.valueOf(this.get(properties));
    }

    public int getIntNoCheck(Properties properties) {
        String value = this.get(properties);
        return Integer.parseInt(value);
    }

    public int getInt(Properties properties) throws PSQLException {
        String value = this.get(properties);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new PSQLException(GT.tr("{0} parameter value must be an integer but was: {1}", this.getName(), value), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)nfe);
        }
    }

    public Integer getInteger(Properties properties) throws PSQLException {
        String value = this.get(properties);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new PSQLException(GT.tr("{0} parameter value must be an integer but was: {1}", this.getName(), value), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)nfe);
        }
    }

    public void set(Properties properties, boolean value) {
        properties.setProperty(this._name, Boolean.toString(value));
    }

    public void set(Properties properties, int value) {
        properties.setProperty(this._name, Integer.toString(value));
    }

    public boolean isPresent(Properties properties) {
        return this.getSetString(properties) != null;
    }

    public DriverPropertyInfo toDriverPropertyInfo(Properties properties) {
        DriverPropertyInfo propertyInfo = new DriverPropertyInfo(this._name, this.get(properties));
        propertyInfo.required = this._required;
        propertyInfo.description = this._description;
        propertyInfo.choices = this._choices;
        return propertyInfo;
    }

    public static PGProperty forName(String name) {
        for (PGProperty property : PGProperty.values()) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public String getSetString(Properties properties) {
        Object o = properties.get(this._name);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }
}

