/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb2.ssl;

import com.aliyun.polardb2.ssl.PolarSSLError;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class PolarX509KeyManager
implements X509KeyManager {
    private final KeyStore keyStore;
    private final String keyAlias;
    private final char[] keyStorePassword;

    public PolarX509KeyManager(KeyStore keyStore, char[] keyStorePassword) {
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.keyAlias = PolarX509KeyManager.getKeyAlias(keyStore);
    }

    @Override
    public String[] getClientAliases(String string, Principal[] prncpls) {
        return new String[]{this.keyAlias};
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] prncpls, Socket socket) {
        return this.keyAlias;
    }

    @Override
    public String[] getServerAliases(String string, Principal[] prncpls) {
        throw new UnsupportedOperationException("This PolarX509KeyManager only supports client mode");
    }

    @Override
    public String chooseServerAlias(String string, Principal[] prncpls, Socket socket) {
        throw new UnsupportedOperationException("This PolarX509KeyManager only supports client mode");
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        try {
            Certificate[] certs = this.keyStore.getCertificateChain(alias);
            X509Certificate[] xcerts = new X509Certificate[certs.length];
            System.arraycopy(certs, 0, xcerts, 0, certs.length);
            return xcerts;
        }
        catch (KeyStoreException ex) {
            System.out.println("Could not retrieve certificate chain for polarplus client certificate.");
            return null;
        }
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        try {
            return (PrivateKey)this.keyStore.getKey(alias, this.keyStorePassword);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            System.out.println("Could not retrieve private key for polarplus client certificate.");
            return null;
        }
    }

    private X509KeyManager getDefaultKeyManager(KeyStore ks, char[] password) {
        try {
            KeyManager[] kms;
            KeyManagerFactory f = KeyManagerFactory.getInstance("SunX509");
            f.init(ks, password);
            for (KeyManager km : kms = f.getKeyManagers()) {
                if (!(km instanceof X509TrustManager)) continue;
                return (X509KeyManager)km;
            }
            throw new PolarSSLError("No default X509KeyManager found!");
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            throw new PolarSSLError(ex);
        }
    }

    private static String getKeyAlias(KeyStore keyStore) {
        String foundKeyAlias = null;
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                if (foundKeyAlias == null) {
                    foundKeyAlias = alias;
                    continue;
                }
                throw new PolarSSLError("Key store contains more than one key - aliases " + foundKeyAlias + " and " + alias);
            }
            if (foundKeyAlias == null) {
                throw new PolarSSLError("Key store contains no keys, it is empty or contains only trusted certs");
            }
        }
        catch (KeyStoreException ex) {
            throw new PolarSSLError("Error reading key store to determine key alias", ex);
        }
        return foundKeyAlias;
    }
}

